/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.wizard;

import org.apache.logging.log4j.Logger;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.tizen.installer.cli.CLIOptions;
import org.tizen.installer.core.InstallController;
import org.tizen.installer.exception.IMFatalException;
import org.tizen.installer.ui.custom.UIResource;
import org.tizen.installer.ui.wizard.WizardMaster;
import org.tizen.installer.util.Log;

public class WizardDefaultWindow {
    private static final String WINDOW_LOG_TITLE = "WizardDefaultWindow";
    private static Logger logger = Log.getLogger(WizardDefaultWindow.class);
    private StackLayout stackLayout = new StackLayout();
    private UIResource uiResource;
    private InstallController installController;
    private WizardMaster pm = null;
    private Shell shell;
    private Display display;

    public WizardDefaultWindow(InstallController installerConroller, UIResource uiResource) {
        logger.trace(WizardDefaultWindow.class.getName() + " class is created.");
        logger.trace(WizardDefaultWindow.class.getName() + " initializing start.");
        this.display = Display.getDefault();
        this.shell = new Shell(this.display, 224);
        this.shell.setImage(new Image((Device)this.display, uiResource.getImageStream(UIResource.UIImages.IMAGE_SDK_ICON)));
        this.uiResource = uiResource;
        this.installController = installerConroller;
        logger.trace(WizardDefaultWindow.class.getName() + " initializing end.");
    }

    public void run() throws IMFatalException {
        logger.trace("WizardDefaultWindow run() start");
        this.createContents();
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event arg0) {
                arg0.doit = WizardDefaultWindow.this.pm.sendCloseEvent();
            }
        });
        logger.trace("WizardDefaultWindow run() end");
    }

    protected void createContents() throws IMFatalException {
        logger.trace("WizardDefaultWindow createContents() start");
        String title = this.installController.getCustomTitle() + " " + "Installer";
        Rectangle windowSize = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_BASIC);
        Rectangle displayBounds = this.display.getBounds();
        Monitor[] monitors = this.display.getMonitors();
        if (monitors != null && monitors.length >= 1) {
            Monitor monitor = monitors[0];
            Rectangle bounds = monitor.getBounds();
            this.shell.setBounds(bounds.width / 2 - windowSize.width / 2, bounds.height / 2 - windowSize.height / 2, windowSize.width, windowSize.height);
        } else {
            this.shell.setBounds(displayBounds.width / 2 - windowSize.width / 2, displayBounds.height / 2 - windowSize.height / 2, windowSize.width, windowSize.height);
        }
        this.shell.setSize(windowSize.width, windowSize.height);
        this.shell.setText(title);
        FormLayout formLayout = new FormLayout();
        formLayout.marginBottom = 0;
        formLayout.marginTop = 0;
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        formLayout.marginLeft = 0;
        formLayout.marginRight = 0;
        formLayout.spacing = 0;
        this.shell.setLayout((Layout)formLayout);
        Composite pageComposite = new Composite((Composite)this.shell, 0x20000000);
        pageComposite.setBounds(this.shell.getBounds());
        pageComposite.setSize(this.shell.getBounds().width, this.shell.getBounds().height);
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        pageComposite.setLayout((Layout)this.stackLayout);
        this.pm = new WizardMaster(pageComposite, this.stackLayout, this.uiResource, this.installController);
        if (this.installController.getOption().getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.AUTOMATIC_INSTALLATION)) {
            if (!this.installController.getConfig().isAvaliableInstallDirectory()) {
                this.pm.enablePages(WIZARD_PAGES.FAIL_PAGE);
            } else {
                this.pm.enablePages(WIZARD_PAGES.INSTALLING_PAGE);
            }
        } else {
            this.pm.enablePages(WIZARD_PAGES.LICENSE_PAGE);
        }
        logger.trace("WizardDefaultWindow createContents() end");
    }

    public Shell getShell() {
        return this.shell;
    }

    public static enum WIZARD_PAGES {
        LICENSE_PAGE,
        READY_PAGE,
        INSTALLING_PAGE,
        COMPLETED_PAGE,
        FAIL_PAGE;

    }
}

