/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.wizard;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.tizen.installer.core.InstallController;
import org.tizen.installer.exception.IMFatalException;
import org.tizen.installer.ui.custom.UIResource;
import org.tizen.installer.ui.dialog.CustomMessageBoxDialog;
import org.tizen.installer.ui.wizard.WizardCommonPage;
import org.tizen.installer.ui.wizard.WizardDefaultWindow;
import org.tizen.installer.ui.wizard.WizardMaster;
import org.tizen.installer.util.Log;

public class WizardLicensePage
extends WizardCommonPage {
    private static final Logger logger = Log.getLogger(WizardLicensePage.class);
    private boolean isFirstRun = true;

    public WizardLicensePage(Composite parentComposite, UIResource uiResource, InstallController installController, int swtOption, WizardMaster wizardMaster) throws IMFatalException {
        super(parentComposite, swtOption, uiResource, installController, wizardMaster);
        this.createCenterContainer();
        this.handleCompositeEvent();
        this.handleBottomEvent();
    }

    private void handleBottomEvent() {
        this.backButton.setVisible(false);
        this.backButton.setEnabled(false);
        this.firstButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardLicensePage.this.wizardMaster.enablePages(WizardDefaultWindow.WIZARD_PAGES.READY_PAGE);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.secondButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                logger.trace("User click quit button widgetSelected => " + arg0);
                WizardLicensePage.this.getShell().close();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                logger.trace((Object)arg0);
            }
        });
    }

    private void handleCompositeEvent() {
        this.centerContainer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                if (WizardLicensePage.this.isFirstRun) {
                    logger.trace("LicensePage is called. addPaintListener => " + arg0);
                    WizardLicensePage.this.isFirstRun = false;
                }
            }
        });
    }

    private void createCenterContainer() {
        this.CreateLicenseAgreementNotice();
        this.CreateLicenseAgreementMain();
    }

    private void CreateLicenseAgreementNotice() {
        Composite mainContainer = new Composite(this.centerContainer, 0x20000000);
        Label lbl = new Label(mainContainer, 0);
        lbl.setText("Please review and accept the license terms before installing the Tizen Studio");
        lbl.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 0));
        lbl.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_33));
        GC gc = new GC((Drawable)lbl);
        Point textExtent = gc.textExtent(lbl.getText());
        gc.dispose();
        Rectangle bounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_LICENSE_NOTICE);
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.centerContainer, bounds.x, 0x1000000);
        formData.top = new FormAttachment((Control)this.centerContainer, bounds.y, 0x1000000);
        formData.width = bounds.width;
        formData.height = textExtent.y;
        mainContainer.setLayoutData((Object)formData);
        mainContainer.setLayout((Layout)new FillLayout(512));
    }

    private void CreateLicenseAgreementMain() {
        Composite mainContainer = new Composite(this.centerContainer, 0x20000000);
        FormData centerFormData = (FormData)this.centerContainer.getLayoutData();
        Rectangle bounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_LICENSE_COMPONENT);
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.centerContainer, bounds.x, 0x1000000);
        formData.top = new FormAttachment((Control)this.centerContainer, bounds.y, 0x1000000);
        formData.width = bounds.width;
        formData.height = bounds.height;
        mainContainer.setLayoutData((Object)formData);
        mainContainer.setLayout((Layout)new FillLayout(512));
        this.createLicenseAgreementComponent(mainContainer, centerFormData.width);
    }

    private void createLicenseAgreementComponent(final Composite container, int width) {
        final StyledText textArea = new StyledText(container, 536873538);
        Rectangle margin = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_LICENSE_COMPONENT_MARGIN);
        textArea.setTopMargin(margin.height);
        textArea.setBottomMargin(margin.height);
        textArea.setLeftMargin(margin.width);
        textArea.setRightMargin(margin.width);
        textArea.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 1));
        textArea.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_LICENSE_TEXT));
        textArea.setBackground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_WHITE));
        File readFile = new File("COPYING");
        if (readFile != null && readFile.exists()) {
            StringBuilder sb = this.makeViewString(readFile);
            textArea.setText(sb.toString());
        }
        textArea.setEditable(false);
        textArea.setCaret(null);
        textArea.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent arg0) {
                textArea.redraw();
                container.redraw();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder makeViewString(File license) {
        StringBuilder sb = new StringBuilder();
        String read = "";
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(license), "UTF-8"));
            while ((read = bufferedReader.readLine()) != null) {
                sb.append(read + "\n");
            }
        }
        catch (FileNotFoundException e) {
            logger.throwing((Throwable)e);
        }
        catch (IOException e) {
            logger.throwing((Throwable)e);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    logger.throwing((Throwable)e);
                }
            }
        }
        return sb;
    }

    public boolean workEventClose() {
        CustomMessageBoxDialog dialog = new CustomMessageBoxDialog(this.getShell(), this.uiResource, "Installer", "Are you sure you want to exit the Installer?", CustomMessageBoxDialog.DialogType.QESTION, false);
        int ret = dialog.open();
        if (ret == 1) {
            logger.trace("User select not to quit.");
            return false;
        }
        this.installController.shutdownExtractThread();
        logger.trace("User select quit.");
        return true;
    }
}

