/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.wizard;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.tizen.installer.core.InstallController;
import org.tizen.installer.exception.IMFatalException;
import org.tizen.installer.ui.custom.UIResource;
import org.tizen.installer.ui.wizard.WizardCompletedPage;
import org.tizen.installer.ui.wizard.WizardDefaultWindow;
import org.tizen.installer.ui.wizard.WizardFailPage;
import org.tizen.installer.ui.wizard.WizardInstallingPage;
import org.tizen.installer.ui.wizard.WizardLicensePage;
import org.tizen.installer.ui.wizard.WizardReadyPage;
import org.tizen.installer.util.Log;

public class WizardMaster {
    private StackLayout stackLayout;
    private Composite readyPage;
    private Composite installingPage;
    private Composite completedPage;
    private Composite failPage;
    private Composite licensePage;
    private WizardDefaultWindow.WIZARD_PAGES currentPageType;
    private static final Logger logger = Log.getLogger(WizardMaster.class);
    private List<Composite> pageLists = new ArrayList<Composite>();

    public WizardMaster(Composite mainComposite, StackLayout stackLayout, UIResource uiResource, InstallController installController) throws IMFatalException {
        logger.trace("Page Master constructor is called.");
        this.stackLayout = stackLayout;
        this.licensePage = new WizardLicensePage(mainComposite, uiResource, installController, 0, this);
        this.pageLists.add(this.licensePage);
        this.readyPage = new WizardReadyPage(mainComposite, uiResource, installController, 0, this);
        this.pageLists.add(this.readyPage);
        this.installingPage = new WizardInstallingPage(mainComposite, uiResource, installController, 0, this);
        this.pageLists.add(this.installingPage);
        this.completedPage = new WizardCompletedPage(mainComposite, uiResource, installController, 0, this);
        this.pageLists.add(this.completedPage);
        this.failPage = new WizardFailPage(mainComposite, uiResource, installController, 0, this);
        this.pageLists.add(this.failPage);
        logger.trace("Page Master constructor is end.");
    }

    public void enablePages(WizardDefaultWindow.WIZARD_PAGES targetPages) {
        logger.trace("enablePages start => " + targetPages.name());
        this.currentPageType = targetPages;
        switch (targetPages) {
            case LICENSE_PAGE: {
                this.enablePageAndDisableOthers(this.licensePage);
                break;
            }
            case READY_PAGE: {
                this.enablePageAndDisableOthers(this.readyPage);
                break;
            }
            case INSTALLING_PAGE: {
                this.enablePageAndDisableOthers(this.installingPage);
                break;
            }
            case COMPLETED_PAGE: {
                this.enablePageAndDisableOthers(this.completedPage);
                break;
            }
            case FAIL_PAGE: {
                this.enablePageAndDisableOthers(this.failPage);
                break;
            }
        }
        logger.trace("enablePages end => " + targetPages.name());
    }

    private void enablePageAndDisableOthers(Composite exceptPages) {
        this.stackLayout.topControl = exceptPages;
        for (Composite item : this.pageLists) {
            if (item.equals(exceptPages)) continue;
            item.setEnabled(false);
            item.setVisible(false);
        }
        exceptPages.setEnabled(true);
        exceptPages.setVisible(true);
    }

    public boolean sendCloseEvent() {
        boolean result = true;
        switch (this.currentPageType) {
            case READY_PAGE: {
                result = ((WizardReadyPage)this.readyPage).workEventClose();
                break;
            }
            case INSTALLING_PAGE: {
                result = ((WizardInstallingPage)this.installingPage).workEventClose();
                break;
            }
            case COMPLETED_PAGE: {
                result = ((WizardCompletedPage)this.completedPage).workEventClose();
                break;
            }
            case LICENSE_PAGE: {
                result = ((WizardLicensePage)this.licensePage).workEventClose();
                break;
            }
            case FAIL_PAGE: {
                result = ((WizardFailPage)this.failPage).workEventClose();
                break;
            }
        }
        return result;
    }
}

