/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.util;

import java.io.File;
import java.io.FileFilter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tizen.installer.core.Config;
import org.tizen.installer.util.PathUtil;

public class Log {
    private static final Date startTime = new Date();
    private static final String logfileNameHead = "installer";
    static Logger logger = null;
    static Logger infoLogger = null;

    public static void open(Config config) {
        Log.removeTooOldLogs(config);
        System.setProperty("installerLogFileName", PathUtil.get(PathUtil.getInstConfigHome(config), config.getConfigValue(Config.ConfigOptions.LOG_FILE_DIRECTORY), "installer_" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(startTime) + ".log"));
        logger = LogManager.getLogger((String)"logger");
        logger.trace("Installer logging start");
        infoLogger = LogManager.getLogger((String)"infoLoger");
    }

    private static void removeTooOldLogs(Config config) {
        File confDir = new File(PathUtil.get(PathUtil.getInstConfigHome(config), config.getConfigValue(Config.ConfigOptions.LOG_FILE_DIRECTORY)));
        File[] logs = confDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getAbsolutePath().contains(Log.logfileNameHead);
            }
        });
        if (logs == null) {
            return;
        }
        Arrays.sort(logs, new Comparator<File>(){

            @Override
            public int compare(File arg0, File arg1) {
                return arg0.compareTo(arg1);
            }
        });
        for (int i = 0; i < logs.length - 5; ++i) {
            if (logs[i].delete() || logger == null) continue;
            logger.error("Fail to delete file ==> " + logs[i]);
        }
    }

    public static void LogTitle(String msg) {
        infoLogger.info("**********************  " + msg + "  **********************");
    }

    public static void LogInfo(String msg) {
        infoLogger.info(msg);
    }

    public static Logger getLogger(Class<?> object) {
        if (logger == null) {
            Log.open(new Config());
        }
        return LogManager.getLogger((String)object.getName());
    }
}

