/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.cli;

import java.io.File;
import java.util.Scanner;
import org.apache.logging.log4j.Logger;
import org.tizen.installer.cli.CLIOptions;
import org.tizen.installer.cli.CLIUtil;
import org.tizen.installer.cli.InstallProgressMonitor;
import org.tizen.installer.core.Config;
import org.tizen.installer.core.InstallController;
import org.tizen.installer.core.ZipMultiLibrary;
import org.tizen.installer.exception.IMFatalException;
import org.tizen.installer.util.Log;
import org.tizen.installer.util.PathUtil;
import org.tizen.installer.util.PlatformUtil;

public class CLIInstaller {
    private static Logger logger = null;
    private ZipMultiLibrary zipLibrary;
    private Config config;
    private InstallProgressMonitor ipm = new InstallProgressMonitor();
    private InstallController installerConroller;
    private CLIOptions options;

    public CLIInstaller(InstallController installerConroller, CLIOptions options) {
        logger = Log.getLogger(CLIInstaller.class);
        logger.trace(CLIInstaller.class.getName() + " class is created.");
        logger.trace(CLIInstaller.class.getName() + " initializing start.");
        this.zipLibrary = installerConroller.getZipLibrary();
        this.config = installerConroller.getConfig();
        this.installerConroller = installerConroller;
        this.options = options;
        logger.trace(CLIInstaller.class.getName() + " initializing end.");
    }

    public void install() {
        boolean acceptLicense = this.options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.ACCEPT_LICENSE);
        String infoMsg = String.format("\nInstallation information\n\t* License Agreement : %s\n\t* Install directory : %s, Validation [%s]\n\t* Data directory    : %s", acceptLicense, this.config.getInstallDirectory(), this.config.isAvaliableInstallDirectory(), this.config.getDataLocation());
        System.out.println(infoMsg);
        Scanner scanner = new Scanner(System.in);
        try {
            if (!this.options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.ACCEPT_LICENSE)) {
                System.out.println("\nAttention");
                this.checkLicenseAgreement(scanner);
            }
            System.out.println(String.format("\nDestination directory : %s", this.config.getInstallDirectory()));
            this.checkTargetDirectory(scanner);
        }
        catch (Exception e) {
            throw new IMFatalException(e.getMessage());
        }
        System.out.println("\n");
        System.out.println(String.format("Installer will install to =>  %s", this.config.getInstallDirectory()));
        System.out.println("");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (!this.config.isAvaliableInstallDirectory()) {
            logger.error("Target directory is not empty.");
            System.out.println("Destination directory is not empty");
        } else {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        CLIInstaller.this.zipLibrary.unzip(CLIInstaller.this.config.getInstallDirectory(), CLIInstaller.this.ipm, CLIInstaller.this.installerConroller.getExtractThread());
                        File dataLocation = new File(CLIInstaller.this.installerConroller.getConfig().getDataLocation());
                        if (!dataLocation.exists()) {
                            dataLocation.mkdirs();
                        }
                        CLIInstaller.this.installerConroller.makeSdkInfoFile();
                    }
                    catch (Exception e) {
                        return;
                    }
                    finally {
                        CLIInstaller.this.installerConroller.shutdownExtractThread();
                    }
                }
            };
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private void checkLicenseAgreement(Scanner scanner) {
        System.out.println("Tizen Studio is required to agree with software license.");
        String yesOrNo = "";
        System.out.print("Do you want to read a license agreement policy? (Y/n) :  ");
        while (!yesOrNo.toLowerCase().contains("y") && !yesOrNo.toLowerCase().contains("n")) {
            yesOrNo = scanner.nextLine();
            if (yesOrNo.toLowerCase().contains("y") || yesOrNo.toLowerCase().equals("")) {
                yesOrNo = "y";
                CLIUtil.displaySoftwareLicenseAgreement();
                continue;
            }
            if (yesOrNo.toLowerCase().contains("n")) {
                System.out.println(String.format("You select =>  %s", yesOrNo));
                continue;
            }
            System.out.print("Please type \"y or n\" : ");
        }
        yesOrNo = "";
        System.out.print("Do you agree with software license agreement? (Y/n) :  ");
        while (!yesOrNo.toLowerCase().contains("y") && !yesOrNo.toLowerCase().contains("n")) {
            yesOrNo = scanner.nextLine();
            if (yesOrNo.toLowerCase().contains("y") || yesOrNo.toLowerCase().equals("")) {
                yesOrNo = "y";
                continue;
            }
            if (yesOrNo.toLowerCase().contains("n")) {
                throw new IMFatalException("User does not agree with license agreement.");
            }
            System.out.print("Please type \"y or n\" : ");
        }
    }

    private void checkTargetDirectory(Scanner scanner) {
        boolean isFirst = true;
        if (this.options.getPathOption() == null) {
            String yesOrNo = "";
            System.out.println(String.format("Default destination directory is (%s)", this.config.getInstallDirectory()));
            System.out.print("Do you want to install to default directory? (Y/n) :  ");
            while (!yesOrNo.toLowerCase().contains("y") && !yesOrNo.toLowerCase().contains("n")) {
                yesOrNo = scanner.nextLine();
                if (yesOrNo.toLowerCase().contains("y") || yesOrNo.toLowerCase().equals("")) {
                    yesOrNo = "y";
                    break;
                }
                if (yesOrNo.toLowerCase().contains("n")) {
                    this.config.setAvaliableInstallDirectory(false);
                    isFirst = false;
                    break;
                }
                System.out.print("Please type \"y or n\" : ");
            }
        }
        while (!this.config.isAvaliableInstallDirectory()) {
            if (isFirst) {
                System.out.println("Invalid destination directory!");
                isFirst = false;
            }
            String userInput = "";
            try {
                userInput = this.getDirectoryFromUser(scanner, userInput);
            }
            catch (Exception e) {
                throw new IMFatalException(e.getMessage());
            }
            if (userInput == null || userInput.isEmpty() || userInput.length() == 0) {
                System.out.println("Your input is empty.");
                continue;
            }
            userInput = PathUtil.convertUserInputDirectory(userInput);
            if (PlatformUtil.isLinux() && !userInput.startsWith("/")) {
                System.out.println(String.format("Invalid directory.=> %s", userInput));
                System.out.println("** Not a correct path.");
                continue;
            }
            this.isAvaliableDestinationDirectory(userInput);
        }
    }

    private void isAvaliableDestinationDirectory(String userInput) {
        File file = new File(userInput.trim());
        if (file.exists() && file.isDirectory()) {
            this.isAvaliableDestinationDirectory(userInput, file);
        } else if (!file.exists()) {
            if (file.mkdirs()) {
                this.isAvaliableDestinationDirectory(userInput, file);
                file.delete();
            } else {
                String msg = "";
                if (!file.canRead()) {
                    msg = "** Can not read or write destination directory.=> " + userInput;
                    logger.warn(msg);
                } else if (!file.canWrite()) {
                    msg = "** Can not read or write destination directory.=> " + userInput;
                    logger.warn(msg);
                } else {
                    msg = "** Cannot create destination directory.=> " + userInput;
                    logger.warn(msg);
                }
                System.out.println(msg);
                this.config.setAvaliableInstallDirectory(false);
            }
        }
    }

    private void isAvaliableDestinationDirectory(String userInput, File file) {
        PathUtil.AvaliableDirectory avaliableInstallDirectory = PathUtil.isAvaliableInstallDirectory(file, userInput, this.installerConroller);
        if (avaliableInstallDirectory != PathUtil.AvaliableDirectory.NO_ERROR) {
            String msg = "** " + avaliableInstallDirectory.getCLIMessage() + "=> " + userInput;
            logger.warn(msg);
            System.out.println(msg);
            this.config.setAvaliableInstallDirectory(false);
        } else {
            this.config.setInstallDirectory(file.getAbsolutePath());
            this.config.setAvaliableInstallDirectory(true);
            String dataDirectory = "";
            dataDirectory = PathUtil.getDataDirectory(file);
            this.config.setDataLocation(dataDirectory);
        }
    }

    private String getDirectoryFromUser(Scanner scanner, String userInput) {
        boolean isOk;
        System.out.println("\nFull path is required to set destination directory ");
        System.out.print("Please type destination directory : ");
        block0: do {
            userInput = scanner.nextLine();
            System.out.println(String.format("You typed : %s, is this correct? (Y/n) (quit:q) : ", userInput));
            isOk = false;
            String yesOrNo = "";
            while (!(yesOrNo.toLowerCase().contains("y") || yesOrNo.toLowerCase().contains("n") || yesOrNo.toLowerCase().contains("q"))) {
                yesOrNo = scanner.nextLine();
                if (yesOrNo.toLowerCase().contains("y") || yesOrNo.equals("")) {
                    yesOrNo = "y";
                    isOk = true;
                    continue block0;
                }
                if (yesOrNo.toLowerCase().contains("n")) {
                    System.out.println("\nFull path is required to set destination directory ");
                    System.out.print("Please type destination directory : ");
                    continue block0;
                }
                if (yesOrNo.toLowerCase().contains("q")) {
                    throw new IMFatalException("You select quit.");
                }
                System.out.print("Please type \"y or n\" : ");
            }
        } while (!isOk);
        return userInput;
    }
}

