/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.exception;

public class ErrorController {
    private static ErrorCode mErrorCode = ErrorCode.NO_ERROR;
    private static boolean mInstallationStatus = true;
    private static String errorMsg = "";
    private static int exitCode = 0;
    private static String detailedErrorMsg = "";
    private static Throwable detailedErrorLog = null;

    public static void setError(ErrorCode errorCode) {
        mErrorCode = errorCode;
    }

    public static String getErrorMessage() {
        if (mErrorCode != null) {
            return mErrorCode.getErrorMessage();
        }
        return errorMsg;
    }

    public static void setErrorMessage(String msg) {
        mErrorCode = null;
        errorMsg = msg;
    }

    public static ErrorCode getErrorCode() {
        return mErrorCode;
    }

    public static void setInstallationSuccess(boolean status) {
        if (status) {
            mErrorCode = null;
        }
        mInstallationStatus = status;
    }

    public static boolean checkInstallationSuccess() {
        return mInstallationStatus;
    }

    public static String getMessage(ErrorCode e) {
        return e.getErrorMessage();
    }

    public static void setExitCode(int exitCode) {
        ErrorController.exitCode = exitCode;
    }

    public static int getExitCode() {
        return exitCode;
    }

    public static String getDetailedErrorMsg() {
        return detailedErrorMsg;
    }

    public static void setDetailedErrorMsg(String detailedErrorMsg) {
        if (ErrorController.detailedErrorMsg != null && ErrorController.detailedErrorMsg.length() == 0) {
            ErrorController.detailedErrorMsg = detailedErrorMsg;
        }
    }

    public static Throwable getDetailedErrorLog() {
        return detailedErrorLog;
    }

    public static void setDetailedErrorLog(Throwable detailedErrorLog) {
        if (ErrorController.detailedErrorLog != null) {
            ErrorController.detailedErrorLog = detailedErrorLog;
        }
    }

    public static enum ErrorCode {
        UNSUPPORTED_JAVA("Installed Java version is unsupported."),
        INSTALLATION_CANCEL("Installing is canceled."),
        CANNOT_LOAD_COMPONENT_SIZE("Cannot read the component size property from the resource."),
        CANNOT_FIND_CONFIG_FILE("Cannot find the config file."),
        CANNOT_ACCESS_FILE("Cannot access the file."),
        UNSUPPORTED_PLATFORM("It is an unsupported platform."),
        CANNOT_UNZIP_FILE("Cannot unzip the files."),
        INVALID_INSTALL_SIZE("Cannot convert total install size."),
        NO_ERROR("No error");

        private String errorMessage = "";

        private ErrorCode(String arg) {
            this.errorMessage = arg;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String msg) {
            this.errorMessage = msg;
        }

        public boolean existErrorMessage() {
            return !this.errorMessage.isEmpty();
        }
    }
}

