/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.custom;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class CustomCheckBoxButton
extends Canvas {
    private boolean checked = false;
    private final CustomCheckBoxButton button = this;

    public CustomCheckBoxButton(Composite parent, int style, boolean isChecked, final Image checkedImage, final Image unCheckedImage) {
        super(parent, style);
        this.checked = isChecked;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Image curImage = null;
                curImage = CustomCheckBoxButton.this.checked ? checkedImage : unCheckedImage;
                e.gc.drawImage(curImage, 0, 0);
                CustomCheckBoxButton.this.button.setSize(curImage.getBounds().width, curImage.getBounds().height);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CustomCheckBoxButton.this.checked = !CustomCheckBoxButton.this.checked;
                CustomCheckBoxButton.this.redraw();
                super.mouseUp(e);
            }
        });
    }

    public CustomCheckBoxButton(Composite parent, int style, boolean isChecked, final Image checkedImage, final Image unCheckedImage, final String label, final int gap, final Font font, final Color color) {
        super(parent, style);
        this.checked = isChecked;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Image curImage = null;
                curImage = CustomCheckBoxButton.this.checked ? checkedImage : unCheckedImage;
                e.gc.drawImage(curImage, 0, 0);
                e.gc.setFont(font);
                e.gc.setForeground(color);
                Point size = e.gc.textExtent(label);
                int y = (curImage.getBounds().height - size.y) / 2;
                y = y < 0 ? 0 : y;
                e.gc.drawText(label, curImage.getBounds().width + gap, y - 1, 1);
                CustomCheckBoxButton.this.button.setSize(curImage.getBounds().width + size.x + gap, curImage.getBounds().height);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CustomCheckBoxButton.this.checked = !CustomCheckBoxButton.this.checked;
                CustomCheckBoxButton.this.redraw();
                super.mouseUp(e);
            }
        });
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setIsChecked(boolean isChecked) {
        this.checked = isChecked;
        this.redraw();
    }
}

