/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.custom;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class IMCircularGraph
extends Composite {
    private static final int DEFAULT_ANGLE = 90;
    public static final int TYPE_PERCENT = 0;
    public static final int TYPE_CUSTOM = 1;
    private Canvas canvas;
    private Label label;
    private Label emptyLabel;
    private Font labelFont = this.getShell().getDisplay().getSystemFont();
    private Font valueFont = this.getShell().getDisplay().getSystemFont();
    private Font measureFont = this.getShell().getDisplay().getSystemFont();
    private long max = 100L;
    private long value = 0L;
    public Color COLOR_LIGHT_BLUE = new Color(null, new RGB(131, 196, 218));
    public Color COLOR_LIGHT_GRAY = new Color(null, new RGB(189, 189, 189));
    public Color COLOR_WHITE = new Color(null, new RGB(255, 255, 255));
    private Color graphColor = this.COLOR_LIGHT_BLUE;
    private Color bgColor = this.COLOR_LIGHT_GRAY;
    private Color centerColor = this.COLOR_WHITE;
    private Color textColor = this.COLOR_LIGHT_BLUE;
    private String measure;
    private int type = 0;
    private Image centerImage;
    private PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Rectangle rect = IMCircularGraph.this.canvas.getBounds();
            int x = rect.x;
            int y = rect.y;
            int width = rect.width;
            int height = rect.height;
            e.gc.setAntialias(1);
            e.gc.setBackground(IMCircularGraph.this.bgColor);
            e.gc.fillOval(x, y, width, height);
            e.gc.setBackground(IMCircularGraph.this.graphColor);
            e.gc.fillArc(x, y, width, height, 90, IMCircularGraph.this.calculateAngle());
            e.gc.setBackground(IMCircularGraph.this.centerColor);
            e.gc.fillOval(x + 11, y + 11, 56, 56);
            if (IMCircularGraph.this.type == 0) {
                String centerText = IMCircularGraph.this.getCenterText();
                e.gc.setFont(IMCircularGraph.this.valueFont);
                e.gc.setForeground(IMCircularGraph.this.graphColor);
                Point textSize = e.gc.textExtent(centerText, 8);
                e.gc.drawText(centerText, (rect.width - textSize.x) / 2, 23, true);
                e.gc.setFont(IMCircularGraph.this.measureFont);
                e.gc.setForeground(IMCircularGraph.this.graphColor);
                Point measureSize = e.gc.textExtent(IMCircularGraph.this.measure, 8);
                e.gc.drawText(IMCircularGraph.this.measure, (rect.width - measureSize.x) / 2, 43, true);
            } else if (IMCircularGraph.this.type == 1) {
                e.gc.drawImage(IMCircularGraph.this.centerImage, x + 11, y + 11);
            } else {
                System.out.println("Error");
            }
        }
    };

    public IMCircularGraph(Composite parent, int style, int type) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        this.type = type;
        this.measure = type == 0 ? "%" : "";
        this.canvas = new Canvas((Composite)this, 0x20000000);
        this.canvas.addPaintListener(this.paintListener);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = 78;
        this.canvas.setLayoutData((Object)data);
        this.emptyLabel = new Label((Composite)this, 0x40000000);
        data = new FormData();
        data.top = new FormAttachment((Control)this.canvas, 0);
        data.left = new FormAttachment(0, 0);
        data.height = 3;
        data.right = new FormAttachment(100, 0);
        this.emptyLabel.setLayoutData((Object)data);
        this.label = new Label((Composite)this, 0x40000000);
        this.label.setForeground(this.textColor);
        this.label.setFont(this.labelFont);
        this.label.setAlignment(0x1000000);
        data = new FormData();
        data.top = new FormAttachment((Control)this.emptyLabel, 0);
        data.left = new FormAttachment(0, 0);
        data.height = 25;
        data.right = new FormAttachment(100, 0);
        this.label.setLayoutData((Object)data);
    }

    public void setMax(long max) {
        this.max = max;
        this.canvas.redraw();
    }

    public void update(long max, long value) {
        this.max = max;
        this.value = value;
        this.canvas.redraw();
        this.canvas.update();
    }

    public void update(long value) {
        this.value = value;
        this.canvas.redraw();
    }

    private int calculateAngle() {
        int angle = (int)(360.0f * ((float)this.value / (float)this.max)) * -1;
        return angle;
    }

    public void setText(String text) {
        this.label.setForeground(this.textColor);
        this.label.setText(text);
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
        this.labelFont = font;
    }

    public void setValueFont(Font font) {
        this.valueFont = font;
    }

    public void setMeasureFont(Font font) {
        this.measureFont = font;
    }

    public void setLabelBg(Color color) {
        this.label.setBackground(color);
        this.emptyLabel.setBackground(color);
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    private String getCenterText() {
        String str = null;
        if (this.type == 0) {
            int percent = (int)((float)this.value / (float)this.max * 100.0f);
            str = Integer.toString(percent);
        } else if (this.value >= 1024L) {
            double dValue = (double)this.value / 1024.0;
            if (dValue >= 1048576.0) {
                dValue = dValue / 1024.0 * 1024.0;
                this.setMeasure("GB");
            } else if (dValue >= 1024.0) {
                dValue /= 1024.0;
                this.setMeasure("MB");
            } else {
                this.setMeasure("KB");
            }
            str = IMCircularGraph.toDoubleFormat1(Double.toString(dValue));
        } else {
            str = Long.toString(this.value);
        }
        return str;
    }

    public void setMeasure(String m) {
        this.measure = m;
    }

    public void setGraphColor(Color color) {
        this.graphColor = color;
    }

    public void setGraphBgColor(Color color) {
        this.bgColor = color;
    }

    public void setCenterColor(Color color) {
        this.centerColor = color;
    }

    public void setCanvasColor(Color color) {
        this.canvas.setBackground(color);
    }

    public void setCenterImage(Image image) {
        this.centerImage = image;
    }

    public static String toDoubleFormat1(String value) {
        if (null == value || value.isEmpty()) {
            return null;
        }
        try {
            double data = Double.parseDouble(value);
            return String.format("%.1f", data);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return value;
        }
    }
}

