/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.dialog;

import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class MessageBoxDlg {
    public static final int YES = 64;
    public static final int NO = 128;
    public static final int OK = 32;
    public static final int CANCEL = 256;
    private static int result;

    public static int showDlg(final Shell shell, final String title, final String msg, final DialogType dlgType, final boolean onlyOk) {
        result = 0;
        if (shell == null) {
            return result;
        }
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                int style = 0;
                if (dlgType == null) {
                    return;
                }
                if (dlgType == DialogType.INFO) {
                    style = 34;
                } else if (dlgType == DialogType.NOTIFY_OK) {
                    style = 34;
                } else if (dlgType == DialogType.NOTIFY_YES) {
                    style = 194;
                } else if (dlgType == DialogType.WARNING) {
                    style = 200;
                } else if (dlgType == DialogType.ERROR) {
                    style = 33;
                }
                if (onlyOk) {
                    style |= 0x20;
                }
                MessageBox dialog = new MessageBox(shell, style);
                dialog.setText(title);
                dialog.setMessage(msg);
                result = dialog.open();
            }
        });
        return result;
    }

    public static enum DialogType {
        INFO,
        NOTIFY_OK,
        NOTIFY_YES,
        WARNING,
        ERROR;

    }
}

