/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.wizard;

import java.io.File;
import java.util.ArrayList;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.tizen.installer.cli.CLIOptions;
import org.tizen.installer.core.InstallController;
import org.tizen.installer.exception.IMFatalException;
import org.tizen.installer.ui.custom.CustomCheckBoxButton;
import org.tizen.installer.ui.custom.UIResource;
import org.tizen.installer.ui.dialog.CustomMessageBoxDialog;
import org.tizen.installer.ui.wizard.WizardCommonPage;
import org.tizen.installer.ui.wizard.WizardMaster;
import org.tizen.installer.util.Log;
import org.tizen.installer.util.PathUtil;
import org.tizen.installer.util.PlatformUtil;

public class WizardCompletedPage
extends WizardCommonPage {
    private static final Logger logger = Log.getLogger(WizardCompletedPage.class);
    private static final String MANAGER_PACKAGE = "package-manager";
    private static final String MANAGER_EXE = "package-manager.exe";
    private static final String MANAGER_BIN = "package-manager.bin";
    private static final String MANAGER_APP = "package-manager.app";
    private CustomCheckBoxButton checkBox;
    private boolean isFirstRun = true;
    private Image checkNormal;
    private Image checkSel;

    public WizardCompletedPage(Composite parentComposite, UIResource uiResource, InstallController installController, int swtOption, WizardMaster wizardMaster) throws IMFatalException {
        super(parentComposite, swtOption, uiResource, installController, wizardMaster);
        this.loadImages(uiResource);
        this.createCenterContainer();
        this.handleCompositeEvent();
        this.handleBottomEvent();
    }

    private void handleBottomEvent() {
        this.backButton.setEnabled(false);
        this.backButton.setVisible(false);
        this.firstButton.setEnabled(false);
        this.firstButton.setVisible(false);
        this.secondButton.setText("Finish");
        this.secondButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                logger.trace("User click quit button widgetSelected => " + arg0);
                if (WizardCompletedPage.this.checkBox.isChecked()) {
                    WizardCompletedPage.this.runPackageManager();
                } else {
                    WizardCompletedPage.this.getShell().close();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                logger.trace((Object)arg0);
            }
        });
    }

    private void runPackageManager() {
        try {
            String binaryName = "";
            binaryName = PlatformUtil.isWindows() ? MANAGER_EXE : (PlatformUtil.isLinux() ? MANAGER_BIN : (PlatformUtil.isMacOS() ? MANAGER_APP : MANAGER_BIN));
            File managerFile = new File(PathUtil.get(this.installController.getConfig().getInstallDirectory(), MANAGER_PACKAGE, binaryName));
            if (managerFile.exists()) {
                logger.trace("User select run Package Manager");
                this.runNewManagerInTempDir(managerFile);
            }
        }
        catch (Exception e) {
            logger.throwing((Throwable)e);
        }
        finally {
            this.getShell().close();
        }
    }

    private void handleCompositeEvent() {
        this.centerContainer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                logger.trace((Object)arg0);
                WizardCompletedPage.this.handleInit();
            }
        });
    }

    private void handleInit() {
        if (this.isFirstRun) {
            this.infoLabel.setText("Installation Complete");
            this.isFirstRun = false;
            if (this.installController.getOption().getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.AUTOMATIC_INSTALLATION)) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.getShell().close();
            }
            this.installController.loadAndSavePostInstallPackages();
            if (this.installController.isExistPostinstallPackage()) {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CustomMessageBoxDialog cid = new CustomMessageBoxDialog(WizardCompletedPage.this.getShell(), WizardCompletedPage.this.uiResource, "Installer", "5", "Some packages will be automatically installed after this process.\nplease wait for a seconds", CustomMessageBoxDialog.DialogType.INFO, true, true);
                        cid.open();
                        WizardCompletedPage.this.runPackageManager();
                    }
                });
            }
        }
    }

    private void loadImages(UIResource uiResource) throws IMFatalException {
        try {
            this.checkNormal = new Image((Device)this.getDisplay(), uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_CHECK_NORMAL));
            this.checkSel = new Image((Device)this.getDisplay(), uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_CHECK_SEL));
        }
        catch (Exception e) {
            throw new IMFatalException("Can not load image files ==> " + ((Object)((Object)this)).getClass().getName());
        }
    }

    private void createCenterContainer() {
        Composite leftContainer = new Composite(this.centerContainer, 0x20000000);
        Rectangle bounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INSTALL_IC_SDK);
        Rectangle strokeSize = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INSTALL_IC_STROKE);
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.centerContainer, bounds.x, 0x1000000);
        formData.top = new FormAttachment((Control)this.centerContainer, bounds.y, 0x1000000);
        formData.width = bounds.width;
        formData.height = bounds.height;
        leftContainer.setLayoutData((Object)formData);
        leftContainer.setLayout((Layout)new FillLayout(256));
        this.uiResource.handleInstallingForWizardProgress(leftContainer, this.uiResource, 100L, bounds.width, bounds.height, bounds.width - (strokeSize.width + strokeSize.height), 0);
        Rectangle messageBounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_COMPLETED_MESSAGE_LOCATION);
        Composite messageContainer = new Composite(this.centerContainer, 0x20000000);
        FormData rightContainerFormData = new FormData();
        rightContainerFormData.left = new FormAttachment((Control)this.centerContainer, messageBounds.x, 0x1000000);
        rightContainerFormData.top = new FormAttachment((Control)this.centerContainer, messageBounds.y, 0x1000000);
        rightContainerFormData.width = messageBounds.width;
        rightContainerFormData.height = messageBounds.height;
        messageContainer.setLayoutData((Object)rightContainerFormData);
        messageContainer.setLayout((Layout)new FormLayout());
        this.createInfoComposites(messageContainer);
    }

    private void createInfoComposites(Composite topContainer) {
        Rectangle point = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_COMPLETED_MESSAGE_LOCATION);
        int imageSize = 18;
        String infoMessage = null;
        Label infoMessageLabel = new Label(topContainer, 64);
        infoMessageLabel.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 0));
        infoMessageLabel.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_58));
        int topPosition = 0;
        int infoLabelHeight = 0;
        if (this.installController.isCustomTitle()) {
            infoMessage = String.format("Thank you for using \"%s\".\nSome \"%s\" packages may not work yet.\nPlease restart your computer before using \"%s\".", this.installController.getCustomTitle(), this.installController.getCustomTitle(), this.installController.getCustomTitle());
            GC gc = new GC((Drawable)infoMessageLabel);
            int height = gc.textExtent((String)infoMessage).y;
            gc.dispose();
            topPosition = point.height / 2 - height / 2 - imageSize;
            infoLabelHeight = height;
        } else {
            infoMessage = "The Tizen Studio requires additional packages to be installed to support, for example, native application development.\n\nTo install additional packages, launch the Package Manager by checking the following checkbox.\n\nAfter the package installation, reboot your computer.";
            infoLabelHeight = point.height - imageSize;
        }
        infoMessageLabel.setText(infoMessage);
        FormData infoFormData = new FormData();
        infoFormData.left = new FormAttachment((Control)topContainer, 0, 0x1000000);
        infoFormData.top = new FormAttachment((Control)topContainer, topPosition, 0x1000000);
        infoFormData.height = infoLabelHeight;
        infoFormData.width = point.width;
        infoMessageLabel.setLayoutData((Object)infoFormData);
        this.checkBox = new CustomCheckBoxButton(topContainer, 0x20000000, true, this.checkSel, this.checkNormal, "Launch the Package Manager", 7, this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 1), this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_33));
        FormData checkFormData = new FormData();
        checkFormData.left = new FormAttachment((Control)topContainer, 0, 0x1000000);
        checkFormData.top = new FormAttachment((Control)topContainer, point.height - imageSize, 0x1000000);
        checkFormData.height = imageSize;
        checkFormData.width = point.width;
        this.checkBox.setLayoutData(checkFormData);
    }

    private void runNewManagerInTempDir(File managerFile) {
        logger.info("Package Manager will start. => " + managerFile.getAbsolutePath());
        if (managerFile.exists()) {
            try {
                ArrayList<String> commands = new ArrayList<String>();
                if (PlatformUtil.isWindows()) {
                    commands.add("cmd.exe");
                    commands.add("/c");
                } else if (PlatformUtil.isMacOS()) {
                    commands.add("open");
                    commands.add("-a");
                } else if (PlatformUtil.isLinux()) {
                    // empty if block
                }
                commands.add(managerFile.getAbsolutePath());
                logger.trace("Package Manager commands => " + commands);
                ProcessBuilder pb = new ProcessBuilder(commands);
                pb.directory(managerFile.getParentFile());
                pb.start();
            }
            catch (Exception e) {
                logger.throwing((Throwable)e);
                return;
            }
        }
    }

    public boolean workEventClose() {
        this.installController.shutdownExtractThread();
        return true;
    }
}

