/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclFileAttributeView;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.installer.cli.CLIOptions;
import org.tizen.installer.core.Config;
import org.tizen.installer.core.InstallController;
import org.tizen.installer.exception.ErrorController;
import org.tizen.installer.exception.IMFatalException;
import org.tizen.installer.util.FileUtil;
import org.tizen.installer.util.PlatformUtil;

public class PathUtil {
    private static final String REG_SZ = "REG_SZ";
    public static final String REGISTRY_PATH_OF_SHELL_FOLDER = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
    public static final String REGISTRY_LOCAL_APP_DATA_OF_SHELL_FOLDER = "\"Local AppData\"";

    public static String getFromHome(String ... path_components) {
        return System.getProperty("user.home") + File.separator + PathUtil.get(path_components);
    }

    public static String getCurrentDir() {
        return System.getProperty("user.dir");
    }

    public static String get(String ... path_components) {
        String path = "";
        for (int i = 0; i < path_components.length; ++i) {
            path = i == 0 ? path_components[0] : (path.endsWith(File.separator) ? path + path_components[i] : path + File.separator + path_components[i]);
        }
        return path;
    }

    public static long getAvailableSpaceSize(String selectedPath) {
        long usableSpace;
        File file = null;
        File root = null;
        if (PlatformUtil.isLinux() || PlatformUtil.isMacOS()) {
            file = new File(selectedPath);
        } else if (PlatformUtil.isWindows()) {
            file = new File(selectedPath);
            root = PathUtil.getSelectedRoot(selectedPath);
        } else {
            throw new IMFatalException(ErrorController.ErrorCode.UNSUPPORTED_PLATFORM);
        }
        boolean isCreatedByUtil = false;
        if (!file.exists()) {
            file.mkdirs();
            isCreatedByUtil = true;
        }
        if ((usableSpace = file.getUsableSpace()) == 0L && root != null) {
            usableSpace = root.getUsableSpace();
        }
        if (isCreatedByUtil && file.exists()) {
            FileUtil.deleteDirectory(PathUtil.class, null, file);
        }
        return usableSpace;
    }

    private static File getSelectedRoot(String selectedPath) {
        ArrayList<File> mountList = null;
        if (PlatformUtil.isLinux() || PlatformUtil.isMacOS()) {
            mountList = new ArrayList<File>();
            File home = new File(System.getProperty("user.home"));
            mountList.add(home);
        } else if (PlatformUtil.isWindows()) {
            mountList = new ArrayList();
            File[] roots = File.listRoots();
            if (roots == null) {
                return null;
            }
            for (int i = 0; i < roots.length; ++i) {
                mountList.add(roots[i]);
            }
        }
        if (mountList == null) {
            return null;
        }
        for (int i = 0; i < mountList.size(); ++i) {
            if (!selectedPath.toLowerCase().startsWith(((File)mountList.get(i)).getAbsolutePath().toLowerCase())) continue;
            return (File)mountList.get(i);
        }
        return null;
    }

    public static boolean isEmptyDirectory(File file) {
        if (file == null) {
            return false;
        }
        File[] listFiles = file.listFiles();
        return listFiles == null || listFiles.length <= 0;
    }

    public static String getFromAppData(String ... path_components) {
        return PathUtil.get(PathUtil.getLocalAppData() + File.separator + PathUtil.get(path_components));
    }

    private static String getLocalAppData() {
        if (PlatformUtil.isWindows()) {
            return PathUtil.getRegistryValue(REGISTRY_PATH_OF_SHELL_FOLDER, REGISTRY_LOCAL_APP_DATA_OF_SHELL_FOLDER);
        }
        return "";
    }

    private static String getRegistryValue(String node, String key) {
        if (!PlatformUtil.isWindows()) {
            return null;
        }
        BufferedReader br = null;
        String value = "";
        String query = "reg query \"" + node + "\" /v " + key;
        try {
            Process process = Runtime.getRuntime().exec(query);
            String encoding = PlatformUtil.CURRENT_CHARSET;
            br = new BufferedReader(new InputStreamReader(process.getInputStream(), encoding));
            String line = null;
            while ((line = br.readLine()) != null) {
                int index = line.indexOf(REG_SZ);
                if (index < 0) continue;
                value = line.substring(index + REG_SZ.length()).trim();
            }
        }
        catch (IOException e) {
            throw new IMFatalException(e.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    throw new IMFatalException(e.getMessage());
                }
            }
        }
        return value;
    }

    public static String getSizeToString(long size) {
        float installSize = 0.0f;
        String returnValue = "0";
        if (size >= 0x40000000L) {
            installSize = (float)size / 1.0737418E9f;
            returnValue = installSize >= 1024.0f ? String.format("%.2f TB", Float.valueOf(installSize / 1024.0f)) : String.format("%.2f GB", Float.valueOf(installSize));
        } else if (size < 0x40000000L && size > 0x100000L) {
            installSize = (float)size / 1048576.0f;
            returnValue = String.format("%.2f MB", Float.valueOf(installSize));
        } else {
            installSize = size;
            returnValue = String.format("%d Bytes", Float.valueOf(installSize));
        }
        return returnValue;
    }

    public static String getShortDirectory(String dir, int max) {
        String tempDir;
        String installDir = "";
        installDir = dir.length() > max ? (tempDir = "." + dir.substring(dir.length() - max + 1, dir.length())) : dir;
        return installDir;
    }

    public static boolean canReadAndWrite(File installDirectory) {
        if (installDirectory == null) {
            return false;
        }
        if (!installDirectory.exists()) {
            return true;
        }
        if (!installDirectory.canRead()) {
            return false;
        }
        return installDirectory.canWrite();
    }

    public static File getTempFileFromResource(String resourcePath, String prefix, String suffix) throws IOException {
        return PathUtil.getTempFileFromResource(resourcePath, prefix, suffix, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTempFileFromResource(String resourcePath, String prefix, String suffix, boolean deleteOnExit) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        InputStream is = PathUtil.getResourceAsStream(resourcePath);
        try {
            FileUtil.writeFileFromInputStream(is, file);
            if (deleteOnExit) {
                file.deleteOnExit();
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return file;
    }

    public static InputStream getResourceAsStream(String resourcePath) {
        return Class.class.getResourceAsStream(resourcePath);
    }

    public static boolean checkDiskSpace(String targetDir, long requiredSize) {
        long availableSpaceSize = PathUtil.getAvailableSpaceSize(targetDir);
        return availableSpaceSize > requiredSize;
    }

    public static String getInstConfigHome(Config config) {
        if (PlatformUtil.isLinux() || PlatformUtil.isMacOS()) {
            return PathUtil.getFromHome(config.getConfigValue(Config.ConfigOptions.MANAGER_CONFIG_DIRECTORY));
        }
        if (PlatformUtil.isWindows()) {
            return PathUtil.getFromAppData(config.getConfigValue(Config.ConfigOptions.MANAGER_CONFIG_DIRECTORY));
        }
        throw new IMFatalException(ErrorController.ErrorCode.UNSUPPORTED_PLATFORM);
    }

    public static String findNotExistsDirectoryName(String dataDirectory, int count) {
        String returnVal = "";
        if (dataDirectory != null && !dataDirectory.isEmpty()) {
            File dataDir;
            String targetDir = dataDirectory;
            if (count != 0) {
                targetDir = targetDir + "." + count;
            }
            if ((dataDir = new File(targetDir)).exists()) {
                returnVal = PathUtil.findNotExistsDirectoryName(dataDirectory, ++count);
            } else {
                return targetDir;
            }
        }
        return returnVal;
    }

    public static boolean isContainSpecialCharacter(String dir, boolean isTestMode) {
        if (isTestMode) {
            boolean isInvalid = false;
            String regx = PlatformUtil.isWindows() ? "[\\/:*?\"<>|]+" : "[/><|:&]+";
            for (File file = new File(dir); file != null; file = file.getParentFile()) {
                Pattern pattern;
                Matcher match;
                String name = file.getName();
                if (name == null || name.length() <= 0 || !(match = (pattern = Pattern.compile(regx)).matcher(name)).find()) continue;
                isInvalid = true;
                break;
            }
            return isInvalid;
        }
        return !dir.matches("[^`~!@$%^&*=?]+");
    }

    public static boolean isContainSpace(String dir) {
        return dir.contains(" ");
    }

    public static String getDefaultInstallDirectory(String userInputDir, Config config) {
        String installDirectory = null;
        if (userInputDir != null && !userInputDir.isEmpty()) {
            installDirectory = userInputDir;
        } else {
            installDirectory = PathUtil.getFromHome(config.getConfigValue(Config.ConfigOptions.SDK_DIRECTORY));
            if (PlatformUtil.isWindows()) {
                File tempDir = new File(installDirectory);
                File root = null;
                while ((root = tempDir.getParentFile()) != null) {
                    tempDir = root;
                }
                installDirectory = PathUtil.get(tempDir.getAbsolutePath(), config.getConfigValue(Config.ConfigOptions.SDK_DIRECTORY));
            }
        }
        return installDirectory;
    }

    public static String getDataDirectory(File file) {
        String dataDirectory = null;
        dataDirectory = PathUtil.get(file.getParent(), file.getName() + "-data");
        dataDirectory = PathUtil.findNotExistsDirectoryName(dataDirectory, 0);
        return dataDirectory;
    }

    public static AvaliableDirectory isAvaliableInstallDirectory(File file, String installDir, InstallController installerConroller) {
        String userHome;
        if (PlatformUtil.isWindows()) {
            if (!installDir.matches("^[a-zA-Z]:\\\\.*$")) {
                ErrorController.setErrorMessage(AvaliableDirectory.ERROR_DIRIVE_LETTER_REQUIRED.uiMessage);
                return AvaliableDirectory.ERROR_DIRIVE_LETTER_REQUIRED;
            }
            if (!installerConroller.getOption().getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.AUTOMATIC_INSTALLATION)) {
                Path newDirectoryPath = Paths.get(installDir, new String[0]);
                AclFileAttributeView bv = Files.getFileAttributeView(newDirectoryPath, AclFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                boolean hasWriteRight = false;
                try {
                    List<AclEntry> acl = bv.getAcl();
                    for (AclEntry item : acl) {
                        Set<AclEntryPermission> permissions;
                        if (!item.principal().toString().toLowerCase().contains("user") || (permissions = item.permissions()) == null || permissions.isEmpty() || !permissions.toString().toLowerCase().contains("write")) continue;
                        hasWriteRight = true;
                        break;
                    }
                }
                catch (IOException e) {
                    ErrorController.setErrorMessage(AvaliableDirectory.ERROR_REQUIRED_ADMINISTRATOR_RIGHT.uiMessage);
                    return AvaliableDirectory.ERROR_REQUIRED_ADMINISTRATOR_RIGHT;
                }
                if (!hasWriteRight) {
                    ErrorController.setErrorMessage(AvaliableDirectory.ERROR_REQUIRED_ADMINISTRATOR_RIGHT.uiMessage);
                    return AvaliableDirectory.ERROR_REQUIRED_ADMINISTRATOR_RIGHT;
                }
            }
        } else if (PlatformUtil.isLinux() && (userHome = System.getProperty("user.home")) != null && !userHome.isEmpty() && !installDir.startsWith(userHome)) {
            ErrorController.setErrorMessage(AvaliableDirectory.ERROR_START_FROM_HOME.uiMessage);
            return AvaliableDirectory.ERROR_START_FROM_HOME;
        }
        if (file == null) {
            ErrorController.setErrorMessage(AvaliableDirectory.ERROR_CANNOT_READ_OR_WRITE.uiMessage);
            return AvaliableDirectory.ERROR_CANNOT_READ_OR_WRITE;
        }
        if (file != null && !file.isDirectory()) {
            if (file.exists()) {
                ErrorController.setErrorMessage(AvaliableDirectory.ERROR_NOT_A_DIRECTORY.uiMessage);
                return AvaliableDirectory.ERROR_NOT_A_DIRECTORY;
            }
            ErrorController.setErrorMessage(AvaliableDirectory.ERROR_NOT_EXISTS.uiMessage);
            return AvaliableDirectory.ERROR_NOT_EXISTS;
        }
        if (!PathUtil.canReadAndWrite(file)) {
            ErrorController.setErrorMessage(AvaliableDirectory.ERROR_CANNOT_READ_OR_WRITE.uiMessage);
            return AvaliableDirectory.ERROR_CANNOT_READ_OR_WRITE;
        }
        if (!PathUtil.isEmptyDirectory(file)) {
            ErrorController.setErrorMessage(AvaliableDirectory.ERROR_IS_NOT_EMPTY.uiMessage);
            return AvaliableDirectory.ERROR_IS_NOT_EMPTY;
        }
        if (installerConroller.getSdkImageInfo() != null && !PathUtil.checkDiskSpace(file.getAbsolutePath(), installerConroller.getSdkImageInfo().getInstallSizeInLong())) {
            ErrorController.setErrorMessage(AvaliableDirectory.ERROR_NOT_ENOUGH_SPACE.uiMessage);
            return AvaliableDirectory.ERROR_NOT_ENOUGH_SPACE;
        }
        if (installerConroller.isMBCSCheck() && PathUtil.isContainSpecialCharacter(file.getAbsolutePath(), installerConroller.isMBCSCheck())) {
            ErrorController.setErrorMessage(AvaliableDirectory.ERROR_CONTAINS_SPECIAL_CHARACTER.uiMessage);
            return AvaliableDirectory.ERROR_CONTAINS_SPECIAL_CHARACTER;
        }
        if (installerConroller.isMBCSCheck() && PathUtil.isContainSpace(file.getAbsolutePath())) {
            ErrorController.setErrorMessage(AvaliableDirectory.ERROR_CONTAINS_SPACE.uiMessage);
            return AvaliableDirectory.ERROR_CONTAINS_SPACE;
        }
        if (installerConroller.isMBCSCheck() && PathUtil.isContainsMultiByteCharacter(file.getAbsolutePath())) {
            ErrorController.setErrorMessage(AvaliableDirectory.ERROR_CONTAINS_MULTIBYTE_CHARACTERS.uiMessage);
            return AvaliableDirectory.ERROR_CONTAINS_MULTIBYTE_CHARACTERS;
        }
        return AvaliableDirectory.NO_ERROR;
    }

    public static String convertUserInputDirectory(String userInput) {
        if (userInput.startsWith("~") && PlatformUtil.isLinux()) {
            if ((userInput = userInput.replace("~", "")).startsWith("/")) {
                userInput = userInput.replaceFirst("/", "");
            }
            userInput = PathUtil.getFromHome(userInput);
            System.out.println("Installer convert your input => " + userInput);
        }
        if (userInput.startsWith("'") && userInput.endsWith("'") || userInput.startsWith("\"") && userInput.endsWith("\"")) {
            userInput = userInput.substring(1, userInput.length() - 1);
        }
        return userInput;
    }

    public static boolean isContainsMultiByteCharacter(String value) {
        char[] charArray;
        for (char c : charArray = value.toCharArray()) {
            String c_string = Character.toString(c);
            try {
                byte[] c_byte_array = c_string.getBytes("UTF-8");
                if (c_byte_array.length <= 1) continue;
                return true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return false;
    }

    public static enum AvaliableDirectory {
        ERROR_DIRIVE_LETTER_REQUIRED("The destination directory must contain a drive letter.", "The destination directory must contain a drive letter.\nChange to valid directory."),
        ERROR_START_FROM_HOME("The destination directory must start with user home directory.", "The destination directory must start with user home directory.\nChange to valid directory."),
        ERROR_NOT_A_DIRECTORY("The destination is not a directory.", "The destination is not a directory.\nChange to valid directory."),
        ERROR_NOT_EXISTS("The destination does not exists.", "The destination does not exists.\nChange to valid directory."),
        ERROR_CANNOT_READ_OR_WRITE("Can not read or write the destination directory.", "Can not read or write the destination directory.\nChange to another directory."),
        ERROR_NOT_ENOUGH_SPACE("Low disk space.", "Low disk space.\nChange to another directory."),
        ERROR_CONTAINS_SPECIAL_CHARACTER("The destination directory cannot contain special characters.", "The destination directory cannot contain special characters.\nChange to another directory."),
        ERROR_CONTAINS_SPACE("The destination directory cannot contain spaces.", "The destination directory cannot contain spaces.\nChange to another directory."),
        ERROR_IS_NOT_EMPTY("destination directory is not valid.", "destination directory is not valid.\nChange to another directory."),
        ERROR_CONTAINS_MULTIBYTE_CHARACTERS("The destination directory contains multi-byte characters.", "The destination directory contains multi-byte characters.\nChange to another directory."),
        ERROR_REQUIRED_ADMINISTRATOR_RIGHT("The directory you specify is not allowed to install the Tizen Studio. Some tools of the Tizen Studio will not properly work in the directory with administrator privilege or read-only access rights for your account.", "The directory you specify is not allowed to install the Tizen Studio. Some tools of the Tizen Studio will not properly work in the directory with administrator privilege or read-only access rights for your account.\nChange to another directory."),
        NO_ERROR("", "");

        private String cliMessage = "";
        private String uiMessage = "";

        private AvaliableDirectory(String cliMessage, String uiMessage) {
            this.cliMessage = cliMessage;
            this.uiMessage = uiMessage;
        }

        public String getUIMessage() {
            return this.uiMessage;
        }

        public String getCLIMessage() {
            return this.cliMessage;
        }
    }
}

