/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.tizen.installer.exception.ErrorController;

public class CLIUtil {
    public static void displaySoftwareLicenseAgreement() {
        int errCode = 0;
        File readFile = new File("COPYING");
        if (readFile != null && readFile.exists()) {
            StringBuilder sb = CLIUtil.makeViewString(readFile);
            if (sb != null) {
                System.out.println();
                System.out.println(sb.toString());
            } else {
                errCode = 5;
            }
        } else {
            System.out.println("Fail to load license file.");
            errCode = 5;
        }
        ErrorController.setExitCode(errCode);
    }

    public static void displayHelp() {
        int errCode = 0;
        File readFile = new File("HELP");
        if (readFile != null && readFile.exists()) {
            StringBuilder sb = CLIUtil.makeViewString(readFile);
            if (sb != null) {
                System.out.println();
                System.out.println(sb.toString());
            } else {
                errCode = 5;
            }
        } else {
            System.out.println("Fail to load \"help\" file.");
            errCode = 5;
        }
        ErrorController.setExitCode(errCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuilder makeViewString(File license) {
        StringBuilder sb = new StringBuilder();
        String read = "";
        BufferedReader bufferedReader = null;
        try {
            int width = 80;
            bufferedReader = new BufferedReader(new FileReader(license));
            while ((read = bufferedReader.readLine()) != null) {
                int lineLength = read.length();
                if (lineLength > width) {
                    int currentStart = 0;
                    int currentEnd = width;
                    while (currentStart != currentEnd) {
                        String substring = read.substring(currentStart, currentEnd);
                        sb.append(substring + "\n");
                        currentStart = currentEnd;
                        currentEnd = lineLength - currentEnd >= width ? currentStart + width : lineLength;
                    }
                    continue;
                }
                sb.append(read + "\n");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
            sb = null;
        }
        catch (IOException e) {
            System.out.println(e);
            sb = null;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    System.out.println(e);
                    sb = null;
                }
            }
        }
        return sb;
    }
}

