/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.installer.core.InstallController;
import org.tizen.installer.ui.custom.UIResource;

public class CustomInformationDialog
extends Dialog {
    private UIResource uiResource;
    private InstallController installController;

    public CustomInformationDialog(Shell parentShell, UIResource uiResource, InstallController installController) {
        super(parentShell);
        this.setShellStyle(67616);
        this.uiResource = uiResource;
        this.installController = installController;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Image backgroundImage = new Image((Device)container.getDisplay(), this.uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_INFO_BACKGROUND));
        container.setBackgroundImage(backgroundImage);
        container.setLayout((Layout)new FormLayout());
        container.setBackgroundMode(2);
        this.createTitle(container);
        this.createVersion(container);
        this.createButton(container);
        return container;
    }

    private void createTitle(Composite composite) {
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText("Tizen Studio");
        titleLabel.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_WHITE));
        titleLabel.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_46PX, true, 0));
        Rectangle bounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INFORMATION_DIALOG_TITLE);
        FormData titleFormData = new FormData();
        titleFormData.left = new FormAttachment((Control)composite, bounds.x, 16384);
        titleFormData.top = new FormAttachment((Control)composite, bounds.y, 16384);
        titleFormData.width = bounds.width;
        titleFormData.height = bounds.height;
        titleLabel.setLayoutData((Object)titleFormData);
    }

    private void createVersion(Composite composite) {
        Label versionLabel = new Label(composite, 0);
        versionLabel.setText(String.format("Installer Version : %s", this.installController.getVersion()));
        versionLabel.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_WHITE));
        versionLabel.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_18PX, true, 0));
        Rectangle bounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INFORMATION_DIALOG_VERSION);
        FormData versionFormData = new FormData();
        versionFormData.left = new FormAttachment((Control)composite, bounds.x, 16384);
        versionFormData.top = new FormAttachment((Control)composite, bounds.y, 16384);
        versionFormData.width = bounds.width;
        versionFormData.height = bounds.height;
        versionLabel.setLayoutData((Object)versionFormData);
    }

    private void createButton(Composite composite) {
        Button okButton = new Button(composite, 8);
        okButton.setText("OK");
        okButton.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 0));
        Rectangle bounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INFORMATION_DIALOG_BUTTON);
        FormData okFormData = new FormData();
        okFormData.left = new FormAttachment((Control)composite, bounds.x, 16384);
        okFormData.top = new FormAttachment((Control)composite, bounds.y, 16384);
        okFormData.width = bounds.width;
        okFormData.height = bounds.height;
        okButton.setLayoutData((Object)okFormData);
        okButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                CustomInformationDialog.this.okPressed();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                CustomInformationDialog.this.okPressed();
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Installation Information");
        newShell.setBounds(this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INFORMATION_DIALOG));
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }
}

