/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.wizard;

import org.apache.logging.log4j.Logger;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.tizen.installer.core.InstallController;
import org.tizen.installer.exception.IMFatalException;
import org.tizen.installer.ui.IMButton;
import org.tizen.installer.ui.custom.UIResource;
import org.tizen.installer.ui.wizard.WizardMaster;
import org.tizen.installer.util.Log;
import org.tizen.installer.util.PlatformUtil;

public class WizardCommonPage
extends Composite {
    private static final Logger logger = Log.getLogger(WizardCommonPage.class);
    protected Composite topContainer;
    protected Composite centerContainer;
    protected Composite splitterContainer;
    protected Composite bottomContainer;
    protected UIResource uiResource;
    protected Composite parent;
    protected Label infoLabel;
    private Label toolTiplabel;
    protected IMButton infoButton;
    protected Button backButton;
    protected Button firstButton;
    protected Button secondButton;
    private Image infoButtonImageNormal;
    private Image infoButtonImageHover;
    private Image titleBG;
    private int versionInfoTextSize = 0;
    private Image toolTipLeft;
    private Image toolTipMiddle;
    private Image toolTipRight;
    private String format;
    protected InstallController installController;
    protected WizardMaster wizardMaster;

    public WizardCommonPage(Composite parent, int options, UIResource uiResource, InstallController installController, WizardMaster wizardMaster) {
        super(parent, options);
        logger.trace(WizardCommonPage.class.getName() + " constructor start.");
        this.uiResource = uiResource;
        this.parent = parent;
        this.installController = installController;
        this.wizardMaster = wizardMaster;
        this.setBackgroundMode(2);
        this.setDefaultSetting(this);
        this.topContainer = new Composite((Composite)this, 0x20000000);
        this.centerContainer = new Composite((Composite)this, 0x20000000);
        this.splitterContainer = new Composite((Composite)this, 0x20000000);
        this.bottomContainer = new Composite((Composite)this, 0);
        this.loadImages(uiResource);
        this.createBaseComponent(this, this.topContainer, this.centerContainer, this.bottomContainer, uiResource);
        this.createTopContainer();
        this.createBottomContainer();
        this.handleBottomEvent();
        logger.trace(WizardCommonPage.class.getName() + " constructor end.");
    }

    private void setDefaultSetting(Composite page) {
        Rectangle point = this.parent.getBounds();
        FormData fd = new FormData(point.width, point.height);
        fd.left = new FormAttachment(point.x, 0x1000000);
        fd.top = new FormAttachment(point.y, 0x1000000);
        fd.width = point.width;
        fd.height = point.height;
        page.setLayoutData((Object)fd);
        FormLayout formLayout = new FormLayout();
        formLayout.marginBottom = 0;
        formLayout.marginTop = 0;
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        formLayout.marginLeft = 0;
        formLayout.marginRight = 0;
        page.setLayout((Layout)formLayout);
    }

    private void loadImages(UIResource uiResource) throws IMFatalException {
        try {
            this.titleBG = new Image((Device)this.getDisplay(), uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_TOP_BACKGROUND));
            this.infoButtonImageNormal = new Image((Device)this.getDisplay(), uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_TOOLTIP_ICON_NORMAL));
            this.infoButtonImageHover = new Image((Device)this.getDisplay(), uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_TOOLTIP_ICON_FOCUS));
        }
        catch (Exception e) {
            throw new IMFatalException("Can not load image files ==> " + ((Object)((Object)this)).getClass().getName());
        }
    }

    private void createBaseComponent(Composite page, Composite topContainer, Composite centerContainer, Composite bottomContainer, UIResource uiResource) {
        Rectangle boundsTop = uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_TOP);
        Rectangle boundsCenter = uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_CENTER);
        Rectangle boundsSplitter = uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_SPLITTER);
        Rectangle boundsBottom = uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_BOTTOM);
        FormData topFormData = new FormData();
        topFormData.left = new FormAttachment((Control)page, 0, 16384);
        topFormData.top = new FormAttachment((Control)page, 0, 16384);
        topFormData.width = boundsTop.width;
        topFormData.height = boundsTop.height;
        topContainer.setLayoutData((Object)topFormData);
        topContainer.setLayout((Layout)new FormLayout());
        FormData centerFormData = new FormData();
        centerFormData.left = new FormAttachment((Control)page, 0, 16384);
        centerFormData.top = new FormAttachment((Control)page, boundsTop.height, 16384);
        centerFormData.width = boundsCenter.width;
        centerFormData.height = boundsCenter.height;
        centerContainer.setLayoutData((Object)centerFormData);
        centerContainer.setLayout((Layout)new FormLayout());
        centerContainer.setBackground(uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_WHITE));
        FormData splitterFormData = new FormData();
        splitterFormData.left = new FormAttachment((Control)page, 0, 16384);
        splitterFormData.top = new FormAttachment((Control)page, boundsTop.height + boundsCenter.height, 16384);
        splitterFormData.width = boundsSplitter.width;
        splitterFormData.height = boundsSplitter.height;
        this.splitterContainer.setLayoutData((Object)splitterFormData);
        this.splitterContainer.setLayout((Layout)new FormLayout());
        this.splitterContainer.setBackground(uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_GRAY_B0));
        FormData bottomFormData = new FormData();
        bottomFormData.left = new FormAttachment((Control)page, 0, 16384);
        bottomFormData.top = new FormAttachment((Control)page, boundsTop.height + boundsCenter.height + 1, 16384);
        bottomFormData.width = boundsBottom.width;
        bottomFormData.height = boundsBottom.height + 1;
        bottomContainer.setLayoutData((Object)bottomFormData);
        bottomContainer.setLayout((Layout)new FormLayout());
        bottomContainer.setBackground(uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_WHITE));
    }

    private void createTopContainer() {
        this.topContainer.setBackgroundImage(this.titleBG);
        Composite mainContainer = new Composite(this.topContainer, 0);
        Rectangle point = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_TOP);
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.parent, 0, 16384);
        formData.top = new FormAttachment((Control)this.parent, 0, 16384);
        formData.width = point.width;
        formData.height = point.height;
        mainContainer.setLayoutData((Object)formData);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginLeft = 28;
        mainContainer.setLayout((Layout)layout);
        this.createTop(mainContainer, formData.width, point.height);
    }

    private void createTop(Composite mainContainer, int width, int height) {
        Rectangle boundsTitle = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_TITLE_MAIN);
        Rectangle boundsInfo = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_TITLE_INFO);
        GridData gd = null;
        Label title = new Label(mainContainer, 0);
        if (this.installController.isCustomTitle()) {
            title.setText(this.installController.getCustomTitle());
        } else {
            title.setText(this.installController.getCustomTitle().toUpperCase());
        }
        title.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_WHITE));
        title.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_20PX, UIResource.FontType.WIZARD_FONT_TYPE_REGULAR, 0));
        GC gc = new GC((Drawable)title);
        int textHeight = 0;
        textHeight = PlatformUtil.isMacOS() ? gc.getFontMetrics().getHeight() + gc.getFontMetrics().getDescent() : gc.textExtent((String)title.getText()).y;
        gc.dispose();
        gd = new GridData(16384, 1024, true, true);
        gd.widthHint = boundsTitle.width;
        gd.heightHint = textHeight - 2;
        title.setLayoutData((Object)gd);
        this.infoLabel = new Label(mainContainer, 0);
        this.infoLabel.setText("Software License Agreement");
        this.infoLabel.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_WHITE));
        this.infoLabel.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_36PX, UIResource.FontType.WIZARD_FONT_TYPE_BOLD, 1));
        gc = new GC((Drawable)this.infoLabel);
        textHeight = 0;
        textHeight = PlatformUtil.isMacOS() ? gc.getFontMetrics().getHeight() + gc.getFontMetrics().getDescent() : gc.textExtent((String)this.infoLabel.getText()).y;
        gc.dispose();
        gd = new GridData(16384, 128, true, true);
        gd.widthHint = boundsInfo.width;
        gd.heightHint = textHeight;
        this.infoLabel.setLayoutData((Object)gd);
    }

    private void createBottomContainer() {
        Composite mainContainer = new Composite(this.bottomContainer, 0);
        Rectangle point = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_BOTTOM);
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.parent, 0, 16384);
        formData.top = new FormAttachment((Control)this.parent, 0, 16384);
        formData.width = point.width - this.uiResource.getBounds((UIResource.UISizes)UIResource.UISizes.WIZARD_SIZE_BOTTOM_BUTTON_MARGIN).width;
        formData.height = point.height;
        mainContainer.setLayoutData((Object)formData);
        GridLayout layout = new GridLayout(6, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        mainContainer.setLayout((Layout)layout);
        this.createBottom(mainContainer, formData.width, point.height);
    }

    private void createBottom(Composite mainContainer, int width, int height) {
        Rectangle point = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_BOTTOM_BUTTON);
        Rectangle infoButtonBound = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INFO_BUTTON);
        Rectangle infoToolTipBound = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INFO_TOOLTIP);
        Rectangle buttonMargin = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_BOTTOM_BUTTON_MARGIN);
        int buttonWidth = point.width;
        int buttonHeight = point.height;
        int verticalIndent = infoButtonBound.y;
        GridData gd = null;
        this.infoButton = new IMButton(mainContainer, 8);
        this.infoButton.setImage(this.infoButtonImageNormal, this.infoButtonImageHover);
        Rectangle infoImageBounds = this.infoButtonImageNormal.getBounds();
        this.infoButton.setSize(infoImageBounds.width, infoImageBounds.height);
        gd = new GridData(infoImageBounds.width, infoImageBounds.height);
        gd.verticalAlignment = 1;
        gd.horizontalIndent = infoButtonBound.x;
        gd.verticalIndent = verticalIndent + infoButtonBound.height / 2 - infoImageBounds.height / 2;
        this.infoButton.setLayoutData(gd);
        this.infoButton.setBackgroundMode(2);
        this.toolTipLeft = new Image(null, this.uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_TOOLTIP_BG_LEFT));
        this.toolTipMiddle = new Image(null, this.uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_TOOLTIP_BG_CENTER));
        this.toolTipRight = new Image(null, this.uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_TOOLTIP_BG_RIGHT));
        this.toolTiplabel = new Label(mainContainer, 0);
        this.toolTiplabel.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 0));
        GC tempGC = new GC((Drawable)this.toolTiplabel);
        this.format = String.format("Installer Version %s", this.installController.getVersion());
        this.versionInfoTextSize = tempGC.textExtent((String)this.format).x;
        tempGC.dispose();
        this.toolTiplabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                GC gc = arg0.gc;
                gc.setFont(WizardCommonPage.this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 0));
                gc.drawImage(WizardCommonPage.this.toolTipLeft, 0, 0);
                gc.drawImage(WizardCommonPage.this.toolTipRight, ((WizardCommonPage)WizardCommonPage.this).toolTipLeft.getBounds().width + WizardCommonPage.this.versionInfoTextSize, 0);
                for (int i = 0; i < WizardCommonPage.this.versionInfoTextSize; ++i) {
                    gc.drawImage(WizardCommonPage.this.toolTipMiddle, ((WizardCommonPage)WizardCommonPage.this).toolTipLeft.getBounds().width + i, 0);
                }
                gc.setForeground(WizardCommonPage.this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_72));
                gc.drawText(WizardCommonPage.this.format, ((WizardCommonPage)WizardCommonPage.this).toolTipLeft.getBounds().width, ((WizardCommonPage)WizardCommonPage.this).toolTipLeft.getBounds().height / 2 - gc.textExtent((String)((WizardCommonPage)WizardCommonPage.this).format).y / 2 - 2);
                gc.dispose();
            }
        });
        int toolTipWidth = this.toolTipLeft.getBounds().width + this.toolTipRight.getBounds().width + this.versionInfoTextSize;
        gd = new GridData(toolTipWidth, this.toolTipLeft.getBounds().height);
        gd.verticalAlignment = 1;
        gd.horizontalIndent = infoToolTipBound.x;
        gd.verticalIndent = infoToolTipBound.y;
        this.toolTiplabel.setLayoutData((Object)gd);
        this.toolTiplabel.setVisible(false);
        Composite dummy = new Composite(mainContainer, 0);
        gd = new GridData();
        gd.widthHint = width - buttonWidth * 3 - infoButtonBound.width - infoButtonBound.x - buttonMargin.x * 2 - (this.toolTipLeft.getBounds().width + this.toolTipRight.getBounds().width + this.versionInfoTextSize) - infoToolTipBound.x;
        gd.heightHint = height;
        dummy.setLayoutData((Object)gd);
        this.backButton = new Button(mainContainer, 8);
        this.backButton.setText("<  Back");
        this.backButton.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.backButton.setSize(buttonWidth, buttonHeight);
        gd = new GridData(buttonWidth, buttonHeight);
        gd.verticalAlignment = 0x1000000;
        this.backButton.setLayoutData((Object)gd);
        this.firstButton = new Button(mainContainer, 8);
        this.firstButton.setText("Accept");
        this.firstButton.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.firstButton.setSize(buttonWidth, buttonHeight);
        gd = new GridData(buttonWidth, buttonHeight);
        gd.verticalAlignment = 0x1000000;
        gd.horizontalIndent = buttonMargin.x;
        this.firstButton.setLayoutData((Object)gd);
        this.secondButton = new Button(mainContainer, 8);
        this.secondButton.setText("Cancel");
        this.secondButton.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 0));
        gd = new GridData(buttonWidth, buttonHeight);
        gd.verticalAlignment = 0x1000000;
        gd.horizontalIndent = buttonMargin.x;
        this.secondButton.setLayoutData((Object)gd);
    }

    private void handleBottomEvent() {
        this.infoButton.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent arg0) {
                WizardCommonPage.this.toolTiplabel.setVisible(true);
            }

            public void mouseExit(MouseEvent arg0) {
                WizardCommonPage.this.toolTiplabel.setVisible(false);
            }

            public void mouseEnter(MouseEvent arg0) {
                WizardCommonPage.this.toolTiplabel.setVisible(true);
            }
        });
    }
}

