/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.wizard;

import org.apache.logging.log4j.Logger;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.tizen.installer.cli.CLIOptions;
import org.tizen.installer.common.CommonMessages;
import org.tizen.installer.core.InstallController;
import org.tizen.installer.exception.ErrorController;
import org.tizen.installer.exception.IMFatalException;
import org.tizen.installer.ui.custom.UIResource;
import org.tizen.installer.ui.wizard.WizardCommonPage;
import org.tizen.installer.ui.wizard.WizardMaster;
import org.tizen.installer.util.Log;
import org.tizen.installer.util.PlatformUtil;

public class WizardFailPage
extends WizardCommonPage {
    private static final Logger logger = Log.getLogger(WizardFailPage.class);
    private Label textArea;
    private boolean isFirstRun = true;
    boolean isSecond = true;

    public WizardFailPage(Composite parentComposite, UIResource uiResource, InstallController installController, int swtOption, WizardMaster wizardMaster) throws IMFatalException {
        super(parentComposite, swtOption, uiResource, installController, wizardMaster);
        this.createCenterContainer();
        this.handleCompositeEvent();
        this.handleBottomEvent();
    }

    private void handleBottomEvent() {
        this.backButton.setEnabled(false);
        this.backButton.setVisible(false);
        this.firstButton.setEnabled(false);
        this.firstButton.setVisible(false);
        this.secondButton.setText("OK");
        this.secondButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                logger.trace("User click quit button widgetSelected => " + arg0);
                WizardFailPage.this.getShell().close();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                logger.trace((Object)arg0);
            }
        });
    }

    private void handleCompositeEvent() {
        this.centerContainer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                logger.trace((Object)arg0);
                WizardFailPage.this.handleInit();
            }
        });
    }

    private void handleInit() {
        if (this.isFirstRun) {
            this.isFirstRun = false;
            this.infoLabel.setText("Installation has been failed!");
            if (ErrorController.getErrorCode() != null && ErrorController.getErrorCode().equals((Object)ErrorController.ErrorCode.INSTALLATION_CANCEL)) {
                this.infoLabel.setText("Installation Canceled");
                this.textArea.setText(CommonMessages.TEXT_FAILPAGE_TEXT_CANCELED);
            } else {
                this.textArea.setText(ErrorController.getErrorMessage());
                ErrorController.setExitCode(-1);
            }
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WizardFailPage.this.installController.getOption().getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.AUTOMATIC_INSTALLATION)) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        WizardFailPage.this.getShell().close();
                    }
                }
            });
        }
    }

    private void createCenterContainer() {
        Composite leftContainer = new Composite(this.centerContainer, 0x20000000);
        Rectangle bounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INSTALL_IC_SDK);
        Rectangle strokeSize = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INSTALL_IC_STROKE);
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.centerContainer, bounds.x, 0x1000000);
        formData.top = new FormAttachment((Control)this.centerContainer, bounds.y, 0x1000000);
        formData.width = bounds.width;
        formData.height = bounds.height;
        leftContainer.setLayoutData((Object)formData);
        leftContainer.setLayout((Layout)new FillLayout(256));
        Image image = new Image(null, this.uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_INSTALL_IC_CANCELED));
        Rectangle bounds2 = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INSTALL_IC_CANCEL);
        Point centerLeftTop = new Point(bounds2.x, bounds2.y);
        this.uiResource.handleInstallingForWizardProgress(leftContainer, this.uiResource, 0L, bounds.width, bounds.height, bounds.width - (strokeSize.width + strokeSize.height), 1, image, centerLeftTop);
        Rectangle messageBounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_COMPLETED_MESSAGE_LOCATION);
        Composite messageContainer = new Composite(this.centerContainer, 0x20000000);
        FormData rightContainerFormData = new FormData();
        rightContainerFormData.left = new FormAttachment((Control)this.centerContainer, messageBounds.x, 0x1000000);
        rightContainerFormData.top = new FormAttachment((Control)this.centerContainer, messageBounds.y, 0x1000000);
        rightContainerFormData.width = messageBounds.width;
        rightContainerFormData.height = messageBounds.height;
        messageContainer.setLayoutData((Object)rightContainerFormData);
        messageContainer.setLayout((Layout)new FormLayout());
        this.createInfoComposites(messageContainer);
    }

    private void createInfoComposites(Composite topContainer) {
        Rectangle point = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_COMPLETED_MESSAGE_LOCATION);
        String infoMessage = "\n\n\n\n\n";
        this.textArea = new Label(topContainer, 16448);
        this.textArea.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_18PX, false, 1));
        this.textArea.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_33));
        this.textArea.setText(infoMessage);
        GC gc = new GC((Drawable)this.textArea);
        int height = 0;
        height = PlatformUtil.isMacOS() ? gc.textExtent((String)infoMessage).y + 15 : gc.textExtent((String)infoMessage).y;
        gc.dispose();
        FormData infoFormData = new FormData();
        infoFormData.left = new FormAttachment((Control)topContainer, 0, 0x1000000);
        infoFormData.top = new FormAttachment((Control)topContainer, point.height / 2 - height / 2, 0x1000000);
        infoFormData.height = height;
        infoFormData.width = point.width;
        this.textArea.setLayoutData((Object)infoFormData);
    }

    public boolean workEventClose() {
        this.installController.shutdownExtractThread();
        return true;
    }
}

