/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.installer.core.InstallController;
import org.tizen.installer.exception.IMFatalException;
import org.tizen.installer.model.PrerequisitesInfo;
import org.tizen.installer.ui.IMButton;
import org.tizen.installer.ui.custom.CustomImageButton;
import org.tizen.installer.ui.custom.UIResource;
import org.tizen.installer.ui.dialog.CustomMessageBoxDialog;
import org.tizen.installer.ui.wizard.WizardCommonPage;
import org.tizen.installer.ui.wizard.WizardDefaultWindow;
import org.tizen.installer.ui.wizard.WizardMaster;
import org.tizen.installer.util.Log;
import org.tizen.installer.util.PathUtil;
import org.tizen.installer.util.PlatformUtil;
import org.tizen.installer.util.PrerequisiteUtil;

public class WizardReadyPage
extends WizardCommonPage {
    private static final Logger logger = Log.getLogger(WizardReadyPage.class);
    private Label installSize;
    private Label spaceSize;
    private Label dataSpaceSize;
    private Text sdkLocationText;
    private Label sdkLocationLabel;
    private CustomImageButton btnSdkLocation;
    private String prevSdkLocationText = "";
    private String prevDataLocationText = "";
    private Text dataLocationText;
    private Label dataLocationLabel;
    private CustomImageButton btnDataLocation;
    private Image warningIconImage;
    private Image pathIconImageOver;
    private Image pathIconImageNormal;
    private Image pathIconImageSel;
    private String errorMessage = "";
    private boolean isFirstRun = true;
    ArrayList<PrerequisitesInfo> parsePrerequisties = null;
    private Composite dataWarningContainer;
    private Composite installWarningContainer;

    public WizardReadyPage(Composite parentComposite, UIResource uiResource, InstallController installController, int swtOption, WizardMaster wizardMaster) throws IMFatalException {
        super(parentComposite, swtOption, uiResource, installController, wizardMaster);
        try {
            this.loadImages(uiResource);
            this.createCenterContainer();
            this.handleCompositeEvent();
            this.handleBottomEvent();
        }
        catch (Exception e) {
            logger.throwing((Throwable)e);
        }
    }

    private void loadImages(UIResource uiResource) throws IMFatalException {
        try {
            this.warningIconImage = new Image((Device)this.getDisplay(), uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_INSTALL_IC_CAUTION));
            this.pathIconImageOver = new Image((Device)this.getDisplay(), uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_PATH_ICON_OVER));
            this.pathIconImageNormal = new Image((Device)this.getDisplay(), uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_PATH_ICON_NOR));
            this.pathIconImageSel = new Image((Device)this.getDisplay(), uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_PATH_ICON_SEL));
        }
        catch (Exception e) {
            throw new IMFatalException("Can not load image files ==> " + ((Object)((Object)this)).getClass().getName());
        }
    }

    private void handleCompositeEvent() {
        this.centerContainer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                if (WizardReadyPage.this.isFirstRun) {
                    logger.trace("ReadyPage is called. addPaintListener => " + arg0);
                    WizardReadyPage.this.setInitStatus();
                }
            }
        });
        this.sdkLocationText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                logger.trace((Object)arg0);
                if (!WizardReadyPage.this.prevSdkLocationText.equals(WizardReadyPage.this.sdkLocationText.getText().trim())) {
                    WizardReadyPage.this.validateSdkLocation(WizardReadyPage.this.sdkLocationText.getText().trim());
                    WizardReadyPage.this.prevSdkLocationText = WizardReadyPage.this.sdkLocationText.getText().trim();
                    WizardReadyPage.this.sdkLocationText.setToolTipText(WizardReadyPage.this.sdkLocationText.getText().trim());
                }
                WizardReadyPage.this.dataLocationText.setFocus();
            }

            public void focusGained(FocusEvent arg0) {
            }
        });
        this.dataLocationText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                logger.trace((Object)arg0);
                if (!WizardReadyPage.this.prevDataLocationText.equals(WizardReadyPage.this.dataLocationText.getText().trim())) {
                    WizardReadyPage.this.validateDataLocation(WizardReadyPage.this.dataLocationText.getText().trim());
                    WizardReadyPage.this.prevDataLocationText = WizardReadyPage.this.dataLocationText.getText().trim();
                    WizardReadyPage.this.dataLocationText.setToolTipText(WizardReadyPage.this.dataLocationText.getText().trim());
                }
                WizardReadyPage.this.backButton.setFocus();
            }

            public void focusGained(FocusEvent arg0) {
            }
        });
        this.sdkLocationText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
            }

            public void keyPressed(KeyEvent arg0) {
                if (arg0.keyCode == 0x1000050 || arg0.keyCode == 13 || arg0.keyCode == 9) {
                    WizardReadyPage.this.dataLocationText.setFocus();
                }
            }
        });
        this.dataLocationText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
            }

            public void keyPressed(KeyEvent arg0) {
                if (arg0.keyCode == 0x1000050 || arg0.keyCode == 13 || arg0.keyCode == 9) {
                    WizardReadyPage.this.backButton.setFocus();
                }
            }
        });
    }

    private void validateSdkLocation(String dir) {
        File file = new File(dir);
        if (file.exists() && file.isDirectory()) {
            this.checkSdkLocation(dir, file);
        } else if (file.mkdirs()) {
            this.checkSdkLocation(dir, file);
            file.delete();
        } else {
            this.checkSdkLocation(dir, file);
        }
    }

    private void validateDataLocation(String dir) {
        File file = new File(dir);
        if (file.exists() && file.isDirectory()) {
            this.checkDataLocation(dir, file);
        } else if (file.mkdirs()) {
            this.checkDataLocation(dir, file);
            file.delete();
        } else {
            this.checkDataLocation(dir, file);
        }
    }

    private void checkSdkLocation(String dir, File file) {
        String installDir = this.checkIsAvaliableDirectory(dir, file);
        if (installDir != null) {
            if (this.checkInstallAndDataDirectoryIsSame(this.installController.getConfig().getDataLocation(), installDir)) {
                logger.error("Can not set the same directory ==> " + installDir);
                this.errorMessage = "The installation and data directory should be different.\nChange to another directory.";
                this.installController.getConfig().setInstallDirectory(installDir);
                this.installController.getConfig().setAvaliableInstallDirectory(false);
                this.checkInstallButtonEnable();
                return;
            }
            this.installController.getConfig().setInstallDirectory(installDir);
            this.installController.getConfig().setAvaliableInstallDirectory(true);
            this.sdkLocationText.setToolTipText(this.installController.getConfig().getInstallDirectory());
            this.sdkLocationText.setText(this.installController.getConfig().getInstallDirectory());
            long avaliableSize = PathUtil.getAvailableSpaceSize(this.installController.getConfig().getInstallDirectory());
            this.spaceSize.setText("Space available  " + PathUtil.getSizeToString(avaliableSize));
        } else {
            this.installController.getConfig().setInstallDirectory(installDir);
            this.installController.getConfig().setAvaliableInstallDirectory(false);
        }
        this.checkInstallButtonEnable();
    }

    private void checkDataLocation(String dir, File file) {
        String installDir = this.checkIsAvaliableDirectory(dir, file);
        if (installDir != null) {
            if (this.checkInstallAndDataDirectoryIsSame(this.installController.getConfig().getInstallDirectory(), installDir)) {
                logger.error("Can not set the same directory ==> " + installDir);
                this.errorMessage = "The installation and data directory should be different.\nChange to another directory.";
                this.installController.getConfig().setDataLocation(installDir);
                this.installController.getConfig().setAvaliableDataDirectory(false);
                this.checkInstallButtonEnable();
                return;
            }
            this.installController.getConfig().setDataLocation(installDir);
            this.installController.getConfig().setAvaliableDataDirectory(true);
            this.dataLocationText.setToolTipText(this.installController.getConfig().getDataLocation());
            this.dataLocationText.setText(this.installController.getConfig().getDataLocation());
            long avaliableSize = PathUtil.getAvailableSpaceSize(this.installController.getConfig().getDataLocation());
            this.dataSpaceSize.setText("Space available  " + PathUtil.getSizeToString(avaliableSize));
        } else {
            this.installController.getConfig().setDataLocation(installDir);
            this.installController.getConfig().setAvaliableDataDirectory(false);
        }
        this.checkInstallButtonEnable();
    }

    private void setInitStatus() {
        this.isFirstRun = false;
        this.infoLabel.setText("Installation Settings");
        this.checkInstallButtonEnable();
        this.sdkLocationText.setText(this.installController.getConfig().getInstallDirectory());
        this.prevSdkLocationText = this.installController.getConfig().getInstallDirectory();
        if (!this.installController.getConfig().isAvaliableInstallDirectory()) {
            this.errorMessage = "Target directory is not valid.";
        }
    }

    private void createCenterContainer() {
        Composite leftContainer = new Composite(this.centerContainer, 0x20000000);
        Rectangle bounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INSTALL_IC_SDK);
        Rectangle strokeSize = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INSTALL_IC_STROKE);
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.centerContainer, bounds.x, 0x1000000);
        formData.top = new FormAttachment((Control)this.centerContainer, bounds.y, 0x1000000);
        formData.width = bounds.width;
        formData.height = bounds.height;
        leftContainer.setLayoutData((Object)formData);
        leftContainer.setLayout((Layout)new FillLayout(256));
        this.uiResource.handleInstallingForWizardProgress(leftContainer, this.uiResource, 0L, bounds.width, bounds.height, bounds.width - (strokeSize.width + strokeSize.height), 1);
        int SWT_OPTION = 0x20000000;
        this.createSdkLocationTopComposites(SWT_OPTION);
        this.createSdkLocationBottomComposites(SWT_OPTION);
        this.createSdkLocationErrorContainerComposites(SWT_OPTION);
        this.createDataLocationTopComposites(SWT_OPTION);
        this.createDataLocationBottomComposites(SWT_OPTION);
        this.createDataLocationErrorContainerComposites(SWT_OPTION);
    }

    private void createSdkLocationTopComposites(int SWT_OPTION) {
        Rectangle sdkLocationTop = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_SDK_LOCATION_TOP);
        Composite sdkLocationTopContainer = new Composite(this.centerContainer, SWT_OPTION);
        FormData sdkLocationTopContainerFormData = new FormData();
        sdkLocationTopContainerFormData.left = new FormAttachment((Control)this.centerContainer, sdkLocationTop.x, 0x1000000);
        sdkLocationTopContainerFormData.top = new FormAttachment((Control)this.centerContainer, sdkLocationTop.y, 0x1000000);
        sdkLocationTopContainerFormData.width = sdkLocationTop.width;
        sdkLocationTopContainerFormData.height = sdkLocationTop.height;
        sdkLocationTopContainer.setLayoutData((Object)sdkLocationTopContainerFormData);
        sdkLocationTopContainer.setLayout((Layout)new FillLayout(256));
        Composite mainContainer = this.createRightCompositeLayout(sdkLocationTopContainer);
        mainContainer.setBackgroundMode(0);
        this.createInstallationLocationLabelComposites(mainContainer);
        Rectangle sdkLocationMiddle = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_SDK_LOCATION_MIDDLE);
        Composite sdkLocationMiddleContainer = new Composite(this.centerContainer, SWT_OPTION);
        FormData sdkLocationMiddleContainerFormData = new FormData();
        sdkLocationMiddleContainerFormData.left = new FormAttachment((Control)this.centerContainer, sdkLocationMiddle.x, 0x1000000);
        sdkLocationMiddleContainerFormData.top = new FormAttachment((Control)this.centerContainer, sdkLocationMiddle.y, 0x1000000);
        sdkLocationMiddleContainerFormData.width = sdkLocationMiddle.width;
        sdkLocationMiddleContainerFormData.height = sdkLocationMiddle.height;
        sdkLocationMiddleContainer.setLayoutData((Object)sdkLocationMiddleContainerFormData);
        sdkLocationMiddleContainer.setLayout((Layout)new FillLayout(256));
        Composite mainContainer2 = this.createRightCompositeLayout(sdkLocationMiddleContainer);
        this.installLocationTextBox(mainContainer2);
        this.sdkLocationText.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_PURE_BLUE));
        this.sdkLocationLabel.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_33));
        this.sdkLocationText.setToolTipText(this.installController.getConfig().getInstallDirectory());
        this.sdkLocationText.setText(this.installController.getConfig().getInstallDirectory());
        this.btnSdkLocation.addMouseListener(new MouseListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseUp(MouseEvent arg0) {
                logger.trace("installationLocation is mouseUp event. => " + arg0);
                String dir = null;
                File temp = new File(WizardReadyPage.this.sdkLocationText.getToolTipText().trim());
                String filter = "";
                filter = temp.exists() ? temp.getAbsolutePath() : temp.getParent();
                File file = null;
                DirectoryDialog directoryDialog = new DirectoryDialog(WizardReadyPage.this.getShell(), 65536);
                directoryDialog.setFilterPath(filter);
                directoryDialog.setMessage("Select a directory.");
                WizardReadyPage.this.getShell().setEnabled(false);
                try {
                    dir = directoryDialog.open();
                }
                catch (Exception e) {
                    logger.throwing((Throwable)e);
                }
                finally {
                    if (!WizardReadyPage.this.getShell().isDisposed()) {
                        WizardReadyPage.this.getShell().setEnabled(true);
                    }
                }
                if (dir != null) {
                    logger.trace("Install location is changed. ==> " + dir);
                    if (file == null) {
                        file = new File(dir);
                    }
                    if (file.exists() && file.isDirectory()) {
                        this.checkIsAvaliableDirectoryInEvent(arg0, dir, file);
                    } else if (file.mkdirs()) {
                        this.checkIsAvaliableDirectoryInEvent(arg0, dir, file);
                        file.delete();
                    } else {
                        this.mouseUp(arg0);
                    }
                }
            }

            private void checkIsAvaliableDirectoryInEvent(MouseEvent arg0, String dir, File file) {
                String installDir = WizardReadyPage.this.checkIsAvaliableDirectory(arg0, dir, file, this);
                if (installDir != null) {
                    if (WizardReadyPage.this.checkInstallAndDataDirectoryIsSame(WizardReadyPage.this.installController.getConfig().getDataLocation(), installDir)) {
                        logger.error("Can not set the same directory ==> " + installDir);
                        String msg = "The installation and data directory should be different.\nChange to another directory.";
                        logger.trace("Display message box start.");
                        CustomMessageBoxDialog dialog = new CustomMessageBoxDialog(WizardReadyPage.this.getShell(), WizardReadyPage.this.uiResource, "Installer", msg, CustomMessageBoxDialog.DialogType.ERROR, false);
                        dialog.open();
                        logger.trace("Display message box finished.");
                        logger.trace("Transfer event to directory Dialog again.");
                        this.mouseUp(arg0);
                        return;
                    }
                    WizardReadyPage.this.installController.getConfig().setInstallDirectory(installDir);
                    WizardReadyPage.this.installController.getConfig().setAvaliableInstallDirectory(true);
                    WizardReadyPage.this.prevSdkLocationText = installDir;
                    WizardReadyPage.this.sdkLocationText.setForeground(WizardReadyPage.this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_PURE_BLUE));
                    WizardReadyPage.this.sdkLocationLabel.setForeground(WizardReadyPage.this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_33));
                    WizardReadyPage.this.sdkLocationText.setToolTipText(WizardReadyPage.this.installController.getConfig().getInstallDirectory());
                    WizardReadyPage.this.sdkLocationText.setText(WizardReadyPage.this.installController.getConfig().getInstallDirectory());
                    long avaliableSize = PathUtil.getAvailableSpaceSize(WizardReadyPage.this.installController.getConfig().getInstallDirectory());
                    WizardReadyPage.this.spaceSize.setText("Space available  " + PathUtil.getSizeToString(avaliableSize));
                    WizardReadyPage.this.checkInstallButtonEnable();
                }
            }

            public void mouseDown(MouseEvent arg0) {
                logger.trace((Object)arg0);
            }

            public void mouseDoubleClick(MouseEvent arg0) {
                logger.trace((Object)arg0);
            }
        });
        this.uiResource.setMouseCurosr((Control)this.btnSdkLocation);
    }

    private void createInstallationLocationLabelComposites(Composite parent) {
        this.sdkLocationLabel = new Label(parent, 0);
        this.sdkLocationLabel.setText("SDK location");
        this.sdkLocationLabel.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 1));
        this.sdkLocationLabel.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_33));
        Rectangle labelBounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INSTALL_LOCATION_LABEL);
        GridData gd = new GridData(labelBounds.width, labelBounds.height);
        gd.verticalAlignment = 128;
        this.sdkLocationLabel.setLayoutData((Object)gd);
        for (int i = 0; i < 2; ++i) {
            Composite dummy = new Composite(parent, 0);
            gd = new GridData(10, labelBounds.height);
            gd.verticalAlignment = 128;
            dummy.setLayoutData((Object)gd);
        }
    }

    private void installLocationTextBox(Composite parent) {
        this.sdkLocationText = new Text(parent, 2048);
        GridData gd = new GridData(256, 18);
        gd.verticalAlignment = 0x1000000;
        this.sdkLocationText.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.sdkLocationText.setLayoutData((Object)gd);
        this.btnSdkLocation = new CustomImageButton(parent, 0);
        this.btnSdkLocation.setImage(this.pathIconImageNormal, this.pathIconImageOver, this.pathIconImageSel, this.pathIconImageNormal);
        gd = new GridData(24, 24);
        gd.verticalAlignment = 0x1000000;
        gd.horizontalIndent = 2;
        this.btnSdkLocation.setSize(24, 24);
        this.btnSdkLocation.setLayoutData(gd);
        Composite dummy = new Composite(parent, 0);
        gd = new GridData(1, 24);
        gd.verticalAlignment = 0x1000000;
        dummy.setLayoutData((Object)gd);
    }

    private void createSdkLocationBottomComposites(int SWT_OPTION) {
        Rectangle sdkLocationBottom = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_SDK_LOCATION_BOTTOM);
        Composite sdkLocationBottomContainer = new Composite(this.centerContainer, SWT_OPTION);
        FormData sdkLocationBottomContainerFormData = new FormData();
        sdkLocationBottomContainerFormData.left = new FormAttachment((Control)this.centerContainer, sdkLocationBottom.x, 0x1000000);
        sdkLocationBottomContainerFormData.top = new FormAttachment((Control)this.centerContainer, sdkLocationBottom.y, 0x1000000);
        sdkLocationBottomContainerFormData.width = sdkLocationBottom.width;
        sdkLocationBottomContainerFormData.height = sdkLocationBottom.height;
        sdkLocationBottomContainer.setLayoutData((Object)sdkLocationBottomContainerFormData);
        sdkLocationBottomContainer.setLayout((Layout)new FillLayout(256));
        Composite mainContainer = this.createRightCompositeLayout(sdkLocationBottomContainer);
        this.createInstallSizeComposites(mainContainer);
    }

    private void createInstallSizeComposites(Composite parent) {
        int marginTop = 0;
        this.installSize = new Label(parent, 0);
        this.installSize.setText("Installation size  " + this.installController.getSdkImageInfo().getInstallSize());
        this.installSize.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_11PX, false, 0));
        this.installSize.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_58));
        GC gc = new GC((Drawable)this.installSize);
        Point textExtent = gc.textExtent(this.installSize.getText());
        gc.dispose();
        GridData gd = new GridData(textExtent.x, textExtent.y);
        gd.verticalIndent = marginTop;
        gd.horizontalIndent = 0;
        this.installSize.setLayoutData((Object)gd);
        Composite dummy2 = new Composite(parent, 0);
        gd = new GridData(1, 10);
        gd.verticalIndent = marginTop;
        gd.horizontalIndent = 15;
        dummy2.setLayoutData((Object)gd);
        dummy2.setBackground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_GRAY_80));
        this.spaceSize = new Label(parent, 16384);
        long avaliableSize = PathUtil.getAvailableSpaceSize(this.installController.getConfig().getInstallDirectory());
        this.spaceSize.setText("Space available  " + PathUtil.getSizeToString(avaliableSize));
        this.spaceSize.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_11PX, false, 0));
        this.spaceSize.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_58));
        gc = new GC((Drawable)this.spaceSize);
        Point textExtentSpaceSize = gc.textExtent(this.spaceSize.getText());
        gc.dispose();
        gd = new GridData(textExtentSpaceSize.x, textExtentSpaceSize.y);
        gd.verticalIndent = marginTop;
        gd.horizontalIndent = 15;
        this.spaceSize.setLayoutData((Object)gd);
    }

    private void createDataLocationTopComposites(int SWT_OPTION) {
        Rectangle dataBounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_DATA_LOCATION_TOP);
        Composite dataLocationContainer = new Composite(this.centerContainer, SWT_OPTION);
        FormData dataLocationContainerFormData = new FormData();
        dataLocationContainerFormData.left = new FormAttachment((Control)this.centerContainer, dataBounds.x, 0x1000000);
        dataLocationContainerFormData.top = new FormAttachment((Control)this.centerContainer, dataBounds.y, 0x1000000);
        dataLocationContainerFormData.width = dataBounds.width;
        dataLocationContainerFormData.height = dataBounds.height;
        dataLocationContainer.setLayoutData((Object)dataLocationContainerFormData);
        dataLocationContainer.setLayout((Layout)new FillLayout(256));
        Composite mainContainer = this.createRightCompositeLayout(dataLocationContainer);
        this.createDataLocationLabelComposites(mainContainer);
        Rectangle dataMiddleBounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_DATA_LOCATION_MIDDLE);
        Composite dataMiddleBoundsContainer = new Composite(this.centerContainer, SWT_OPTION);
        FormData dataMiddleBoundsContainerFormData = new FormData();
        dataMiddleBoundsContainerFormData.left = new FormAttachment((Control)this.centerContainer, dataMiddleBounds.x, 0x1000000);
        dataMiddleBoundsContainerFormData.top = new FormAttachment((Control)this.centerContainer, dataMiddleBounds.y, 0x1000000);
        dataMiddleBoundsContainerFormData.width = dataMiddleBounds.width;
        dataMiddleBoundsContainerFormData.height = dataMiddleBounds.height;
        dataMiddleBoundsContainer.setLayoutData((Object)dataMiddleBoundsContainerFormData);
        dataMiddleBoundsContainer.setLayout((Layout)new FillLayout(256));
        Composite mainContainer2 = this.createRightCompositeLayout(dataMiddleBoundsContainer);
        this.createDataLocationComposite(mainContainer2);
        this.dataLocationText.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_PURE_BLUE));
        this.dataLocationLabel.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_33));
        this.dataLocationText.setToolTipText(this.installController.getConfig().getDataLocation());
        this.dataLocationText.setText(this.installController.getConfig().getDataLocation());
        this.prevDataLocationText = this.installController.getConfig().getDataLocation();
        this.btnDataLocation.addMouseListener(new MouseListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseUp(MouseEvent arg0) {
                logger.trace("dataLocation is mouseUp event. => " + arg0);
                String dir = null;
                File temp = new File(WizardReadyPage.this.dataLocationText.getToolTipText().trim());
                String filter = "";
                filter = temp.exists() ? temp.getAbsolutePath() : temp.getParent();
                File file = null;
                DirectoryDialog directoryDialog = new DirectoryDialog(WizardReadyPage.this.getShell(), 65536);
                directoryDialog.setFilterPath(filter);
                directoryDialog.setMessage("Select a directory.");
                WizardReadyPage.this.getShell().setEnabled(false);
                try {
                    dir = directoryDialog.open();
                }
                catch (Exception e) {
                    logger.throwing((Throwable)e);
                }
                finally {
                    if (!WizardReadyPage.this.getShell().isDisposed()) {
                        WizardReadyPage.this.getShell().setEnabled(true);
                    }
                }
                if (dir != null) {
                    logger.trace("Data location is changed. ==> " + dir);
                    if (file == null) {
                        file = new File(dir);
                    }
                    if (file.exists() && file.isDirectory()) {
                        this.checkIsAvaliableDirectoryInEvent(arg0, dir, file);
                    } else if (file.mkdirs()) {
                        this.checkIsAvaliableDirectoryInEvent(arg0, dir, file);
                        file.delete();
                    } else {
                        this.mouseUp(arg0);
                    }
                }
            }

            private void checkIsAvaliableDirectoryInEvent(MouseEvent arg0, String dir, File file) {
                String dataDir = WizardReadyPage.this.checkIsAvaliableDirectory(arg0, dir, file, this);
                if (dataDir != null) {
                    if (WizardReadyPage.this.checkInstallAndDataDirectoryIsSame(WizardReadyPage.this.installController.getConfig().getInstallDirectory(), dataDir)) {
                        logger.error("Can not set the same directory ==> " + dataDir);
                        String msg = "The installation and data directory should be different.\nChange to another directory.";
                        logger.trace("Display message box start.");
                        CustomMessageBoxDialog dialog = new CustomMessageBoxDialog(WizardReadyPage.this.getShell(), WizardReadyPage.this.uiResource, "Installer", msg, CustomMessageBoxDialog.DialogType.ERROR, false);
                        dialog.open();
                        logger.trace("Display message box finished.");
                        logger.trace("Transfer event to directory Dialog again.");
                        this.mouseUp(arg0);
                        return;
                    }
                    WizardReadyPage.this.installController.getConfig().setDataLocation(dataDir);
                    WizardReadyPage.this.installController.getConfig().setAvaliableDataDirectory(true);
                    WizardReadyPage.this.prevDataLocationText = dataDir;
                    WizardReadyPage.this.dataLocationText.setForeground(WizardReadyPage.this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_PURE_BLUE));
                    WizardReadyPage.this.dataLocationLabel.setForeground(WizardReadyPage.this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_33));
                    WizardReadyPage.this.dataLocationText.setToolTipText(WizardReadyPage.this.installController.getConfig().getDataLocation());
                    WizardReadyPage.this.dataLocationText.setText(WizardReadyPage.this.installController.getConfig().getDataLocation());
                    long avaliableSize = PathUtil.getAvailableSpaceSize(WizardReadyPage.this.installController.getConfig().getDataLocation());
                    WizardReadyPage.this.dataSpaceSize.setText("Space available  " + PathUtil.getSizeToString(avaliableSize));
                    WizardReadyPage.this.checkInstallButtonEnable();
                }
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.uiResource.setMouseCurosr((Control)this.btnDataLocation);
    }

    private void createDataLocationLabelComposites(Composite parent) {
        this.dataLocationLabel = new Label(parent, 0);
        this.dataLocationLabel.setText("Data location");
        this.dataLocationLabel.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 1));
        this.dataLocationLabel.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_33));
        Rectangle labelBounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INSTALL_LOCATION_LABEL);
        GridData gd = new GridData(labelBounds.width, labelBounds.height);
        this.dataLocationLabel.setLayoutData((Object)gd);
        for (int i = 0; i < 2; ++i) {
            Composite dummy = new Composite(parent, 0);
            gd = new GridData(1, 1);
            dummy.setLayoutData((Object)gd);
        }
    }

    private void createDataLocationComposite(Composite parent) {
        this.dataLocationText = new Text(parent, 2048);
        GridData gd = new GridData(256, 18);
        gd.verticalAlignment = 0x1000000;
        this.dataLocationText.setLayoutData((Object)gd);
        this.dataLocationText.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.btnDataLocation = new CustomImageButton(parent, 0);
        this.btnDataLocation.setImage(this.pathIconImageNormal, this.pathIconImageOver, this.pathIconImageSel, this.pathIconImageNormal);
        gd = new GridData(24, 24);
        gd.verticalAlignment = 0x1000000;
        gd.horizontalIndent = 2;
        this.btnDataLocation.setSize(24, 24);
        this.btnDataLocation.setLayoutData(gd);
        Composite dummy = new Composite(parent, 0);
        gd = new GridData(1, 24);
        gd.verticalAlignment = 0x1000000;
        dummy.setLayoutData((Object)gd);
    }

    private void createDataLocationBottomComposites(int SWT_OPTION) {
        Rectangle dataLocationBottom = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_DATA_LOCATION_BOTTOM);
        Composite dataLocationBottomContainer = new Composite(this.centerContainer, SWT_OPTION);
        FormData dataLocationBottomContainerFormData = new FormData();
        dataLocationBottomContainerFormData.left = new FormAttachment((Control)this.centerContainer, dataLocationBottom.x, 0x1000000);
        dataLocationBottomContainerFormData.top = new FormAttachment((Control)this.centerContainer, dataLocationBottom.y, 0x1000000);
        dataLocationBottomContainerFormData.width = dataLocationBottom.width;
        dataLocationBottomContainerFormData.height = dataLocationBottom.height;
        dataLocationBottomContainer.setLayoutData((Object)dataLocationBottomContainerFormData);
        dataLocationBottomContainer.setLayout((Layout)new FillLayout(256));
        Composite mainContainer = this.createRightCompositeLayout(dataLocationBottomContainer);
        int marginTop = 0;
        GridData gd = null;
        this.dataSpaceSize = new Label(mainContainer, 16384);
        long avaliableSize = PathUtil.getAvailableSpaceSize(this.installController.getConfig().getDataLocation());
        this.dataSpaceSize.setText("Space available  " + PathUtil.getSizeToString(avaliableSize));
        this.dataSpaceSize.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_11PX, false, 0));
        this.dataSpaceSize.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_58));
        GC gc = new GC((Drawable)this.dataSpaceSize);
        Point textExtentSpaceSize = gc.textExtent(this.dataSpaceSize.getText());
        gc.dispose();
        gd = new GridData(textExtentSpaceSize.x, textExtentSpaceSize.y);
        gd.verticalIndent = marginTop;
        this.dataSpaceSize.setLayoutData((Object)gd);
        Composite dummy2 = new Composite(this.parent, 0);
        gd = new GridData(1, 10);
        gd.verticalIndent = marginTop;
        gd.horizontalIndent = 15;
        dummy2.setLayoutData((Object)gd);
    }

    private void createDataLocationErrorContainerComposites(int SWT_OPTION) {
        Rectangle dataErrorBounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_DATA_LOCATION_ERROR);
        Composite dataLocationErrorContainer = new Composite(this.centerContainer, SWT_OPTION);
        FormData dataLocationErrorContainerFormData = new FormData();
        dataLocationErrorContainerFormData.left = new FormAttachment((Control)this.centerContainer, dataErrorBounds.x, 0x1000000);
        dataLocationErrorContainerFormData.top = new FormAttachment((Control)this.centerContainer, dataErrorBounds.y, 0x1000000);
        dataLocationErrorContainerFormData.width = dataErrorBounds.width;
        dataLocationErrorContainerFormData.height = dataErrorBounds.height;
        dataLocationErrorContainer.setLayoutData((Object)dataLocationErrorContainerFormData);
        dataLocationErrorContainer.setLayout((Layout)new FillLayout(256));
        this.dataWarningContainer = this.createRightCompositeLayout(dataLocationErrorContainer);
        this.createErrorMsgCompositeForInstallationLocation(this.dataWarningContainer);
    }

    private void createSdkLocationErrorContainerComposites(int SWT_OPTION) {
        Rectangle errorBounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_SDK_LOCATION_ERROR);
        Composite installationLocationErrorContainer = new Composite(this.centerContainer, SWT_OPTION);
        FormData installationLocationErrorContainerFromData = new FormData();
        installationLocationErrorContainerFromData.left = new FormAttachment((Control)this.centerContainer, errorBounds.x, 0x1000000);
        installationLocationErrorContainerFromData.top = new FormAttachment((Control)this.centerContainer, errorBounds.y, 0x1000000);
        installationLocationErrorContainerFromData.width = errorBounds.width;
        installationLocationErrorContainerFromData.height = errorBounds.height;
        installationLocationErrorContainer.setLayoutData((Object)installationLocationErrorContainerFromData);
        installationLocationErrorContainer.setLayout((Layout)new FillLayout(256));
        this.installWarningContainer = this.createRightCompositeLayout(installationLocationErrorContainer);
        this.createErrorMsgCompositeForInstallationLocation(this.installWarningContainer);
    }

    private Composite createRightCompositeLayout(Composite rightContainer) {
        Composite mainContainer = new Composite(rightContainer, 0);
        Rectangle point = this.uiResource.getBounds(UIResource.UISizes.SIZE_READYPAGE_INSTALL_BASE);
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)rightContainer, 0, 0x1000000);
        formData.top = new FormAttachment((Control)rightContainer, 0, 0x1000000);
        formData.width = point.width;
        formData.height = point.height;
        mainContainer.setLayoutData((Object)formData);
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        mainContainer.setLayout((Layout)layout);
        return mainContainer;
    }

    private void createErrorMsgCompositeForInstallationLocation(Composite parent) {
        IMButton ibm = new IMButton(parent, 0x20000000);
        GridData gd = new GridData(this.warningIconImage.getBounds().width, this.warningIconImage.getBounds().height);
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 0x1000000;
        ibm.setLayoutData(gd);
        ibm.setImage(this.warningIconImage);
        Label errorText = new Label(parent, 0);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.horizontalIndent = 3;
        gd.horizontalAlignment = 16384;
        errorText.setLayoutData((Object)gd);
        errorText.setText("Target directory is not valid.");
        errorText.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_READYPAGE_WARN_MESSAGE));
        errorText.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 0));
        StyledText viewMore = new StyledText(parent, 16452);
        viewMore.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 0));
        viewMore.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_READYPAGE_WARN_LINK));
        viewMore.setEditable(false);
        viewMore.setCaret(null);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 16384;
        gd.horizontalIndent = 8;
        viewMore.setLayoutData((Object)gd);
        this.uiResource.setTextStyle(viewMore, "View more", true);
        this.uiResource.setMouseCurosr((Control)viewMore);
        viewMore.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
                String warningMsg = String.format("- The target directory must be empty.\n- There must be at least %s of free disk space in the target directory.\n- You need \"Write\" permissions to the target directory.\n- The installation and data directory should be different.\n- Specify different directory with proper access rights.", WizardReadyPage.this.installController.getSdkImageInfo().getInstallSize());
                logger.trace("Display message box start.");
                CustomMessageBoxDialog dialog = new CustomMessageBoxDialog(WizardReadyPage.this.getShell(), WizardReadyPage.this.uiResource, "Installer", "The target directory is not valid. Check the following and try again:", warningMsg, CustomMessageBoxDialog.DialogType.ERROR, false);
                dialog.open();
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        viewMore.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
            }

            public void focusGained(FocusEvent arg0) {
                WizardReadyPage.this.dataLocationText.setFocus();
            }
        });
    }

    private boolean checkInstallAndDataDirectoryIsSame(String installDir, String dataDir) {
        File installDirFile = new File(installDir);
        File dataDirFile = new File(dataDir);
        return installDirFile.getAbsolutePath().equals(dataDirFile.getAbsolutePath());
    }

    private String checkIsAvaliableDirectory(String dir, File file) {
        String installDir = dir;
        PathUtil.AvaliableDirectory avaliableInstallDirectory = PathUtil.isAvaliableInstallDirectory(file, dir, this.installController);
        if (avaliableInstallDirectory != PathUtil.AvaliableDirectory.NO_ERROR) {
            logger.error(avaliableInstallDirectory.getUIMessage() + " ==> " + dir);
            this.errorMessage = avaliableInstallDirectory.getUIMessage();
            return null;
        }
        logger.trace("Target directory is avaliable to install");
        return installDir;
    }

    private String checkIsAvaliableDirectory(MouseEvent arg0, String dir, File file, MouseListener mouseListener) {
        String installDir = dir;
        PathUtil.AvaliableDirectory avaliableInstallDirectory = PathUtil.isAvaliableInstallDirectory(file, dir, this.installController);
        if (avaliableInstallDirectory == PathUtil.AvaliableDirectory.NO_ERROR) {
            logger.trace("Target directory is avaliable to install");
            return installDir;
        }
        logger.error(avaliableInstallDirectory.getUIMessage() + " ==> " + dir);
        this.errorMessage = avaliableInstallDirectory.getUIMessage();
        CustomMessageBoxDialog dialog = new CustomMessageBoxDialog(this.getShell(), this.uiResource, "Installer", this.errorMessage, CustomMessageBoxDialog.DialogType.ERROR, false);
        dialog.open();
        logger.trace("Display message box finished.");
        logger.trace("Transfer event to directory Dialog again.");
        mouseListener.mouseUp(arg0);
        return null;
    }

    private void checkInstallButtonEnable() {
        if (!this.installController.getConfig().isAvaliableInstallDirectory()) {
            this.installWarningContainer.setVisible(true);
            this.sdkLocationLabel.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_READYPAGE_DIRECTORY_ERROR));
        } else {
            this.installWarningContainer.setVisible(false);
            this.sdkLocationLabel.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_33));
        }
        if (!this.installController.getConfig().isAvaliableDataDirectory()) {
            this.dataWarningContainer.setVisible(true);
            this.dataLocationLabel.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_READYPAGE_DIRECTORY_ERROR));
        } else {
            this.dataWarningContainer.setVisible(false);
            this.dataLocationLabel.setForeground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_33));
        }
    }

    private void handleBottomEvent() {
        this.backButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardReadyPage.this.wizardMaster.enablePages(WizardDefaultWindow.WIZARD_PAGES.LICENSE_PAGE);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.firstButton.setText("Install");
        this.firstButton.setFocus();
        this.secondButton.setText("Cancel");
        this.handleEventFirstButton(this.firstButton);
        this.secondButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                logger.trace("User click quit button widgetSelected => " + arg0);
                WizardReadyPage.this.getShell().close();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                logger.trace((Object)arg0);
            }
        });
    }

    private void handleEventFirstButton(Button installButton) {
        installButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
                logger.trace("User click install button mouseUp event => " + arg0);
                if (!WizardReadyPage.this.installController.getConfig().isAvaliableDataDirectory() || !WizardReadyPage.this.installController.getConfig().isAvaliableInstallDirectory()) {
                    CustomMessageBoxDialog dialog = new CustomMessageBoxDialog(WizardReadyPage.this.getShell(), WizardReadyPage.this.uiResource, "Installer", WizardReadyPage.this.errorMessage, CustomMessageBoxDialog.DialogType.ERROR, false);
                    dialog.open();
                    return;
                }
                if (PlatformUtil.isLinux() && WizardReadyPage.this.installController.getInstalledFile() != null) {
                    Map<String, List<String>> checkPrerequisities;
                    if (WizardReadyPage.this.parsePrerequisties == null) {
                        WizardReadyPage.this.parsePrerequisties = PrerequisiteUtil.parsePrerequisties(WizardReadyPage.this.installController.getInstalledFile());
                    }
                    if ((checkPrerequisities = PrerequisiteUtil.checkPrerequisities(WizardReadyPage.this.parsePrerequisties)) != null && checkPrerequisities.size() > 0) {
                        String msg = "Required prerequisite packages are not installed.\nPlease install the packages using following command(s).\n";
                        logger.trace("\tUnder libraries are not installed");
                        logger.trace("\t##############################################");
                        Set<String> keySet = checkPrerequisities.keySet();
                        Iterator<String> iterator = keySet.iterator();
                        while (iterator.hasNext()) {
                            String key;
                            String pkgName = key = iterator.next();
                            if (key.endsWith("*")) {
                                pkgName = key.substring(0, key.lastIndexOf("*"));
                            }
                            String msgValue = "sudo apt-get install " + pkgName;
                            msg = msg + msgValue + "\n";
                            logger.trace("\t" + msgValue);
                        }
                        logger.trace("\t##############################################");
                        CustomMessageBoxDialog dialog = new CustomMessageBoxDialog(WizardReadyPage.this.getShell(), WizardReadyPage.this.uiResource, "Installer", msg, CustomMessageBoxDialog.DialogType.INFO, false);
                        dialog.open();
                        return;
                    }
                }
                WizardReadyPage.this.wizardMaster.enablePages(WizardDefaultWindow.WIZARD_PAGES.INSTALLING_PAGE);
            }

            public void mouseDown(MouseEvent arg0) {
                logger.trace((Object)arg0);
            }

            public void mouseDoubleClick(MouseEvent arg0) {
                logger.trace((Object)arg0);
            }
        });
    }

    public boolean workEventClose() {
        CustomMessageBoxDialog dialog = new CustomMessageBoxDialog(this.getShell(), this.uiResource, "Installer", "Are you sure you want to exit the Installer?", CustomMessageBoxDialog.DialogType.QESTION, false);
        int ret = dialog.open();
        if (ret == 1) {
            logger.trace("User select not to quit.");
            return false;
        }
        this.installController.shutdownExtractThread();
        logger.trace("User select quit.");
        return true;
    }
}

