/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.logging.log4j.Logger;
import org.tizen.installer.common.IInstallProgressMonitor;
import org.tizen.installer.exception.ErrorController;
import org.tizen.installer.exception.IMFatalException;
import org.tizen.installer.util.Log;

public class FileUtil {
    public static final int BUF_SIZE = 65536;
    private static final Logger logger = Log.getLogger(FileUtil.class);

    public static String readAllTextFromFile(String filePath, boolean carrageReturn) {
        StringBuffer txt = new StringBuffer();
        FileInputStream is = null;
        BufferedReader in = null;
        try {
            String strLicense;
            is = new FileInputStream(filePath);
            in = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            while ((strLicense = in.readLine()) != null) {
                if (strLicense.isEmpty()) continue;
                txt.append(strLicense);
                if (!carrageReturn) continue;
                txt.append("\n");
            }
        }
        catch (IOException e) {
            throw new IMFatalException("Cannot read resource: " + filePath);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.throwing((Throwable)e);
            }
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                logger.throwing((Throwable)e);
            }
        }
        return txt.toString();
    }

    public static void deleteDirectory(Class<?> t, IInstallProgressMonitor ipm, File targetDir) {
        if (targetDir != null && targetDir.exists()) {
            File[] listFiles = targetDir.listFiles();
            if (listFiles != null) {
                for (File file : listFiles) {
                    if (file.isDirectory()) {
                        FileUtil.deleteDirectory(t, ipm, file);
                    }
                    logger.trace("[" + t.getName() + "] Deleting =>" + file.getName());
                    if (ipm != null) {
                        ipm.setDeletingFileName(file.getName());
                    }
                    file.delete();
                }
            }
            targetDir.delete();
        }
    }

    public static void writeFileFromInputStream(InputStream is, File to) throws IOException {
        logger.trace("write file from input stream to : " + to);
        if (is == null) {
            return;
        }
        if (!to.exists()) {
            if (to.createNewFile()) {
                logger.trace("Success to create " + to + ".");
            } else {
                logger.error("Fail to create " + to + ".");
            }
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(to);
            int readSize = 0;
            byte[] buf = new byte[65536];
            while ((readSize = is.read(buf, 0, 65536)) != -1) {
                os.write(buf, 0, readSize);
            }
        }
        catch (FileNotFoundException e) {
            logger.error("Cannot find file " + to);
            throw new IMFatalException(ErrorController.ErrorCode.CANNOT_ACCESS_FILE);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.throwing((Throwable)e);
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                logger.throwing((Throwable)e);
            }
        }
    }
}

