/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.cli;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.tizen.installer.cli.CLIInstaller;
import org.tizen.installer.cli.CLIOptions;
import org.tizen.installer.cli.CLIUtil;
import org.tizen.installer.cli.Initializer;
import org.tizen.installer.core.Config;
import org.tizen.installer.core.InstallController;
import org.tizen.installer.exception.ErrorController;
import org.tizen.installer.exception.IMFatalException;
import org.tizen.installer.model.PrerequisitesInfo;
import org.tizen.installer.util.Log;
import org.tizen.installer.util.PathUtil;
import org.tizen.installer.util.PlatformUtil;
import org.tizen.installer.util.PrerequisiteUtil;

public class CLIMain {
    private static Logger logger = null;
    private static CLIOptions options = new CLIOptions();
    private static boolean result = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        Config config = null;
        try {
            config = new Config();
            Log.open(config);
            Log.LogTitle("Installer CLI mode start");
            Log.LogInfo("\n" + PlatformUtil.getPlatformInfo());
            Log.LogInfo("Directory of running Installer : " + PathUtil.getCurrentDir());
            logger = Log.getLogger(CLIMain.class);
            logger.trace(" ** Initializing start.");
            logger.info("Load options....");
            result = Initializer.loadCmdArgs(args, options);
            if (!result) {
                logger.error(ErrorController.getErrorMessage());
                System.out.println(ErrorController.getErrorMessage());
            }
            logger.trace(" ** Initializing End.");
            logger.info("Print options has value");
            List<CLIOptions.OPTIONS_HAS_VALUE> optionsHasValueList = options.getOptionsHasValueList();
            for (CLIOptions.OPTIONS_HAS_VALUE oPTIONS_HAS_VALUE : optionsHasValueList) {
                logger.trace(" * " + oPTIONS_HAS_VALUE.name() + " : " + (oPTIONS_HAS_VALUE.name().toLowerCase().contains("pass") ? "*****" : oPTIONS_HAS_VALUE.getValue()));
            }
            logger.info("Print options has no value");
            List<CLIOptions.OPTIONS_BOOLEAN> optionsBooleanList = options.getOptionsBooleanList();
            for (CLIOptions.OPTIONS_BOOLEAN ob : optionsBooleanList) {
                logger.trace(" * " + ob.name() + " : " + ob.getValue());
            }
            logger.info("Execute Commands....");
            logger.info("");
            switch (options.getRuncommand()) {
                case RUN_INSTALL: {
                    logger.trace("*** Case run : " + (Object)((Object)options.getRuncommand()));
                    CLIMain.executeInstall(config);
                    break;
                }
                case RUN_HELP: 
                case RUN_HELP_SHORT: {
                    logger.trace("*** Case run : " + (Object)((Object)options.getRuncommand()));
                    CLIUtil.displayHelp();
                    break;
                }
                case RUN_VIEW_LICENSE: {
                    logger.trace("*** Case run : " + (Object)((Object)options.getRuncommand()));
                    CLIUtil.displaySoftwareLicenseAgreement();
                    break;
                }
                default: {
                    logger.trace("*** Case run : " + (Object)((Object)options.getRuncommand()));
                }
            }
            logger.info("");
            logger.trace("Installation result : " + ErrorController.checkInstallationSuccess());
            logger.trace("Thank you for using Installer");
            if (options.getRuncommand().equals((Object)CLIOptions.RUN_COMMAND.RUN_INSTALL)) {
                System.out.println("Thank you for using Installer");
            }
            if (!PlatformUtil.isWindows()) return;
            if (options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.AUTOMATIC_INSTALLATION)) return;
            System.out.print("Press enter to exit...");
            Scanner scanner = new Scanner(System.in);
            try {
                scanner.nextLine();
                scanner.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
            finally {
                scanner.close();
            }
        }
        catch (IMFatalException e) {
            System.out.println("Fail to load config file.");
            ErrorController.setExitCode(6);
            return;
        }
        finally {
            int exitCode = ErrorController.getExitCode();
            logger.info("exit code : " + exitCode);
            System.exit(exitCode);
        }
    }

    private static void executeInstall(Config config) {
        int errCode = 0;
        InstallController installerConroller = null;
        try {
            installerConroller = new InstallController(true, config, options);
            ErrorController.setInstallationSuccess(true);
        }
        catch (IMFatalException e) {
            logger.error(CLIMain.class.getName() + " => " + e.getMessage());
            System.out.println("* Error : " + e.getMessage());
            ErrorController.setInstallationSuccess(false);
        }
        catch (Exception e) {
            logger.error(CLIMain.class.getName() + " => " + e.getMessage());
            System.out.println("* Error : " + e.getMessage());
            ErrorController.setInstallationSuccess(false);
        }
        logger.trace("Initializing finished.");
        if (ErrorController.checkInstallationSuccess()) {
            ArrayList<PrerequisitesInfo> parsePrerequisties;
            Map<String, List<String>> checkPrerequisities;
            if (PlatformUtil.isLinux() && PlatformUtil.isLinux() && installerConroller.getInstalledFile() != null && (checkPrerequisities = PrerequisiteUtil.checkPrerequisities(parsePrerequisties = PrerequisiteUtil.parsePrerequisties(installerConroller.getInstalledFile()))) != null && checkPrerequisities.size() > 0) {
                String msg = "Required prerequisite packages are not installed.\nPlease install the packages using following command(s).\n";
                logger.trace("\tUnder libraries are not installed");
                logger.trace("\t##############################################");
                Set<String> keySet = checkPrerequisities.keySet();
                Iterator<String> iterator = keySet.iterator();
                while (iterator.hasNext()) {
                    String key;
                    String pkgName = key = iterator.next();
                    if (key.endsWith("*")) {
                        pkgName = key.substring(0, key.lastIndexOf("*"));
                    }
                    String msgValue = "sudo apt-get install " + pkgName;
                    msg = msg + msgValue + "\n";
                    logger.trace("\t" + msgValue);
                }
                logger.trace("\t##############################################");
                System.out.println(msg);
                errCode = 7;
            }
            if (errCode == 0) {
                try {
                    CLIInstaller cli = new CLIInstaller(installerConroller, options);
                    cli.install();
                }
                catch (Exception e) {
                    logger.error(CLIMain.class.getName() + " => " + e.getMessage());
                    System.out.println("* Error : " + e.getMessage());
                    errCode = 7;
                }
            }
        } else {
            logger.error("Initializing failed.");
            errCode = 7;
        }
        ErrorController.setExitCode(errCode);
    }
}

