/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.logging.log4j.Logger;
import org.tizen.installer.cli.CLIOptions;
import org.tizen.installer.exception.ErrorController;
import org.tizen.installer.util.Log;

public class Initializer {
    private static final Logger logger = Log.getLogger(Initializer.class);

    public static boolean loadCmdArgs(String[] args, CLIOptions options) {
        boolean result = true;
        Iterator<String> iter = Arrays.asList(args).iterator();
        ArrayList<CLIOptions.OPTIONS_HAS_VALUE> optionsHasValueList = new ArrayList<CLIOptions.OPTIONS_HAS_VALUE>();
        ArrayList<CLIOptions.OPTIONS_BOOLEAN> optionsBooleanList = new ArrayList<CLIOptions.OPTIONS_BOOLEAN>();
        while (iter.hasNext()) {
            CLIOptions.OPTIONS_BOOLEAN[] obValues;
            CLIOptions.OPTIONS_HAS_VALUE[] ohvValues;
            String arg = iter.next();
            arg = arg.trim();
            logger.trace("Current argument : " + arg);
            CLIOptions.RUN_COMMAND[] values = CLIOptions.RUN_COMMAND.values();
            boolean loopBreak = false;
            for (CLIOptions.RUN_COMMAND command : values) {
                if (!arg.equals(command.command())) continue;
                options.setRuncommand(command);
                logger.trace("Set run command is  : " + (Object)((Object)command));
                loopBreak = true;
                break;
            }
            if (loopBreak) continue;
            for (CLIOptions.OPTIONS_HAS_VALUE ohv : ohvValues = CLIOptions.OPTIONS_HAS_VALUE.values()) {
                if (!arg.equals(ohv.command())) continue;
                if (!iter.hasNext()) {
                    logger.error("Value is not described. ===> " + arg);
                    ErrorController.setErrorMessage("* Value is not described. ===> " + arg);
                    result = false;
                    return false;
                }
                String value = iter.next();
                value = value.trim();
                ohv.setValue(value);
                logger.trace("Set options[" + arg + "] to " + (arg.toLowerCase().contains("pass") ? "****" : value));
                optionsHasValueList.add(ohv);
                loopBreak = true;
                break;
            }
            if (loopBreak) continue;
            for (CLIOptions.OPTIONS_BOOLEAN ob : obValues = CLIOptions.OPTIONS_BOOLEAN.values()) {
                if (!arg.equals(ob.command())) continue;
                ob.setValue(true);
                logger.trace("Set options[" + arg + "] to true");
                optionsBooleanList.add(ob);
                loopBreak = true;
                break;
            }
            if (loopBreak) continue;
            if (!arg.startsWith("-")) {
                options.setPathOption(arg);
                continue;
            }
            System.out.println("Invalid options : " + arg);
            options.setRuncommand(CLIOptions.RUN_COMMAND.RUN_HELP);
        }
        if (options.getRuncommand() == null) {
            logger.trace("There is no command.");
            logger.trace("Set run command to " + (Object)((Object)CLIOptions.RUN_COMMAND.RUN_INSTALL));
            options.setRuncommand(CLIOptions.RUN_COMMAND.RUN_INSTALL);
        }
        options.setOptionsHasValueList(optionsHasValueList);
        options.setOptionsBooleanList(optionsBooleanList);
        return result;
    }
}

