/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.Logger;
import org.tizen.installer.cli.CLIOptions;
import org.tizen.installer.common.ISDKInstallerConstants;
import org.tizen.installer.core.Config;
import org.tizen.installer.core.ZipMultiLibrary;
import org.tizen.installer.exception.ErrorController;
import org.tizen.installer.exception.IMFatalException;
import org.tizen.installer.model.SDKImageInfo;
import org.tizen.installer.ui.wizard.UiInitializeUtil;
import org.tizen.installer.util.Log;
import org.tizen.installer.util.PathUtil;
import org.tizen.installer.util.PlatformUtil;

public class InstallController {
    private static final Logger logger = Log.getLogger(InstallController.class);
    private boolean isCli = false;
    private SDKImageInfo sdkImageInfo;
    private ZipMultiLibrary zipLibrary;
    private Config config;
    private CLIOptions options;
    private long initializeTime = 0L;
    private String version = "";
    private ExecutorService extractThread = Executors.newFixedThreadPool(4);
    private String INSTALLED_PACKAGE_LIST;
    private File installedFile = null;
    private String customTitle = "Tizen Studio";
    private boolean isCustomTitle = false;
    private boolean isMBCSCheck = false;
    private boolean existPostinstallPackage = false;

    public InstallController(boolean isCli, Config config, CLIOptions options) throws IMFatalException {
        logger.trace(this.getClass().getName() + " constructor start.");
        this.isCli = isCli;
        this.config = config;
        this.options = options;
        long startTime = System.currentTimeMillis();
        this.init();
        long endTime = System.currentTimeMillis();
        this.initializeTime = endTime - startTime;
        logger.trace("Total initialize Time : " + this.initializeTime);
        logger.trace(this.getClass().getName() + " constructor end.");
    }

    public SDKImageInfo getSdkImageInfo() {
        return this.sdkImageInfo;
    }

    public ZipMultiLibrary getZipLibrary() {
        return this.zipLibrary;
    }

    public Config getConfig() {
        return this.config;
    }

    public long getInitializeTime() {
        return this.initializeTime;
    }

    public ExecutorService getExtractThread() {
        return this.extractThread;
    }

    public void shutdownExtractThread() {
        while (!this.extractThread.isShutdown() || !this.extractThread.isTerminated()) {
            this.extractThread.shutdown();
            this.extractThread.shutdownNow();
        }
    }

    public long getTotalUnzipTime() {
        return this.zipLibrary.getTotalUnzipTime();
    }

    public CLIOptions getOption() {
        return this.options;
    }

    private void init() throws IMFatalException {
        if (!this.options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.NO_JAVA_CHECK)) {
            this.checkInstalledJava();
        }
        if (PlatformUtil.isLinux()) {
            try {
                this.extractInstalledPackageListFile();
            }
            catch (IMFatalException iMFatalException) {
                // empty catch block
            }
        }
        if (this.options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.MBCS_CHECK)) {
            this.isMBCSCheck = true;
        }
        this.initZipLibrary(this.config.getConfigValue(Config.ConfigOptions.TARGET_IMAGE_FILE_NAME));
        this.initSDKImageInfo();
        this.checkAndSetDirectory();
        this.checkDiskSpace();
        this.loadVersion();
        this.loadCustomTitle();
    }

    private void extractInstalledPackageListFile() throws IMFatalException {
        block7: {
            ZipMultiLibrary zml = null;
            try {
                String fileName = this.config.getConfigValue(Config.ConfigOptions.TARGET_IMAGE_FILE_NAME);
                File zipfile = new File(fileName);
                this.INSTALLED_PACKAGE_LIST = ".info" + File.separator + "installedpackage.list";
                zml = new ZipMultiLibrary(fileName);
                ArrayList<String> fileNames = new ArrayList<String>();
                fileNames.add(".info" + File.separator + "installedpackage.list");
                zml.unzipSelectedList(zipfile.getParent(), fileNames);
                File parentFile = zipfile.getParentFile();
                if (parentFile != null) {
                    this.installedFile = new File(parentFile.getAbsolutePath(), this.INSTALLED_PACKAGE_LIST);
                    break block7;
                }
                this.installedFile = null;
                throw new IMFatalException("Fail to extract");
            }
            catch (Exception e) {
                throw new IMFatalException("Fail to extract");
            }
            finally {
                if (zml != null) {
                    zml.close();
                }
            }
        }
    }

    public File getInstalledFile() {
        return this.installedFile;
    }

    public boolean isMBCSCheck() {
        return this.isMBCSCheck;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isExistPostinstallPackage() {
        return this.existPostinstallPackage;
    }

    private void loadVersion() {
        File readFile = new File("VERSION");
        if (readFile != null && readFile.exists()) {
            this.version = this.loadVersionFromFile(readFile);
        } else {
            logger.trace("Sorry. There is no version file. set default version.");
            this.version = "0.0.1";
        }
    }

    private void loadCustomTitle() {
        String loadCustomTitleFromFile;
        File readFile = new File("TITLE");
        if (readFile != null && readFile.exists() && (loadCustomTitleFromFile = this.loadCustomTitleFromFile(readFile)) != null && !loadCustomTitleFromFile.isEmpty()) {
            this.customTitle = loadCustomTitleFromFile;
            this.isCustomTitle = true;
        }
    }

    public String getCustomTitle() {
        return this.customTitle;
    }

    public boolean isCustomTitle() {
        return this.isCustomTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadVersionFromFile(File readFile) {
        String sb = "";
        String read = "";
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(readFile));
            while ((read = bufferedReader.readLine()) != null) {
                if (!read.startsWith("Version:")) continue;
                sb = read.replace("Version:", "").trim();
                break;
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadCustomTitleFromFile(File readFile) {
        String sb = "";
        String read = "";
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(readFile));
            while ((read = bufferedReader.readLine()) != null) {
                if (!read.startsWith("INSTALLER_TITLE=")) continue;
                sb = read.replace("INSTALLER_TITLE=", "").trim().replace("\"", "");
                break;
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
        }
        return sb;
    }

    private void checkDiskSpace() throws IMFatalException {
        logger.trace("checkDiskSpace start");
        long availableSpaceSize = PathUtil.getAvailableSpaceSize(this.config.getInstallDirectory());
        if (availableSpaceSize <= this.sdkImageInfo.getInstallSizeInLong()) {
            logger.error(String.format("\tRequired disk space : %d, Remain disk space : %d", this.sdkImageInfo.getInstallSizeInLong(), availableSpaceSize));
            this.config.setAvaliableInstallDirectory(false);
        } else {
            logger.trace("\tDisk space is enough.");
            logger.trace(String.format("\tRequired disk space : %d, Remain disk space : %d", this.sdkImageInfo.getInstallSizeInLong(), availableSpaceSize));
        }
        logger.trace("checkDiskSpace end");
    }

    private void checkAndSetDirectory() {
        logger.trace("checkAndSetDirectory start");
        String installDirectory = null;
        String dataDirectory = null;
        installDirectory = PathUtil.getDefaultInstallDirectory(this.options.getPathOption(), this.config);
        dataDirectory = PathUtil.getDataDirectory(new File(installDirectory));
        if (PlatformUtil.isLinux() || PlatformUtil.isMacOS()) {
            String property;
            if (installDirectory.startsWith("~")) {
                String replace = installDirectory.replace("~", "");
                if (replace.startsWith("/")) {
                    replace = replace.replaceFirst("/", "");
                }
                installDirectory = PathUtil.getFromHome(replace);
            }
            if (!installDirectory.startsWith(property = System.getProperty("user.home"))) {
                logger.trace("\tInstall target is not valid. => " + installDirectory);
                ErrorController.setErrorMessage("Invalid the destination directory  => " + installDirectory);
                this.config.setAvaliableInstallDirectory(false);
                if (this.isCli && this.options.getPathOption() != null) {
                    throw new IMFatalException("Invalid the destination directory  => " + installDirectory);
                }
            }
        }
        logger.trace("Verify install directory start");
        File checkInstallDirectoryFile = new File(installDirectory);
        logger.trace("\tInstall target is valid. => " + installDirectory);
        if (checkInstallDirectoryFile.exists() && checkInstallDirectoryFile.isDirectory()) {
            if (PathUtil.isAvaliableInstallDirectory(checkInstallDirectoryFile, installDirectory, this) != PathUtil.AvaliableDirectory.NO_ERROR) {
                logger.trace("\tInstall target is not valid. => " + installDirectory);
                this.config.setAvaliableInstallDirectory(false);
                if (this.isCli && this.options.getPathOption() != null) {
                    throw new IMFatalException("Invalid the destination directory  => " + installDirectory);
                }
            }
        } else if (checkInstallDirectoryFile.mkdirs()) {
            if (PathUtil.isAvaliableInstallDirectory(checkInstallDirectoryFile, installDirectory, this) != PathUtil.AvaliableDirectory.NO_ERROR) {
                logger.trace("\tInstall target is not valid. => " + installDirectory);
                this.config.setAvaliableInstallDirectory(false);
                if (this.isCli && this.options.getPathOption() != null) {
                    throw new IMFatalException("Invalid the destination directory  => " + installDirectory);
                }
            }
            checkInstallDirectoryFile.delete();
        } else {
            logger.trace("\tInstall target is not valid. => " + installDirectory);
            this.config.setAvaliableInstallDirectory(false);
            if (this.isCli && this.options.getPathOption() != null) {
                throw new IMFatalException("Invalid the destination directory  => " + installDirectory);
            }
        }
        logger.trace("Verify install directory end");
        this.config.setInstallDirectory(installDirectory);
        this.config.setDataLocation(dataDirectory);
        logger.trace("\tSDK installation directory : " + installDirectory);
        logger.trace("\tSDK data directory : " + dataDirectory);
        logger.trace("checkAndSetDirectory end");
    }

    private void initZipLibrary(String fileName) throws IMFatalException {
        logger.trace("init zip library start.");
        try {
            this.zipLibrary = new ZipMultiLibrary(fileName);
        }
        catch (Exception e) {
            logger.error("initZipLibrary => " + e.getMessage());
            ErrorController.setInstallationSuccess(false);
            ErrorController.setErrorMessage(e.getMessage());
            throw new IMFatalException(e.getMessage());
        }
        logger.trace("init zip library end.");
    }

    private void initSDKImageInfo() {
        this.sdkImageInfo = new SDKImageInfo();
        this.initInstallSize();
    }

    private void checkInstalledJava() {
        logger.trace("checkPrerequisites() start");
        boolean checkingJava = this.checkingJava(this.isCli);
        logger.trace("Return from checkingJava() => " + checkingJava);
        if (!checkingJava) {
            ErrorController.setInstallationSuccess(checkingJava);
            ErrorController.setError(ErrorController.ErrorCode.UNSUPPORTED_JAVA);
            logger.trace("checkPrerequisites() end with error => " + ErrorController.getErrorMessage());
            throw new IMFatalException(ErrorController.getErrorMessage());
        }
        logger.trace("checkPrerequisites() end");
    }

    private boolean checkingJava(boolean isCli) {
        logger.trace("Checking java");
        boolean result = false;
        String correctJavaSystemPath = PlatformUtil.isCorrectJavaSystemPath(logger);
        if (!correctJavaSystemPath.isEmpty()) {
            if (isCli) {
                System.out.print(correctJavaSystemPath);
                result = false;
            } else {
                result = UiInitializeUtil.displayJavaPathIncorrectWarningMsgBox(correctJavaSystemPath + "\nDo you want to continue?", logger);
            }
            if (!result) {
                return result;
            }
        }
        if (PlatformUtil.isInstalledOpenJDK()) {
            logger.trace("OpenJDK is installed.");
            if (PlatformUtil.isAvailOpenJDK()) {
                logger.trace("OpenJDK available.");
                result = true;
            } else {
                logger.trace("Do not using OpenJDK.");
                if (!isCli) {
                    result = UiInitializeUtil.displayOpenJDKWarningMsgBox(logger);
                } else {
                    System.out.print("OpenJDK is installed.\nThe Installer and Tizen Studio do not support the OpenJDK on current OS version.\n\nYou must install the Oracle JDK 8 or later.\nPlease go to 'http://www.oracle.com/technetwork/java/javase/downloads' and download a JDK.\n");
                    result = false;
                }
            }
        } else {
            logger.trace("Current java is working java - not open jdk");
            result = true;
        }
        if (!result) {
            return result;
        }
        if (PlatformUtil.isUnderJava8(logger)) {
            logger.trace("Installed java version is under 1.8.");
            if (!isCli) {
                result = UiInitializeUtil.displayJavaVersionWarningMsgBox(logger);
            } else {
                System.out.println("Java Development Kit (JDK) is not installed on your computer, or the environment variables related to it are incorrect.\n\nTo use the Tizen Studio, you need to install the JDK 8 or later.\nPlease go to 'http://www.oracle.com/technetwork/java/javase/downloads' and download a JDK.\n");
                result = false;
            }
        } else {
            logger.trace("Current java is working java version - not java 1.8");
            result = true;
        }
        return result;
    }

    private void initInstallSize() {
        long totalUnzipSize = this.zipLibrary.getTotalUnzipSize();
        this.sdkImageInfo.setInstallSizeInLong(totalUnzipSize);
        float installSize = 0.0f;
        try {
            if (totalUnzipSize >= 0x40000000L) {
                installSize = (float)totalUnzipSize / 1.0737418E9f;
                this.sdkImageInfo.setInstallSize(String.format("%.2f GB", Float.valueOf(installSize)));
            } else if (totalUnzipSize < 0x40000000L && totalUnzipSize > 0x100000L) {
                installSize = (float)totalUnzipSize / 1048576.0f;
                this.sdkImageInfo.setInstallSize(String.format("%.2f MB", Float.valueOf(installSize)));
            } else {
                installSize = totalUnzipSize;
                this.sdkImageInfo.setInstallSize(String.format("%.2f Bytes", Float.valueOf(installSize)));
            }
        }
        catch (Exception e) {
            logger.throwing((Throwable)e);
            throw new IMFatalException(ErrorController.ErrorCode.INVALID_INSTALL_SIZE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeSdkInfoFile() {
        File sdkInfo = new File(this.config.getInstallDirectory(), this.config.getConfigValue(Config.ConfigOptions.SDK_INFO_FILE_NAME));
        if (sdkInfo.exists()) {
            sdkInfo.delete();
        }
        BufferedWriter fw = null;
        FileOutputStream fos = null;
        OutputStreamWriter osr = null;
        try {
            fos = new FileOutputStream(sdkInfo);
            if (this.isMBCSCheck) {
                osr = new OutputStreamWriter(fos);
                fw = new BufferedWriter(osr);
            } else {
                osr = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                fw = new BufferedWriter(osr);
            }
            fw.write(String.format("%s=%s", this.config.getConfigValue(Config.ConfigOptions.SDK_INFO_LABEL_INSTALLED_PATH), this.config.getInstallDirectory()));
            fw.write(ISDKInstallerConstants.NEW_LINE);
            fw.write(String.format("%s=%s", this.config.getConfigValue(Config.ConfigOptions.SDK_INFO_LABEL_DATA_PATH), this.config.getDataLocation()));
            fw.write(ISDKInstallerConstants.NEW_LINE);
        }
        catch (IOException e) {
            logger.throwing((Throwable)e);
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
                if (osr != null) {
                    osr.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                logger.throwing((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAndSavePostInstallPackages() {
        block38: {
            HashSet<String> postInstallPackageSet = new HashSet<String>();
            HashSet<String> installedPackageSet = new HashSet<String>();
            HashSet<String> returnSet = new HashSet<String>();
            String fileName = PathUtil.get(this.getConfig().getInstallDirectory(), ".info", "installedpackage.list");
            File installedpkg = new File(fileName);
            if (installedpkg.exists()) {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(new FileInputStream(installedpkg)));
                    String read = "";
                    while ((read = reader.readLine()) != null) {
                        if (read.contains("C-postinstall:") || read.contains("C-postinstall :")) {
                            String[] packageArray = (read = read.replace("C-postinstall:", "").replace("C-postinstall :", "").trim()).split(",");
                            if (packageArray == null || packageArray.length <= 0) continue;
                            for (String data : packageArray) {
                                String supportTarget;
                                data = data.replace("(", " ").replace(")", "").trim();
                                String[] splitData = data.split(" ");
                                String packageName = splitData[0];
                                String string = supportTarget = splitData.length > 1 ? splitData[1] : null;
                                if (supportTarget == null || supportTarget.toLowerCase().equals("all")) {
                                    postInstallPackageSet.add(packageName);
                                    continue;
                                }
                                if (this.isCli && supportTarget.toLowerCase().equals("cli")) {
                                    postInstallPackageSet.add(packageName);
                                    continue;
                                }
                                if (this.isCli || !supportTarget.toLowerCase().equals("ui")) continue;
                                postInstallPackageSet.add(packageName);
                            }
                            continue;
                        }
                        if (!read.contains("Package: ") && !read.contains("Package : ")) continue;
                        read = read.replace("Package: ", "").replace("Package : ", "").trim();
                        installedPackageSet.add(read);
                    }
                    for (String postPkgName : postInstallPackageSet) {
                        if (!installedPackageSet.contains(postPkgName)) continue;
                        postInstallPackageSet.remove(postPkgName);
                    }
                    for (String postPkgName : postInstallPackageSet) {
                        if (postPkgName == null || postPkgName.isEmpty()) continue;
                        returnSet.add(postPkgName);
                    }
                    if (returnSet.size() <= 0) break block38;
                    File postinstallFile = new File(PathUtil.get(this.getConfig().getInstallDirectory(), ".info", "postinstallpkg.list"));
                    if (postinstallFile.exists()) {
                        postinstallFile.delete();
                    }
                    this.existPostinstallPackage = true;
                    BufferedWriter fw = null;
                    OutputStreamWriter osw = null;
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(postinstallFile);
                        if (this.isMBCSCheck) {
                            osw = new OutputStreamWriter(fos);
                            fw = new BufferedWriter(osw);
                        } else {
                            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                            fw = new BufferedWriter(osw);
                        }
                        Iterator iterator = returnSet.iterator();
                        fw.write((String)iterator.next());
                        while (iterator.hasNext()) {
                            fw.write(",");
                            fw.write((String)iterator.next());
                        }
                        fw.write(ISDKInstallerConstants.NEW_LINE);
                    }
                    catch (IOException e) {
                        logger.throwing((Throwable)e);
                    }
                    catch (Exception e) {
                        logger.throwing((Throwable)e);
                    }
                    finally {
                        if (fw != null) {
                            fw.close();
                        }
                        if (osw != null) {
                            osw.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    logger.throwing((Throwable)e);
                }
                catch (IOException e) {
                    logger.throwing((Throwable)e);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            logger.throwing((Throwable)e);
                        }
                    }
                }
            }
        }
    }
}

