/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.Logger;
import org.tizen.installer.common.IInstallProgressMonitor;
import org.tizen.installer.exception.ErrorController;
import org.tizen.installer.exception.IMFatalException;
import org.tizen.installer.util.FileUtil;
import org.tizen.installer.util.Log;
import org.tizen.installer.util.PlatformUtil;

public class ZipMultiLibrary {
    private int totalCount = 0;
    private long totalUnzipSize = 0L;
    private ZipFile zipFile;
    private File file;
    private long totalUnzipTime = 0L;
    private static final int BUF_SIZE = 65536;
    private String totalSizeStr = "";
    private float workingPercent = 0.0f;
    private float workingSize = 0.0f;
    private static final Logger logger = Log.getLogger(ZipMultiLibrary.class);

    public ZipMultiLibrary(String fileName) throws IMFatalException {
        this.file = new File(fileName);
        try {
            this.zipFile = new ZipFile(this.file);
        }
        catch (IOException e) {
            logger.throwing((Throwable)e);
            throw new IMFatalException(ErrorController.ErrorCode.CANNOT_ACCESS_FILE);
        }
        Enumeration entries = this.zipFile.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry nextElement = (ZipArchiveEntry)entries.nextElement();
            this.totalUnzipSize += nextElement.getSize();
            ++this.totalCount;
        }
        logger.trace("ZipLibrary load completed");
    }

    public long unzipSelectedList(String targetDirectory, List<String> fileNames) throws IMFatalException {
        long size = 0L;
        File targetDir = new File(targetDirectory);
        if (!targetDir.exists()) {
            targetDir.mkdirs();
            logger.trace("Create target directory => " + targetDir.getAbsolutePath());
        }
        if (fileNames != null && !fileNames.isEmpty()) {
            for (String name : fileNames) {
                ZipArchiveEntry entry;
                if (name.startsWith("/")) {
                    name = name.replaceFirst("/", "");
                }
                if ((entry = this.zipFile.getEntry(name)) != null) {
                    try {
                        this.writeZipEntryToFile(targetDir, entry);
                        size = entry.getSize();
                        continue;
                    }
                    catch (Exception e) {
                        logger.throwing((Throwable)e);
                        throw new IMFatalException(ErrorController.ErrorCode.CANNOT_UNZIP_FILE.getErrorMessage() + " : " + name);
                    }
                }
                logger.error("Can not found file in image file => " + name);
                throw new IMFatalException(ErrorController.ErrorCode.CANNOT_UNZIP_FILE.getErrorMessage() + " : " + name);
            }
        }
        return size;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public long getTotalUnzipSize() {
        return this.totalUnzipSize;
    }

    public long getTotalUnzipTime() {
        return this.totalUnzipTime;
    }

    public void close() {
        ZipFile.closeQuietly((ZipFile)this.zipFile);
    }

    public void unzip(String targetDirectory, final IInstallProgressMonitor installProgressMonitor, ExecutorService extractThread) throws Exception {
        Object workingSizeValue;
        final File targetDir = new File(targetDirectory);
        logger.trace("Cleaning target Directory - start");
        installProgressMonitor.initialize("Preparing installation...");
        if (targetDir.exists() && targetDir.isDirectory()) {
            FileUtil.deleteDirectory(this.getClass(), installProgressMonitor, targetDir);
        }
        logger.trace("Cleaning target Directory - finished");
        targetDir.mkdirs();
        float temptotalSize = 0.0f;
        if (this.totalUnzipSize >= 0x40000000L) {
            temptotalSize = (float)this.totalUnzipSize / 1.0737418E9f;
            this.totalSizeStr = String.format("%.2f GB", Float.valueOf(temptotalSize));
        } else if (this.totalUnzipSize < 0x40000000L && this.totalUnzipSize > 0x100000L) {
            temptotalSize = (float)this.totalUnzipSize / 1048576.0f;
            this.totalSizeStr = String.format("%.2f MB", Float.valueOf(temptotalSize));
        } else {
            this.totalSizeStr = String.format("%d Bytes", this.totalUnzipSize);
        }
        long startTime = System.currentTimeMillis();
        Enumeration apZipEntries = this.zipFile.getEntries();
        int workingCount = 0;
        ArrayList submitList = new ArrayList();
        while (apZipEntries.hasMoreElements()) {
            while (installProgressMonitor.getIsPaused()) {
                try {
                    logger.trace("Paused by user.");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.throwing((Throwable)e);
                }
            }
            if (installProgressMonitor.isCanceled()) {
                logger.trace("Installation canceled by user");
                break;
            }
            final ZipArchiveEntry zaEntry = (ZipArchiveEntry)apZipEntries.nextElement();
            logger.trace(String.format("[%s] - [%s]", ++workingCount, zaEntry.getName()));
            if (!zaEntry.isDirectory()) {
                if (zaEntry.isUnixSymlink()) {
                    String unixSymlink = this.zipFile.getUnixSymlink(zaEntry);
                    if (unixSymlink != null && !unixSymlink.isEmpty()) {
                        File outputFile = new File(targetDir, zaEntry.getName());
                        File file = outputFile.getParentFile();
                        if (file == null) continue;
                        file.mkdirs();
                        if (outputFile.exists()) {
                            outputFile.delete();
                        }
                        if (!PlatformUtil.isWindows()) {
                            String linkName = outputFile.getName();
                            String target = unixSymlink;
                            String command = "ln -s " + target + " " + linkName;
                            String[] commands = new String[]{"/bin/sh", "-c", command};
                            ProcessBuilder pb = new ProcessBuilder(commands);
                            pb.directory(file);
                            pb.start();
                            this.workingSize += (float)zaEntry.getSize();
                            this.workingPercent = this.workingSize / (float)this.totalUnzipSize * 100.0f;
                            String workingSizeValue2 = this.getWorkingSizeValue(this.totalSizeStr, this.workingSize);
                            installProgressMonitor.workedInstall((int)this.workingPercent + "%", workingSizeValue2, zaEntry.getName());
                            continue;
                        }
                        Future<?> submit = extractThread.submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    while (installProgressMonitor.getIsPaused()) {
                                        try {
                                            logger.trace("Paused by user.");
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException e) {
                                            logger.throwing((Throwable)e);
                                        }
                                    }
                                    if (installProgressMonitor.isCanceled()) {
                                        logger.trace("Installation canceled by user");
                                    } else {
                                        ZipMultiLibrary.this.writeZipEntryToFile(targetDir, zaEntry);
                                        ZipMultiLibrary.this.workingSize = ZipMultiLibrary.this.workingSize + (float)zaEntry.getSize();
                                        ZipMultiLibrary.this.workingPercent = ZipMultiLibrary.this.workingSize / (float)ZipMultiLibrary.this.totalUnzipSize * 100.0f;
                                        String workingSizeValue = ZipMultiLibrary.this.getWorkingSizeValue(ZipMultiLibrary.this.totalSizeStr, ZipMultiLibrary.this.workingSize);
                                        installProgressMonitor.workedInstall((int)ZipMultiLibrary.this.workingPercent + "%", workingSizeValue, zaEntry.getName());
                                    }
                                }
                                catch (Exception e) {
                                    logger.throwing((Throwable)e);
                                }
                            }
                        });
                        submitList.add(submit);
                        continue;
                    }
                    Future<?> submit = extractThread.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                while (installProgressMonitor.getIsPaused()) {
                                    try {
                                        logger.trace("Paused by user.");
                                        Thread.sleep(1000L);
                                    }
                                    catch (InterruptedException e) {
                                        logger.throwing((Throwable)e);
                                    }
                                }
                                if (installProgressMonitor.isCanceled()) {
                                    logger.trace("Installation canceled by user");
                                } else {
                                    ZipMultiLibrary.this.writeZipEntryToFile(targetDir, zaEntry);
                                    ZipMultiLibrary.this.workingSize = ZipMultiLibrary.this.workingSize + (float)zaEntry.getSize();
                                    ZipMultiLibrary.this.workingPercent = ZipMultiLibrary.this.workingSize / (float)ZipMultiLibrary.this.totalUnzipSize * 100.0f;
                                    String workingSizeValue = ZipMultiLibrary.this.getWorkingSizeValue(ZipMultiLibrary.this.totalSizeStr, ZipMultiLibrary.this.workingSize);
                                    installProgressMonitor.workedInstall((int)ZipMultiLibrary.this.workingPercent + "%", workingSizeValue, zaEntry.getName());
                                }
                            }
                            catch (Exception e) {
                                logger.throwing((Throwable)e);
                            }
                        }
                    });
                    submitList.add(submit);
                    continue;
                }
                Future<?> submit = extractThread.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            while (installProgressMonitor.getIsPaused()) {
                                try {
                                    logger.trace("Paused by user.");
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    logger.throwing((Throwable)e);
                                }
                            }
                            if (installProgressMonitor.isCanceled()) {
                                logger.trace("Installation canceled by user");
                            } else {
                                ZipMultiLibrary.this.writeZipEntryToFile(targetDir, zaEntry);
                                ZipMultiLibrary.this.workingSize = ZipMultiLibrary.this.workingSize + (float)zaEntry.getSize();
                                ZipMultiLibrary.this.workingPercent = ZipMultiLibrary.this.workingSize / (float)ZipMultiLibrary.this.totalUnzipSize * 100.0f;
                                String workingSizeValue = ZipMultiLibrary.this.getWorkingSizeValue(ZipMultiLibrary.this.totalSizeStr, ZipMultiLibrary.this.workingSize);
                                installProgressMonitor.workedInstall((int)ZipMultiLibrary.this.workingPercent + "%", workingSizeValue, zaEntry.getName());
                            }
                        }
                        catch (Exception e) {
                            logger.throwing((Throwable)e);
                        }
                    }
                });
                submitList.add(submit);
                continue;
            }
            if (!zaEntry.isDirectory()) continue;
            File entryFile = new File(targetDir.getAbsolutePath() + File.separator + zaEntry.getName());
            if (!entryFile.exists()) {
                entryFile.mkdirs();
            }
            this.workingSize += (float)zaEntry.getSize();
            this.workingPercent = this.workingSize / (float)this.totalUnzipSize * 100.0f;
            workingSizeValue = this.getWorkingSizeValue(this.totalSizeStr, this.workingSize);
            installProgressMonitor.workedInstall((int)this.workingPercent + "%", (String)workingSizeValue, zaEntry.getName());
        }
        long endTime = System.currentTimeMillis();
        this.totalUnzipTime = endTime - startTime;
        logger.trace("Total Unzip Time : " + this.totalUnzipTime);
        for (Future future : submitList) {
            try {
                future.get();
                if (!installProgressMonitor.isCanceled()) continue;
                logger.trace("Installation canceled by user");
                extractThread.shutdown();
                extractThread.shutdownNow();
                break;
            }
            catch (InterruptedException e) {
                throw new Exception(e);
            }
            catch (ExecutionException e) {
                throw new Exception(e);
            }
        }
        workingSizeValue = this.getWorkingSizeValue(this.totalSizeStr, this.totalUnzipSize);
        installProgressMonitor.workedInstall("100%", (String)workingSizeValue, "");
        if (!installProgressMonitor.isCanceled()) {
            installProgressMonitor.done("Installation has been completed!");
        }
        ZipFile.closeQuietly((ZipFile)this.zipFile);
    }

    private String getWorkingSizeValue(String totalSizeStr, float workingSize) {
        String workingSizeValue;
        if (workingSize >= 1.0737418E9f) {
            float temptotalSize = workingSize / 1.0737418E9f;
            workingSizeValue = String.format("%s / %s ", String.format("%.2f GB", Float.valueOf(temptotalSize)), totalSizeStr);
        } else if (workingSize < 1.0737418E9f && workingSize > 1048576.0f) {
            float temptotalSize = workingSize / 1048576.0f;
            workingSizeValue = String.format("%s / %s ", String.format("%.2f MB", Float.valueOf(temptotalSize)), totalSizeStr);
        } else {
            workingSizeValue = String.format("%s / %s ", String.format("%.2f bytes", Float.valueOf(workingSize)), totalSizeStr);
        }
        return workingSizeValue;
    }

    private void writeZipEntryToFile(File targetDir, ZipArchiveEntry zaEntry) throws Exception {
        try {
            this.writeToFile(targetDir, zaEntry);
        }
        catch (Exception e) {
            try {
                this.writeToFileWithStreamBuffer(targetDir, zaEntry);
            }
            catch (Exception e2) {
                logger.throwing((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFileWithStreamBuffer(File targetDir, ZipArchiveEntry zaEntry) throws Exception {
        int retryCount = 0;
        boolean isSucceed = true;
        Exception localException = null;
        do {
            isSucceed = true;
            File outputFile = new File(targetDir, zaEntry.getName());
            File outputParentFile = outputFile.getParentFile();
            if (outputParentFile != null) {
                outputParentFile.mkdirs();
            }
            if (outputFile.exists()) {
                outputFile.delete();
                outputFile.createNewFile();
            }
            InputStream is = null;
            FileOutputStream fos = null;
            int readByte = 0;
            try {
                is = this.zipFile.getInputStream(zaEntry);
                fos = new FileOutputStream(outputFile);
                byte[] buffer = new byte[65536];
                if (is != null) {
                    while ((readByte = is.read(buffer)) != -1) {
                        fos.write(buffer, 0, readByte);
                    }
                }
            }
            catch (Exception e) {
                isSucceed = false;
                localException = e;
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            try {
                String permission;
                int unixMode = zaEntry.getUnixMode();
                if (unixMode == 0 || (permission = String.format("%o", unixMode)) == null) continue;
                permission = permission.substring(permission.length() - 3, permission.length());
                if ((Integer.parseInt(permission = permission.substring(0, 1)) & 5) != 5) continue;
                outputFile.setExecutable(true);
            }
            catch (Exception e) {
                isSucceed = false;
                localException = e;
            }
        } while (!isSucceed && ++retryCount < 3);
        if (!isSucceed) {
            logger.error("Fail to extract file with second way ==> " + zaEntry.getName());
            throw new Exception(localException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(File targetDir, ZipArchiveEntry zaEntry) throws Exception {
        int retryCount = 0;
        boolean isSucceed = true;
        Exception localException = null;
        do {
            isSucceed = true;
            File outputFile = new File(targetDir, zaEntry.getName());
            File outputParentFile = outputFile.getParentFile();
            if (outputParentFile != null) {
                outputParentFile.mkdirs();
            }
            if (outputFile.exists()) {
                outputFile.delete();
                outputFile.createNewFile();
            }
            FileOutputStream outputStream = null;
            InputStream inputStream = null;
            try {
                outputStream = new FileOutputStream(outputFile);
                inputStream = this.zipFile.getInputStream(zaEntry);
                if (inputStream != null) {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                outputStream.flush();
            }
            catch (Exception e) {
                isSucceed = false;
                localException = e;
            }
            finally {
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            try {
                String permission;
                int unixMode = zaEntry.getUnixMode();
                if (unixMode == 0 || (permission = String.format("%o", unixMode)) == null) continue;
                permission = permission.substring(permission.length() - 3, permission.length());
                if ((Integer.parseInt(permission = permission.substring(0, 1)) & 5) != 5) continue;
                outputFile.setExecutable(true);
            }
            catch (Exception e) {
                isSucceed = false;
                localException = e;
            }
        } while (!isSucceed && ++retryCount < 3);
        if (!isSucceed) {
            logger.error("Fail to extract file ==> " + zaEntry.getName());
            throw new Exception(localException);
        }
    }
}

