/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class IMButton
extends Canvas {
    Image displayImage = null;
    Image sourceImage = null;
    Image hoverImage = null;
    boolean selected_flag = false;
    boolean enabled_flag = false;

    public IMButton(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    public void setSize(Rectangle rect) {
        this.setBounds(rect);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }

    public void setImage(String sourceImagePath) {
        this.displayImage = this.sourceImage = new Image((Device)Display.getDefault(), sourceImagePath);
    }

    public void setImage(String sourceImagePath, String hoverImagePath) {
        this.sourceImage = new Image((Device)Display.getDefault(), sourceImagePath);
        this.hoverImage = new Image((Device)Display.getDefault(), hoverImagePath);
        this.displayImage = this.sourceImage;
    }

    public void setImage(Image image) {
        this.displayImage = this.sourceImage = image;
    }

    public void setImage(Image image, Image hover_image) {
        this.sourceImage = image;
        this.hoverImage = hover_image;
        this.displayImage = this.sourceImage;
    }

    public void setSelection(boolean selected) {
        this.selected_flag = selected;
    }

    public boolean getSelection() {
        return this.selected_flag;
    }

    public void setEnabledFlag(boolean enabled) {
        this.enabled_flag = enabled;
    }

    public boolean getEnabledFlag() {
        return this.enabled_flag;
    }

    private void init() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                if (IMButton.this.displayImage != null) {
                    gc.drawImage(IMButton.this.displayImage, 0, 0, IMButton.this.displayImage.getImageData().width, IMButton.this.displayImage.getImageData().height, 0, 0, IMButton.this.displayImage.getImageData().width, IMButton.this.displayImage.getImageData().height);
                }
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                if (IMButton.this.hoverImage != null) {
                    IMButton.this.displayImage = IMButton.this.hoverImage;
                }
                IMButton.this.redraw();
            }

            public void mouseExit(MouseEvent e) {
                IMButton.this.displayImage = IMButton.this.sourceImage;
                IMButton.this.redraw();
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                super.mouseDown(e);
            }

            public void mouseDoubleClick(MouseEvent e) {
                super.mouseDoubleClick(e);
            }
        });
    }

    public void setEnabled(boolean isEnable) {
        super.setEnabled(isEnable);
        this.redraw();
    }
}

