/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.custom;

import java.util.ArrayList;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class CustomImageButton
extends Canvas {
    protected Image displayImage = null;
    protected Image normalImage = null;
    protected Image hoverImage = null;
    protected Image pushImage = null;
    protected Image disabledImage = null;
    protected Image selectImage = null;
    private Image checkedNormalImage = null;
    private Image checkedHoverImage = null;
    private Image checkedDisabledImage = null;
    private Image uncheckedNormalImage = null;
    private Image uncheckedHoverImage = null;
    private Image uncheckedDisabledImage = null;
    boolean isCheckBox = false;
    boolean checkState = false;
    private Enum<ButtonState> state;
    private ArrayList<IClickEventListener> clickListenerList = new ArrayList();
    private ArrayList<IChangeStateEventListener> changeStateListenerList = new ArrayList();

    public CustomImageButton(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.initEventHandler();
    }

    public void setSize(Rectangle rect) {
        this.setBounds(rect);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }

    public void setImage(Image normal_image, Image hover_image, Image push_image, Image disabledImg) {
        this.normalImage = normal_image;
        this.hoverImage = hover_image;
        this.pushImage = push_image;
        this.disabledImage = disabledImg;
        this.displayImage = this.normalImage;
    }

    public void setImage(Image normal_image, Image hover_image, Image push_image, Image select_image, Image disabledImg) {
        this.normalImage = normal_image;
        this.hoverImage = hover_image;
        this.pushImage = push_image;
        this.selectImage = select_image;
        this.disabledImage = disabledImg;
        this.displayImage = this.normalImage;
    }

    public void setToggleButton(Image uncheckedNormal, Image uncheckHover, Image uncheckDisabled, Image checkedNormal, Image checkHover, Image checkDisabled, boolean defaultChecked) {
        this.uncheckedNormalImage = uncheckedNormal;
        this.uncheckedHoverImage = uncheckHover;
        this.uncheckedDisabledImage = uncheckDisabled;
        this.checkedNormalImage = checkedNormal;
        this.checkedHoverImage = checkHover;
        this.checkedDisabledImage = checkDisabled;
        this.checkState = defaultChecked;
        if (this.checkState) {
            this.normalImage = this.checkedNormalImage;
            this.hoverImage = this.checkedHoverImage;
            this.pushImage = this.checkedHoverImage;
            this.disabledImage = this.checkedDisabledImage;
        } else {
            this.normalImage = this.uncheckedNormalImage;
            this.hoverImage = this.uncheckedHoverImage;
            this.pushImage = this.uncheckedHoverImage;
            this.disabledImage = this.uncheckedDisabledImage;
        }
        this.selectImage = null;
        this.displayImage = this.normalImage;
        this.isCheckBox = true;
    }

    public void setSelection(boolean selected) {
        this.state = selected ? ButtonState.IMG_BTN_SELECT : ButtonState.IMG_BTN_NORMAL;
        this.handleEvent(null);
    }

    public boolean getSelection() {
        return this.state == ButtonState.IMG_BTN_SELECT;
    }

    public void setEnabled(boolean enabled) {
        this.state = !enabled ? ButtonState.IMG_BTN_DISABLED : ButtonState.IMG_BTN_NORMAL;
        this.show();
    }

    public boolean getEnabled() {
        return this.state != ButtonState.IMG_BTN_DISABLED;
    }

    public void setChecked(boolean checked) {
        if (this.isCheckBox && this.state != ButtonState.IMG_BTN_DISABLED) {
            this.checkState = checked;
            if (this.checkState) {
                this.normalImage = this.checkedNormalImage;
                this.hoverImage = this.checkedHoverImage;
                this.pushImage = this.checkedHoverImage;
                this.disabledImage = this.checkedDisabledImage;
            } else {
                this.normalImage = this.uncheckedNormalImage;
                this.hoverImage = this.uncheckedHoverImage;
                this.pushImage = this.uncheckedHoverImage;
                this.disabledImage = this.uncheckedDisabledImage;
            }
            this.emitChangeStateEvent();
            this.show();
        }
    }

    public boolean isChecked() {
        if (this.isCheckBox) {
            return this.checkState;
        }
        return false;
    }

    private void initEventHandler() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                CustomImageButton.this.onPaintControl(e);
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                CustomImageButton.this.handleEvent(CustomMouseEvent.ICON_MOUSE_OVER);
            }

            public void mouseExit(MouseEvent e) {
                CustomImageButton.this.handleEvent(CustomMouseEvent.ICON_MOUSE_EXIT);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CustomImageButton.this.handleEvent(CustomMouseEvent.ICON_MOUSE_UP);
            }

            public void mouseDown(MouseEvent e) {
                CustomImageButton.this.handleEvent(CustomMouseEvent.ICON_MOUSE_DOWN);
            }

            public void mouseDoubleClick(MouseEvent e) {
                CustomImageButton.this.handleEvent(CustomMouseEvent.ICON_MOUSE_DOWN);
                CustomImageButton.this.handleEvent(CustomMouseEvent.ICON_MOUSE_UP);
            }
        });
    }

    protected void onPaintControl(PaintEvent e) {
        GC gc = e.gc;
        if (this.displayImage != null) {
            gc.drawImage(this.displayImage, 0, 0, this.displayImage.getImageData().width, this.displayImage.getImageData().height, 0, 0, this.displayImage.getImageData().width, this.displayImage.getImageData().height);
        }
    }

    public void handleEvent(Enum<CustomMouseEvent> event) {
        if (this.state == ButtonState.IMG_BTN_DISABLED) {
            return;
        }
        if (event == CustomMouseEvent.ICON_MOUSE_OVER) {
            if (this.state == ButtonState.IMG_BTN_PUSH) {
                return;
            }
            if (this.state == ButtonState.IMG_BTN_HOVER) {
                return;
            }
            if (this.state == ButtonState.IMG_BTN_SELECT) {
                return;
            }
            this.state = ButtonState.IMG_BTN_HOVER;
        } else if (event == CustomMouseEvent.ICON_MOUSE_DOWN) {
            if (this.state != ButtonState.IMG_BTN_SELECT) {
                this.state = ButtonState.IMG_BTN_PUSH;
            }
        } else if (event == CustomMouseEvent.ICON_MOUSE_UP) {
            if (this.state == ButtonState.IMG_BTN_PUSH) {
                if (this.isCheckBox) {
                    this.setChecked(!this.checkState);
                }
                this.state = this.selectImage != null ? ButtonState.IMG_BTN_SELECT : ButtonState.IMG_BTN_NORMAL;
                this.emitMouseClickEvent();
            }
        } else if (event == CustomMouseEvent.ICON_MOUSE_EXIT && this.state != ButtonState.IMG_BTN_SELECT) {
            this.state = ButtonState.IMG_BTN_NORMAL;
        }
        this.show();
    }

    private void show() {
        Image oldImage = this.displayImage;
        this.displayImage = this.state == ButtonState.IMG_BTN_HOVER && this.hoverImage != null ? this.hoverImage : (this.state == ButtonState.IMG_BTN_NORMAL && this.normalImage != null ? this.normalImage : (this.state == ButtonState.IMG_BTN_PUSH && this.pushImage != null ? this.pushImage : (this.state == ButtonState.IMG_BTN_DISABLED && this.disabledImage != null ? this.disabledImage : (this.state == ButtonState.IMG_BTN_SELECT && this.selectImage != null ? this.selectImage : this.normalImage))));
        if (oldImage != this.displayImage) {
            this.redraw();
        }
    }

    public void addMouseClickEventListener(IClickEventListener listener) {
        this.clickListenerList.add(listener);
    }

    public void removeAllMouseClickEventListeners() {
        this.clickListenerList = new ArrayList();
    }

    private void emitMouseClickEvent() {
        for (IClickEventListener listener : this.clickListenerList) {
            listener.onClick(this);
        }
    }

    public void addChangeStateEventListener(IChangeStateEventListener listener) {
        this.changeStateListenerList.add(listener);
    }

    public void removeAllChangeStateEventListeners() {
        this.changeStateListenerList = new ArrayList();
    }

    private void emitChangeStateEvent() {
        for (IChangeStateEventListener listener : this.changeStateListenerList) {
            listener.onChangeState(this, this.checkState);
        }
    }

    public static interface IChangeStateEventListener {
        public void onChangeState(CustomImageButton var1, boolean var2);
    }

    public static interface IClickEventListener {
        public void onClick(CustomImageButton var1);
    }

    public static enum CustomMouseEvent {
        ICON_MOUSE_OVER,
        ICON_MOUSE_DOWN,
        ICON_MOUSE_UP,
        ICON_MOUSE_EXIT;

    }

    private static enum ButtonState {
        IMG_BTN_NORMAL,
        IMG_BTN_HOVER,
        IMG_BTN_PUSH,
        IMG_BTN_DISABLED,
        IMG_BTN_SELECT;

    }
}

