/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.installer.ui.IMButton;
import org.tizen.installer.ui.custom.UIResource;

public class CustomMessageBoxDialog
extends Dialog {
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private UIResource uiResource;
    private String title;
    private String msgTitle;
    private String msg;
    private DialogType dlgType;
    private boolean onlyOk;
    private boolean isBold;
    private boolean isAutoClose = false;
    boolean isFirstRun = true;
    private StyledText textTitleArea;
    private Composite contentArea;
    private Composite msgContent;
    private int count = 5;
    private Composite container;

    public CustomMessageBoxDialog(Shell parentShell, UIResource uiResource, String title, String msg, DialogType dlgType, boolean onlyOk) {
        super(parentShell);
        this.setShellStyle(67680);
        this.uiResource = uiResource;
        this.title = title;
        this.msg = msg;
        this.msgTitle = null;
        this.dlgType = dlgType;
        this.onlyOk = onlyOk;
        this.isBold = true;
    }

    public CustomMessageBoxDialog(Shell parentShell, UIResource uiResource, String title, String msgTitle, String msg, DialogType dlgType, boolean onlyOk, boolean isAutoClose) {
        super(parentShell);
        this.setShellStyle(67680);
        this.uiResource = uiResource;
        this.title = title;
        this.msg = msg;
        this.msgTitle = msgTitle;
        this.dlgType = dlgType;
        this.onlyOk = onlyOk;
        this.isBold = true;
        this.isAutoClose = isAutoClose;
    }

    public CustomMessageBoxDialog(Shell parentShell, UIResource uiResource, String title, String msgTitle, String msg, DialogType dlgType, boolean onlyOk) {
        super(parentShell);
        this.setShellStyle(67680);
        this.uiResource = uiResource;
        this.title = title;
        this.msg = msg;
        this.msgTitle = msgTitle;
        this.dlgType = dlgType;
        this.onlyOk = onlyOk;
        this.isBold = true;
    }

    protected Control createDialogArea(final Composite parent) {
        this.container = (Composite)super.createDialogArea(parent);
        this.container.setBackground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_WHITE));
        this.container.setLayout((Layout)new FormLayout());
        this.createContent(this.container);
        this.createLine(this.container);
        if (this.isAutoClose) {
            this.container.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent arg0) {
                    if (CustomMessageBoxDialog.this.isFirstRun) {
                        CustomMessageBoxDialog.this.isFirstRun = false;
                        parent.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Thread t = new Thread(new Runnable(){

                                    @Override
                                    public void run() {
                                        while (!CustomMessageBoxDialog.this.textTitleArea.isDisposed()) {
                                            try {
                                                Thread.sleep(1000L);
                                            }
                                            catch (InterruptedException e) {
                                                e.printStackTrace();
                                            }
                                            parent.getDisplay().asyncExec(new Runnable(){

                                                @Override
                                                public void run() {
                                                    if (!CustomMessageBoxDialog.this.textTitleArea.isDisposed()) {
                                                        CustomMessageBoxDialog.this.count--;
                                                        CustomMessageBoxDialog.this.textTitleArea.setText("" + CustomMessageBoxDialog.this.count);
                                                        CustomMessageBoxDialog.this.getShell().redraw();
                                                        if (CustomMessageBoxDialog.this.count == 0) {
                                                            CustomMessageBoxDialog.this.okPressed();
                                                        }
                                                    }
                                                }
                                            });
                                        }
                                    }
                                });
                                t.start();
                            }
                        });
                    }
                }
            });
        } else {
            this.createButton(this.container);
        }
        return this.container;
    }

    private void createContent(Composite composite) {
        this.contentArea = new Composite(composite, 0);
        this.contentArea.setBackground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_WHITE));
        Rectangle contentAreaBounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_MESSAGEBOX_DIALOG_CONTENT);
        FormData contentAreaFormData = new FormData();
        contentAreaFormData.left = new FormAttachment((Control)composite, contentAreaBounds.x, 16384);
        contentAreaFormData.top = new FormAttachment((Control)composite, contentAreaBounds.y, 16384);
        contentAreaFormData.width = contentAreaBounds.width;
        contentAreaFormData.height = contentAreaBounds.height;
        this.contentArea.setLayoutData((Object)contentAreaFormData);
        this.contentArea.setBackgroundMode(1);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        this.contentArea.setLayout((Layout)gridLayout);
        Image iconImage = null;
        iconImage = this.dlgType == null ? new Image((Device)this.contentArea.getDisplay(), this.uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_INFO_ICON)) : (this.dlgType == DialogType.INFO ? new Image((Device)this.contentArea.getDisplay(), this.uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_INFO_ICON)) : (this.dlgType == DialogType.NOTIFY_OK ? new Image((Device)this.contentArea.getDisplay(), this.uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_INFO_ICON)) : (this.dlgType == DialogType.NOTIFY_YES ? new Image((Device)this.contentArea.getDisplay(), this.uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_INFO_ICON)) : (this.dlgType == DialogType.WARNING ? new Image((Device)this.contentArea.getDisplay(), this.uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_WARNING_ICON)) : (this.dlgType == DialogType.ERROR ? new Image((Device)this.contentArea.getDisplay(), this.uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_WARNING_ICON)) : (this.dlgType == DialogType.QESTION ? new Image((Device)this.contentArea.getDisplay(), this.uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_QEUSTION_ICON)) : new Image((Device)this.contentArea.getDisplay(), this.uiResource.getImageStream(UIResource.UIImages.WIZARD_IMAGE_INFO_ICON))))))));
        IMButton ibm = new IMButton(this.contentArea, 0x20000000);
        GridData iconGriddata = new GridData(131072, 0x1000000, true, true);
        iconGriddata.widthHint = iconImage.getBounds().width;
        iconGriddata.heightHint = iconImage.getBounds().height;
        ibm.setLayoutData(iconGriddata);
        ibm.setImage(iconImage);
        if (this.msgTitle != null && this.msgTitle.length() > 0) {
            this.drawTileAndText(this.contentArea);
        } else {
            this.drawOnlyText(this.contentArea);
        }
    }

    private void drawTileAndText(Composite contentArea) {
        Rectangle textBounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_MESSAGEBOX_DIALOG_CONTENT_TEXT);
        this.msgContent = new Composite(contentArea, 0);
        this.msgContent.setBackground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_WHITE));
        GridData gridData = new GridData(16384, 0x1000000, true, true);
        gridData.widthHint = textBounds.width;
        this.msgContent.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        gridLayout.verticalSpacing = textBounds.y;
        gridLayout.horizontalSpacing = 0;
        this.msgContent.setLayout((Layout)gridLayout);
        this.textTitleArea = new StyledText(this.msgContent, 66);
        this.textTitleArea.setText(this.msgTitle);
        gridData = new GridData(16384, 0x1000000, true, true);
        gridData.widthHint = textBounds.width;
        this.textTitleArea.setLayoutData((Object)gridData);
        if (this.isAutoClose) {
            this.textTitleArea.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_25PX, false, 1));
        } else {
            this.textTitleArea.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 1));
        }
        this.textTitleArea.setAlignment(16384);
        this.textTitleArea.setEditable(false);
        this.textTitleArea.setCaret(null);
        this.textTitleArea.setMargins(textBounds.x, 0, 0, 0);
        StyledText textArea = new StyledText(this.msgContent, 66);
        textArea.setText(this.msg);
        gridData = new GridData(16384, 0x1000000, true, true);
        gridData.widthHint = textBounds.width;
        textArea.setLayoutData((Object)gridData);
        textArea.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 0));
        textArea.setAlignment(16384);
        textArea.setEditable(false);
        textArea.setCaret(null);
        textArea.setMargins(textBounds.x, 0, 0, 0);
    }

    private void drawOnlyText(Composite contentArea) {
        Rectangle textBounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_MESSAGEBOX_DIALOG_CONTENT_TEXT);
        StyledText textArea = new StyledText(contentArea, 66);
        textArea.setText(this.msg);
        GridData gridData = new GridData(16384, 0x1000000, true, true);
        gridData.widthHint = textBounds.width;
        textArea.setLayoutData((Object)gridData);
        textArea.setFont(this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, this.isBold ? 1 : 0));
        textArea.setAlignment(16384);
        textArea.setEditable(false);
        textArea.setCaret(null);
        textArea.setMargins(textBounds.x, 0, 0, 0);
    }

    private void createLine(Composite composite) {
        Composite splitterContainer = new Composite(composite, 0x20000000);
        Rectangle lineBounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_MESSAGEBOX_DIALOG_LINE);
        FormData splitterFormData = new FormData();
        splitterFormData.left = new FormAttachment((Control)composite, lineBounds.x, 16384);
        splitterFormData.top = new FormAttachment((Control)composite, lineBounds.y, 16384);
        splitterFormData.width = lineBounds.width;
        splitterFormData.height = lineBounds.height;
        splitterContainer.setLayoutData((Object)splitterFormData);
        splitterContainer.setLayout((Layout)new FormLayout());
        splitterContainer.setBackground(this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_LINE_SPLITTER));
    }

    private void createButton(Composite composite) {
        String okString = null;
        String cancelString = null;
        if (this.dlgType == null) {
            okString = "OK";
        } else if (this.dlgType == DialogType.INFO) {
            okString = "OK";
        } else if (this.dlgType == DialogType.NOTIFY_OK) {
            okString = "OK";
        } else if (this.dlgType == DialogType.NOTIFY_YES) {
            okString = "Yes";
            cancelString = "No";
        } else if (this.dlgType == DialogType.WARNING) {
            okString = "Yes";
            cancelString = "No";
        } else if (this.dlgType == DialogType.ERROR) {
            okString = "OK";
        } else if (this.dlgType == DialogType.QESTION) {
            okString = "Yes";
            cancelString = "No";
        }
        if (this.onlyOk) {
            cancelString = null;
        }
        Font buttonFont = this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 0);
        Button okButton = new Button(composite, 8);
        okButton.setText(okString);
        okButton.setFont(buttonFont);
        Rectangle okBounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_MESSAGEBOX_DIALOG_OK_BUTTON);
        FormData okFormData = new FormData();
        okFormData.left = new FormAttachment((Control)composite, okBounds.x, 16384);
        okFormData.top = new FormAttachment((Control)composite, okBounds.y, 16384);
        okFormData.width = okBounds.width;
        okFormData.height = okBounds.height;
        okButton.setLayoutData((Object)okFormData);
        okButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                CustomMessageBoxDialog.this.okPressed();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                CustomMessageBoxDialog.this.okPressed();
            }
        });
        if (cancelString != null) {
            Button cancelButton = new Button(composite, 8);
            cancelButton.setText(cancelString);
            cancelButton.setFont(buttonFont);
            Rectangle cancelBounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_MESSAGEBOX_DIALOG_CANCEL_BUTTON);
            FormData cancelFormData = new FormData();
            cancelFormData.left = new FormAttachment((Control)composite, cancelBounds.x, 16384);
            cancelFormData.top = new FormAttachment((Control)composite, cancelBounds.y, 16384);
            cancelFormData.width = cancelBounds.width;
            cancelFormData.height = cancelBounds.height;
            cancelButton.setLayoutData((Object)cancelFormData);
            cancelButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    CustomMessageBoxDialog.this.cancelPressed();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    CustomMessageBoxDialog.this.cancelPressed();
                }
            });
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        newShell.setImage(new Image((Device)newShell.getParent().getDisplay(), this.uiResource.getImageStream(UIResource.UIImages.IMAGE_SDK_ICON)));
        Shell parentShell = null;
        try {
            parentShell = newShell.getParent().getShell();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Rectangle bounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_MESSAGEBOX_DIALOG);
        if (parentShell != null) {
            Rectangle pBounds = parentShell.getBounds();
            newShell.setBounds(pBounds.x + pBounds.width / 2 - bounds.width / 2, pBounds.y + pBounds.height / 2 - bounds.height / 2, bounds.width, bounds.height);
        } else {
            newShell.setBounds(bounds);
        }
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    public static enum DialogType {
        INFO,
        NOTIFY_OK,
        NOTIFY_YES,
        WARNING,
        ERROR,
        QESTION;

    }
}

