/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.dialog;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.tizen.installer.exception.IMFatalException;
import org.tizen.installer.ui.custom.CallableWithMonitor;
import org.tizen.installer.ui.custom.UIResource;
import org.tizen.installer.util.Log;

public class CustomProgressDialog
extends Dialog
implements IProgressMonitor {
    private static final int IMAGE_LOADING_TIME = 40;
    private static Logger logger = null;
    private Display display = null;
    private Shell shell = null;
    private UIResource uiRsrcHandler;
    private Label nameLabel = null;
    private int imageCount = 0;
    ArrayList<Image> loadingImages = new ArrayList();
    private boolean isCloseByDone = false;
    private IProgressMonitor monitor = null;
    private String title = "";
    private Composite bufferedComposite;
    private Image img = null;

    public CustomProgressDialog(Shell parent, String title, UIResource uiRsrcHandler) {
        super(parent, 0x20000000);
        logger = Log.getLogger(CustomProgressDialog.class);
        this.uiRsrcHandler = uiRsrcHandler;
        this.display = this.getParent().getDisplay();
        parent.getShell().setImage(new Image((Device)this.display, uiRsrcHandler.getImageStream(UIResource.UIImages.IMAGE_SDK_ICON)));
        this.title = title;
    }

    public <T1> T1 run(final CallableWithMonitor<T1> callable) throws IMFatalException {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        this.monitor = this;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future future = executor.submit(new Callable<T1>(){

            @Override
            public T1 call() throws Exception {
                Object result = callable.call(CustomProgressDialog.this.monitor);
                if (!CustomProgressDialog.this.isCloseByDone) {
                    CustomProgressDialog.this.finish();
                }
                return result;
            }
        });
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        T1 result = null;
        try {
            result = (T1)future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IMFatalException) {
                throw (IMFatalException)e.getCause();
            }
            logger.throwing((Throwable)e);
        }
        catch (InterruptedException e) {
            logger.throwing((Throwable)e);
        }
        executor.shutdown();
        return result;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setSize(297, 130);
        if (this.title != null && !this.title.isEmpty()) {
            this.shell.setText(this.title);
        } else {
            this.shell.setText("Installer");
        }
        this.shell.setImage(new Image((Device)this.shell.getParent().getDisplay(), this.uiRsrcHandler.getImageStream(UIResource.UIImages.IMAGE_SDK_ICON)));
        Monitor monitor = this.display.getPrimaryMonitor();
        Rectangle monitorRect = monitor.getBounds();
        Rectangle shellRect = this.shell.getBounds();
        int centerX = monitorRect.x + (monitorRect.width - shellRect.width) / 2;
        int centerY = monitorRect.y + (monitorRect.height - shellRect.height) / 2;
        this.shell.setLocation(centerX, centerY);
        Composite temp = new Composite((Composite)this.shell, 0);
        this.bufferedComposite = new Composite(temp, 0);
        this.loadingImages = this.uiRsrcHandler.getLoadingImage(this.display);
        this.img = this.loadingImages.get(this.imageCount);
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (!CustomProgressDialog.this.nameLabel.isDisposed()) {
                            try {
                                Thread.sleep(40L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            CustomProgressDialog.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!CustomProgressDialog.this.nameLabel.isDisposed()) {
                                        CustomProgressDialog.this.imageCount++;
                                        if (CustomProgressDialog.this.imageCount > CustomProgressDialog.this.loadingImages.size() - 1) {
                                            CustomProgressDialog.this.imageCount = 0;
                                        }
                                        int count = CustomProgressDialog.this.imageCount;
                                        CustomProgressDialog.this.img = CustomProgressDialog.this.loadingImages.get(count > CustomProgressDialog.this.loadingImages.size() - 1 ? 0 : count);
                                        CustomProgressDialog.this.shell.redraw();
                                    }
                                }
                            });
                        }
                    }
                });
                t.start();
            }
        });
        this.shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                Rectangle rect = new Rectangle(8, 50, 276, 22);
                Image bufferedImage = new Image((Device)CustomProgressDialog.this.bufferedComposite.getDisplay(), rect);
                GC gc = new GC((Drawable)bufferedImage);
                gc.drawImage(CustomProgressDialog.this.img, 0, 0);
                gc.setAntialias(1);
                event.gc.drawImage(bufferedImage, 8, 50);
            }
        });
        this.nameLabel = new Label((Composite)this.shell, 0x1000000);
        this.nameLabel.setBounds(25, 17, 250, 32);
        this.nameLabel.setText("");
        this.nameLabel.setFont(this.uiRsrcHandler.getFont(UIResource.UIFont.FONT_SIZE_SMALL));
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                if (!CustomProgressDialog.this.isCloseByDone) {
                    event.doit = false;
                }
            }
        });
    }

    private void updateName(final String taskName) {
        if (!this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!CustomProgressDialog.this.nameLabel.isDisposed()) {
                        CustomProgressDialog.this.nameLabel.setText(taskName);
                        CustomProgressDialog.this.nameLabel.setFont(CustomProgressDialog.this.uiRsrcHandler.getFont(UIResource.UIFont.FONT_SIZE_SMALL));
                    }
                }
            });
        }
    }

    private void finish() {
        if (this.shell == null || this.shell.isDisposed()) {
            return;
        }
        this.isCloseByDone = true;
        if (!this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    CustomProgressDialog.this.shell.close();
                }
            });
        }
    }

    public void beginTask(String task, int totalwork) {
        this.updateName(task);
    }

    public void done() {
        this.finish();
    }

    public void internalWorked(double arg0) {
    }

    public boolean isCanceled() {
        return false;
    }

    public void setCanceled(boolean arg0) {
    }

    public void setTaskName(String arg0) {
    }

    public void subTask(String name) {
        this.updateName(name);
    }

    public void worked(int arg0) {
    }
}

