/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.wizard;

import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.installer.common.IInstallProgressMonitor;
import org.tizen.installer.core.InstallController;
import org.tizen.installer.exception.ErrorController;
import org.tizen.installer.exception.IMFatalException;
import org.tizen.installer.ui.custom.CallableWithMonitor;
import org.tizen.installer.ui.custom.IMCircularGraph2;
import org.tizen.installer.ui.custom.UIResource;
import org.tizen.installer.ui.dialog.CustomMessageBoxDialog;
import org.tizen.installer.ui.dialog.CustomProgressDialog;
import org.tizen.installer.ui.wizard.WizardCommonPage;
import org.tizen.installer.ui.wizard.WizardDefaultWindow;
import org.tizen.installer.ui.wizard.WizardMaster;
import org.tizen.installer.util.FileUtil;
import org.tizen.installer.util.Log;
import org.tizen.installer.util.PathUtil;
import org.tizen.installer.util.ShortCutCreator;

public class WizardInstallingPage
extends WizardCommonPage {
    private static final Logger logger = Log.getLogger(WizardInstallingPage.class);
    private IMCircularGraph2 imc;
    private String installingFile = "Preparing..";
    private String installingSize = "Preparing..";
    private Display display;
    private boolean isFirstRun = true;
    private InstallProgressMonitor ipm = new InstallProgressMonitor();

    public WizardInstallingPage(Composite parentComposite, UIResource uiResource, InstallController installController, int swtOption, WizardMaster wizardMaster) throws IMFatalException {
        super(parentComposite, swtOption, uiResource, installController, wizardMaster);
        this.display = parentComposite.getDisplay();
        this.createCenterContainer();
        this.handleInstallingEvent();
        this.handleBottomEvent();
    }

    private void handleBottomEvent() {
        this.backButton.setEnabled(false);
        this.backButton.setVisible(true);
        this.firstButton.setEnabled(false);
        this.firstButton.setVisible(true);
        this.firstButton.setText("Install");
        this.secondButton.setText("Cancel");
        this.secondButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                logger.trace("User click quit button widgetSelected => " + arg0);
                WizardInstallingPage.this.getShell().close();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                logger.trace((Object)arg0);
            }
        });
    }

    private void handleInstallingEvent() {
        this.centerContainer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                logger.trace((Object)arg0);
                WizardInstallingPage.this.handleInit();
            }
        });
    }

    private void handleInit() {
        if (this.isFirstRun) {
            logger.trace("InstallingPage is called.");
            this.infoLabel.setText("Installation is in progress...");
            this.isFirstRun = false;
            logger.trace("Selected directory : " + this.installController.getConfig().getInstallDirectory());
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        WizardInstallingPage.this.installController.getZipLibrary().unzip(WizardInstallingPage.this.installController.getConfig().getInstallDirectory(), WizardInstallingPage.this.ipm, WizardInstallingPage.this.installController.getExtractThread());
                        File dataLocation = new File(WizardInstallingPage.this.installController.getConfig().getDataLocation());
                        if (!dataLocation.exists()) {
                            dataLocation.mkdirs();
                        }
                        WizardInstallingPage.this.installController.makeSdkInfoFile();
                    }
                    catch (IOException e) {
                        ErrorController.setInstallationSuccess(false);
                        ErrorController.setErrorMessage(e.getMessage());
                        WizardInstallingPage.this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                WizardInstallingPage.this.wizardMaster.enablePages(WizardDefaultWindow.WIZARD_PAGES.FAIL_PAGE);
                            }
                        });
                    }
                    catch (Exception e) {
                        ErrorController.setInstallationSuccess(false);
                        ErrorController.setErrorMessage(e.getMessage());
                        WizardInstallingPage.this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                WizardInstallingPage.this.wizardMaster.enablePages(WizardDefaultWindow.WIZARD_PAGES.FAIL_PAGE);
                            }
                        });
                    }
                    finally {
                        WizardInstallingPage.this.installController.shutdownExtractThread();
                    }
                }
            };
            thread.start();
        }
    }

    private void createCenterContainer() {
        Composite leftContainer = new Composite(this.centerContainer, 0x20000000);
        Rectangle bounds = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INSTALL_IC_SDK);
        Rectangle strokeSize = this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INSTALL_IC_STROKE);
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.centerContainer, bounds.x, 0x1000000);
        formData.top = new FormAttachment((Control)this.centerContainer, bounds.y, 0x1000000);
        formData.width = bounds.width;
        formData.height = bounds.height;
        leftContainer.setLayoutData((Object)formData);
        leftContainer.setLayout((Layout)new FillLayout(256));
        this.imc = this.uiResource.handleInstallingForWizardProgress(leftContainer, this.uiResource, 0L, bounds.width, bounds.height, bounds.width - (strokeSize.width + strokeSize.height), 0);
        this.createInfoComposites(this.centerContainer);
    }

    private void createInfoComposites(final Composite rightContainer) {
        rightContainer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                Image bufferedImage = new Image((Device)rightContainer.getDisplay(), rightContainer.getBounds());
                GC gc = new GC((Drawable)bufferedImage);
                gc.setAntialias(1);
                Rectangle installingBounds = WizardInstallingPage.this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_INSTALLING_LOCATION);
                Rectangle centerBounds = WizardInstallingPage.this.uiResource.getBounds(UIResource.UISizes.WIZARD_SIZE_CENTER);
                gc.setForeground(WizardInstallingPage.this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_PURE_BLUE));
                gc.setFont(WizardInstallingPage.this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 1));
                String currentSize = "";
                String totalSize = "";
                if (WizardInstallingPage.this.installingSize.contains("/")) {
                    String[] split = WizardInstallingPage.this.installingSize.split("/");
                    currentSize = split[0].trim();
                    totalSize = " / " + split[1].trim();
                } else {
                    currentSize = WizardInstallingPage.this.installingSize;
                }
                int positionX = installingBounds.x;
                Point textExtent = gc.textExtent(currentSize);
                int positionY = centerBounds.height / 2 - textExtent.y;
                gc.drawText(currentSize, positionX, positionY - textExtent.y / 4, 1);
                if (totalSize.length() > 0) {
                    gc.setForeground(WizardInstallingPage.this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_33));
                    gc.setFont(WizardInstallingPage.this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 1));
                    gc.drawText(totalSize, positionX + textExtent.x, positionY - textExtent.y / 4, 1);
                }
                gc.setForeground(WizardInstallingPage.this.uiResource.getColors(UIResource.UIColors.WIZARD_COLOR_VERY_DARK_GRAY_58));
                gc.setFont(WizardInstallingPage.this.uiResource.getFontBySize(UIResource.UIFontSize.FONT_SIZE_13PX, false, 0));
                gc.drawText(WizardInstallingPage.this.installingFile, positionX, positionY + textExtent.y + textExtent.y / 4, 1);
                event.gc.drawImage(bufferedImage, 0, 0);
            }
        });
    }

    public boolean workEventClose() {
        this.ipm.setPause(true);
        CustomMessageBoxDialog dialog = new CustomMessageBoxDialog(this.getShell(), this.uiResource, "Installer", "Are you sure you want to cancel SDK installation?", CustomMessageBoxDialog.DialogType.QESTION, false);
        int ret = dialog.open();
        if (ret == 1) {
            logger.trace("User select not cancel installation.");
            this.ipm.setPause(false);
        } else {
            logger.trace("User select cancel installation");
            this.ipm.setCanceled(true);
            this.ipm.setPause(false);
            this.ipm.setCancelMessage();
            this.imc.update(0L);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        WizardInstallingPage.this.installController.shutdownExtractThread();
                    }
                    catch (Exception e) {
                        logger.throwing((Throwable)e);
                    }
                    FileUtil.deleteDirectory(this.getClass(), WizardInstallingPage.this.ipm, new File(WizardInstallingPage.this.installController.getConfig().getInstallDirectory()));
                    FileUtil.deleteDirectory(this.getClass(), WizardInstallingPage.this.ipm, new File(WizardInstallingPage.this.installController.getConfig().getDataLocation()));
                    WizardInstallingPage.this.ipm.done("Installation was canceled!");
                }
            });
            thread.start();
        }
        return false;
    }

    public class InstallProgressMonitor
    implements IInstallProgressMonitor {
        private boolean isCanceled = false;
        private boolean isPaused = false;
        private long startTime = System.currentTimeMillis();

        @Override
        public boolean getIsPaused() {
            return this.isPaused;
        }

        @Override
        public void setPause(boolean isPaused) {
            this.isPaused = isPaused;
        }

        public void beginTask(String arg0, int arg1) {
            if (WizardInstallingPage.this.display == null || WizardInstallingPage.this.display.isDisposed()) {
                this.setCanceled(true);
                return;
            }
        }

        public void done() {
        }

        public void internalWorked(double arg0) {
            logger.trace((Object)arg0);
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        public void setCanceled(boolean isCanceled) {
            this.isCanceled = isCanceled;
        }

        public void setTaskName(String arg0) {
        }

        public void subTask(String arg0) {
        }

        public void worked(int arg0) {
        }

        @Override
        public void workedInstall(final String percentValue, final String workingSize, final String workingFile) {
            if (WizardInstallingPage.this.display == null || WizardInstallingPage.this.display.isDisposed()) {
                this.setCanceled(true);
                return;
            }
            WizardInstallingPage.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!InstallProgressMonitor.this.isCanceled) {
                        if (System.currentTimeMillis() - InstallProgressMonitor.this.startTime >= 150L) {
                            WizardInstallingPage.this.installingSize = workingSize;
                            WizardInstallingPage.this.installingFile = PathUtil.getShortDirectory(workingFile, 45);
                            long value = Long.parseLong(percentValue.replace("%", "").trim());
                            WizardInstallingPage.this.imc.update(value);
                            InstallProgressMonitor.this.startTime = System.currentTimeMillis();
                            WizardInstallingPage.this.centerContainer.redraw();
                        } else if (percentValue.startsWith("100")) {
                            WizardInstallingPage.this.installingSize = workingSize;
                            long value = Long.parseLong(percentValue.replace("%", "").trim());
                            WizardInstallingPage.this.imc.update(value);
                            WizardInstallingPage.this.centerContainer.redraw();
                        }
                    }
                }
            });
        }

        @Override
        public void setDeletingFileName(final String name) {
            if (WizardInstallingPage.this.display == null || WizardInstallingPage.this.display.isDisposed()) {
                this.setCanceled(true);
                return;
            }
            WizardInstallingPage.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (System.currentTimeMillis() - InstallProgressMonitor.this.startTime >= 10L) {
                        WizardInstallingPage.this.installingSize = "Cleaning the installation files...";
                        WizardInstallingPage.this.installingFile = name;
                        InstallProgressMonitor.this.startTime = System.currentTimeMillis();
                        WizardInstallingPage.this.centerContainer.redraw();
                    }
                }
            });
        }

        @Override
        public void setCancelMessage() {
        }

        @Override
        public void initialize(String message) {
            if (WizardInstallingPage.this.display == null || WizardInstallingPage.this.display.isDisposed()) {
                this.setCanceled(true);
                return;
            }
        }

        @Override
        public void done(String message) {
            if (WizardInstallingPage.this.display == null || WizardInstallingPage.this.display.isDisposed()) {
                this.setCanceled(true);
                return;
            }
            WizardInstallingPage.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!InstallProgressMonitor.this.isCanceled) {
                        Shell initShell = new Shell(Display.getDefault());
                        try {
                            CustomProgressDialog progressBar = new CustomProgressDialog(initShell, null, WizardInstallingPage.this.uiResource);
                            progressBar.run(new CallableWithMonitor<Boolean>(){

                                @Override
                                public Boolean call(IProgressMonitor monitor) throws Exception {
                                    try {
                                        monitor.beginTask("Creating shortcuts.\nIt may take a minute...", -1);
                                        ShortCutCreator scu = new ShortCutCreator(WizardInstallingPage.this.installController.getConfig());
                                        logger.trace("\t Shortcut create start.");
                                        scu.createMenuShortCut();
                                        scu.createShorts();
                                        WizardInstallingPage.this.uiResource.copyDefaultFont();
                                        logger.trace("\t Shortcut create end.");
                                        ErrorController.setInstallationSuccess(true);
                                    }
                                    catch (IMFatalException e) {
                                        logger.error(WizardInstallingPage.class.getName() + " => " + e.getMessage());
                                    }
                                    catch (Exception e) {
                                        logger.error(WizardInstallingPage.class.getName() + " => " + e.getMessage());
                                    }
                                    finally {
                                        WizardInstallingPage.this.installController.shutdownExtractThread();
                                        monitor.done();
                                    }
                                    return true;
                                }
                            });
                        }
                        catch (IMFatalException e) {
                            throw e;
                        }
                        finally {
                            initShell.close();
                        }
                        WizardInstallingPage.this.wizardMaster.enablePages(WizardDefaultWindow.WIZARD_PAGES.COMPLETED_PAGE);
                    } else {
                        try {
                            WizardInstallingPage.this.installController.shutdownExtractThread();
                        }
                        catch (Exception e) {
                            logger.throwing((Throwable)e);
                        }
                        FileUtil.deleteDirectory(this.getClass(), WizardInstallingPage.this.ipm, new File(WizardInstallingPage.this.installController.getConfig().getInstallDirectory()));
                        FileUtil.deleteDirectory(this.getClass(), WizardInstallingPage.this.ipm, new File(WizardInstallingPage.this.installController.getConfig().getDataLocation()));
                        ErrorController.setError(ErrorController.ErrorCode.INSTALLATION_CANCEL);
                        WizardInstallingPage.this.wizardMaster.enablePages(WizardDefaultWindow.WIZARD_PAGES.FAIL_PAGE);
                    }
                }
            });
        }
    }
}

