/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.wizard;

import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.installer.cli.CLIOptions;
import org.tizen.installer.cli.Initializer;
import org.tizen.installer.core.Config;
import org.tizen.installer.core.InstallController;
import org.tizen.installer.exception.ErrorController;
import org.tizen.installer.exception.IMFatalException;
import org.tizen.installer.ui.custom.CallableWithMonitor;
import org.tizen.installer.ui.custom.UIResource;
import org.tizen.installer.ui.dialog.CustomMessageBoxDialog;
import org.tizen.installer.ui.dialog.CustomProgressDialog;
import org.tizen.installer.ui.wizard.UiInitializeUtil;
import org.tizen.installer.ui.wizard.WizardDefaultWindow;
import org.tizen.installer.util.CocoaUtil;
import org.tizen.installer.util.Log;
import org.tizen.installer.util.PathUtil;
import org.tizen.installer.util.PlatformUtil;

public class WizardUIMain {
    private static Logger logger = null;
    private static InstallController installerConroller = null;
    private static UIResource uiResource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (PlatformUtil.isWindows()) {
            WizardUIMain.initDisplay();
        }
        Config config = null;
        try {
            config = new Config();
        }
        catch (IMFatalException e) {
            WizardUIMain.showMessageBoxWithError(e);
            System.exit(-1);
        }
        Log.open(config);
        Log.LogTitle("Installer UI mode start");
        Log.LogInfo("\n" + PlatformUtil.getPlatformInfo());
        Log.LogInfo("Directory of running Installer : " + PathUtil.getCurrentDir());
        logger = Log.getLogger(WizardUIMain.class);
        logger.trace("Initializing start.");
        CLIOptions options = new CLIOptions();
        Initializer.loadCmdArgs(args, options);
        uiResource = new UIResource();
        if (PlatformUtil.isMacOS()) {
            logger.trace("Initializing MAC Application...");
            WizardUIMain.initializeAppForMacOS();
        }
        if (!options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.NO_JAVA_CHECK) && !UiInitializeUtil.checkingJava(logger)) {
            return;
        }
        WizardUIMain.startUp(config, options, uiResource);
        logger.trace("Initializing finished.");
        logger.trace("Start installation.");
        if (ErrorController.checkInstallationSuccess()) {
            WizardDefaultWindow wizardWindow = null;
            try {
                wizardWindow = new WizardDefaultWindow(installerConroller, uiResource);
                logger.trace("before wizardWindow.run()");
                wizardWindow.run();
                Shell shell = wizardWindow.getShell();
                shell.pack();
                shell.open();
                while (!shell.isDisposed()) {
                    try {
                        if (shell.getDisplay().readAndDispatch()) continue;
                        shell.getDisplay().sleep();
                    }
                    catch (Throwable e) {
                        logger.throwing(e);
                    }
                }
                logger.trace("after wizardWindow.run()");
            }
            catch (Exception e) {
                logger.error(WizardUIMain.class.getName() + " => " + e.getMessage());
                logger.throwing((Throwable)e);
                WizardUIMain.showErrorMessage(e.getMessage());
            }
            finally {
                logger.trace("Finish installation.");
                logger.trace("Installation result : " + ErrorController.checkInstallationSuccess());
                if (installerConroller != null) {
                    logger.trace("************************** Performance result **************************");
                    logger.trace("Installer initializing time : " + installerConroller.getInitializeTime());
                    logger.trace("Installer total unzip time : " + installerConroller.getTotalUnzipTime());
                    logger.trace("************************** Performance result **************************");
                }
                Log.LogTitle("Installer is finished.");
                WizardUIMain.closeQuitely(wizardWindow);
                WizardUIMain.disposeDisplay();
                System.exit(ErrorController.getExitCode());
            }
        }
    }

    public static void disposeDisplay() {
        Display display = Display.getDefault();
        if (display != null && !display.isDisposed()) {
            display.dispose();
        }
    }

    private static void initializeAppForMacOS() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Installer");
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                new CocoaUtil().hidePreferencesAndAboutMenuItems();
            }
        });
    }

    private static void closeQuitely(WizardDefaultWindow wizardWindow) {
        if (wizardWindow != null && wizardWindow.getShell() != null && !wizardWindow.getShell().isDisposed()) {
            if (!wizardWindow.getShell().isDisposed()) {
                wizardWindow.getShell().dispose();
            }
            if (!wizardWindow.getShell().getDisplay().isDisposed()) {
                wizardWindow.getShell().getDisplay().dispose();
            }
        }
    }

    private static void initDisplay() {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.dispose();
        display.close();
    }

    private static void showMessageBoxWithError(Exception e) {
        String defaultMsg = "Installer will not work.\n";
        String msg = defaultMsg + "\"" + e.getLocalizedMessage() + "\"";
        WizardUIMain.showErrorMessage(msg);
    }

    private static void showErrorMessage(final String msg) {
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = new Shell(display);
                CustomMessageBoxDialog dialog = new CustomMessageBoxDialog(shell, uiResource, "Installer", msg, CustomMessageBoxDialog.DialogType.ERROR, false);
                dialog.open();
                shell.dispose();
            }
        });
    }

    private static void startUp(final Config config, final CLIOptions options, UIResource uiResource) {
        logger.info("Installer init start");
        Shell initShell = new Shell(Display.getDefault());
        try {
            CustomProgressDialog progressBar = new CustomProgressDialog(initShell, null, uiResource);
            progressBar.run(new CallableWithMonitor<Boolean>(){

                @Override
                public Boolean call(IProgressMonitor monitor) throws Exception {
                    try {
                        monitor.beginTask("Initializing...", -1);
                        installerConroller = new InstallController(false, config, options);
                        ErrorController.setInstallationSuccess(true);
                    }
                    catch (IMFatalException e) {
                        logger.error(WizardUIMain.class.getName() + " => " + e.getMessage());
                        ErrorController.setInstallationSuccess(false);
                        WizardUIMain.showMessageBoxWithError(e);
                    }
                    catch (Exception e) {
                        logger.error(WizardUIMain.class.getName() + " => " + e.getMessage());
                        ErrorController.setInstallationSuccess(false);
                        WizardUIMain.showMessageBoxWithError(e);
                    }
                    finally {
                        monitor.done();
                    }
                    return true;
                }
            });
        }
        catch (IMFatalException e) {
            throw e;
        }
        finally {
            initShell.close();
        }
        logger.info("Installer init end");
    }
}

