/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.imageio.stream.FileImageInputStream;
import org.apache.logging.log4j.Logger;
import org.tizen.installer.model.PrerequisitesInfo;
import org.tizen.installer.util.Log;
import org.tizen.installer.util.PlatformUtil;

public class PrerequisiteUtil {
    private static final String C_PREREQUISITES = "C-Prerequisites";
    private static final String PACKAGE = "Package";
    private static final Logger logger = Log.getLogger(PrerequisiteUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<PrerequisitesInfo> parsePrerequisties(File installedPackageList) {
        ArrayList<PrerequisitesInfo> listPrerequisites = new ArrayList<PrerequisitesInfo>();
        if (installedPackageList != null && installedPackageList.exists()) {
            FileImageInputStream fiis = null;
            try {
                fiis = new FileImageInputStream(installedPackageList);
                String readLine = "";
                String currentPackageName = "";
                String currentPrerequisites = "";
                while ((readLine = fiis.readLine()) != null) {
                    String prerequisties;
                    if (readLine.startsWith(PACKAGE)) {
                        String packageName;
                        currentPackageName = packageName = readLine.replaceFirst(PACKAGE, "").replaceFirst(":", "").trim();
                    }
                    if (!readLine.startsWith(C_PREREQUISITES)) continue;
                    currentPrerequisites = prerequisties = readLine.replaceFirst(C_PREREQUISITES, "").replaceFirst(":", "").trim();
                    listPrerequisites.add(new PrerequisitesInfo(currentPackageName, currentPrerequisites));
                }
            }
            catch (FileNotFoundException e) {
                logger.throwing((Throwable)e);
            }
            catch (IOException e) {
                logger.throwing((Throwable)e);
            }
            finally {
                try {
                    if (fiis != null) {
                        fiis.close();
                    }
                }
                catch (IOException e) {
                    logger.throwing((Throwable)e);
                }
            }
        }
        return listPrerequisites;
    }

    public static Map<String, List<String>> checkPrerequisities(List<PrerequisitesInfo> prerequisitesInfoList) {
        String ubuntuVersion = PlatformUtil.getUbuntuVersion();
        if (ubuntuVersion == null) {
            return null;
        }
        HashMap<String, List<String>> notInstalledPrerequistiesMap = new HashMap<String, List<String>>();
        HashSet<String> alreadyCheckedSet = new HashSet<String>();
        logger.info("Checking prerequisities start ...");
        for (PrerequisitesInfo preInfo : prerequisitesInfoList) {
            PrerequisiteUtil.getPrerequisites(ubuntuVersion, notInstalledPrerequistiesMap, alreadyCheckedSet, preInfo);
        }
        logger.info("Checking prerequisities end ...");
        return notInstalledPrerequistiesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getPrerequisites(String ubuntuVersion, Map<String, List<String>> notInstalledPrerequistiesMap, HashSet<String> alreadyCheckedSet, PrerequisitesInfo pkg) {
        String prerequisites = pkg.getPrerequisites();
        if (prerequisites != null && prerequisites.length() > 0) {
            prerequisites = prerequisites.trim();
            String[] split = prerequisites.split(",");
            ArrayList<String> notInstalledList = new ArrayList<String>();
            for (String requiredPackage : split) {
                String requiredPkg = requiredPackage.trim();
                if (requiredPkg.contains("[")) {
                    String requiredVersion = requiredPkg.substring(requiredPkg.indexOf("[") + 1, requiredPkg.indexOf("]")).trim();
                    String[] versionSplit = requiredVersion.split(" ");
                    List<String> asList = Arrays.asList(versionSplit);
                    if (!asList.contains(ubuntuVersion)) continue;
                    requiredPkg = requiredPkg.substring(0, requiredPkg.indexOf("[")).trim();
                }
                if (alreadyCheckedSet.contains(requiredPkg)) {
                    if (!notInstalledPrerequistiesMap.containsKey(requiredPkg)) continue;
                    List<String> list = notInstalledPrerequistiesMap.get(requiredPkg);
                    if (!list.contains(pkg.getPackageName())) {
                        list.add(pkg.getPackageName());
                    }
                    notInstalledPrerequistiesMap.put(requiredPkg, list);
                    continue;
                }
                alreadyCheckedSet.add(requiredPkg);
                String cmd = String.format("dpkg -l %s | grep ^ii", requiredPkg);
                ProcessBuilder pb = new ProcessBuilder("/bin/sh", "-c", cmd);
                Process proc = null;
                try {
                    proc = pb.start();
                    BufferedReader read = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    String line = null;
                    int count = 0;
                    while ((line = read.readLine()) != null) {
                        if (!line.contains(requiredPkg)) continue;
                        ++count;
                    }
                    if (count == 0) {
                        if (notInstalledPrerequistiesMap.containsKey(requiredPkg)) {
                            List<String> list = notInstalledPrerequistiesMap.get(requiredPkg);
                            list.add(pkg.getPackageName());
                            notInstalledPrerequistiesMap.remove(requiredPkg);
                            notInstalledPrerequistiesMap.put(requiredPkg, list);
                        } else {
                            notInstalledList.add(pkg.getPackageName());
                            notInstalledPrerequistiesMap.put(requiredPkg, notInstalledList);
                            logger.trace("\t[" + pkg.getPackageName() + "] needs these packages : " + prerequisites);
                        }
                    }
                    proc.waitFor();
                    proc.destroy();
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
                finally {
                    if (proc != null) {
                        proc.destroy();
                    }
                }
            }
        }
    }
}

