/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.imageio.stream.FileImageInputStream;
import org.apache.logging.log4j.Logger;
import org.tizen.installer.common.ISDKInstallerConstants;
import org.tizen.installer.core.Config;
import org.tizen.installer.util.FileUtil;
import org.tizen.installer.util.Log;
import org.tizen.installer.util.PathUtil;
import org.tizen.installer.util.PlatformUtil;
import org.tizen.installer.util.Shortcut;

public class ShortCutCreator {
    private static final String LINE_SPERATOR = ISDKInstallerConstants.NEW_LINE;
    private String INFO_DIRECTORY;
    private String INSTALLED_DIRECTORY;
    private String SHORTCUT_INFO_FILE_NAME;
    private String LINUX_DESKTOP_DIR_PATH;
    private String LINUX_DESKTOP_APPLICATION_PATH;
    private String LINUX_MENU_DIRECTORY_PATH;
    private String LINUX_MENU_NAME;
    private String LINUX_MENU_COMMENT;
    private String LINUX_MENU_VERSION;
    private String LINUX_MENU_ICON_FILE_NAME;
    private String WINDOWS_MAKESHORT_VBS;
    private String MACOS_MAKESHORT_SH;
    private static final Logger logger = Log.getLogger(ShortCutCreator.class);
    private Config config;
    boolean isMenuCreated = false;

    public ShortCutCreator(Config config) {
        this.config = config;
        this.LINUX_DESKTOP_DIR_PATH = config.getConfigValue(Config.ConfigOptions.LINUX_DESKTOP_DIR_PATH);
        this.LINUX_MENU_DIRECTORY_PATH = config.getConfigValue(Config.ConfigOptions.LINUX_MENU_DIRECTORY_PATH);
        this.INFO_DIRECTORY = config.getConfigValue(Config.ConfigOptions.INFO_DIRECTORY);
        this.LINUX_MENU_ICON_FILE_NAME = config.getConfigValue(Config.ConfigOptions.LINUX_MENU_ICON_FILE_NAME);
        this.LINUX_MENU_NAME = config.getConfigValue(Config.ConfigOptions.LINUX_MENU_NAME);
        this.LINUX_MENU_COMMENT = config.getConfigValue(Config.ConfigOptions.LINUX_MENU_COMMENT);
        this.LINUX_MENU_VERSION = config.getConfigValue(Config.ConfigOptions.LINUX_MENU_VERSION);
        this.INSTALLED_DIRECTORY = config.getInstallDirectory();
        this.LINUX_DESKTOP_APPLICATION_PATH = config.getConfigValue(Config.ConfigOptions.LINUX_DESKTOP_APPLICATION_PATH);
        this.SHORTCUT_INFO_FILE_NAME = config.getConfigValue(Config.ConfigOptions.SHORTCUT_INFO_FILE_NAME);
        this.WINDOWS_MAKESHORT_VBS = config.getConfigValue(Config.ConfigOptions.WINDOWS_MAKESHORT_VBS);
        this.MACOS_MAKESHORT_SH = config.getConfigValue(Config.ConfigOptions.MACOS_MAKESHORT_SH);
    }

    public void createMenuShortCut() {
        logger.trace("createMenuShortCut start.");
        if (PlatformUtil.isWindows()) {
            logger.trace("createMenuShortCut end ==> is not a linux");
            return;
        }
        if (PlatformUtil.isLinux()) {
            logger.trace("Linux create menut short cut.");
            this.createLinuxMenuShortcutFile();
        } else if (PlatformUtil.isMacOS()) {
            logger.trace("createMenuShortCut end ==> is not a linux");
            return;
        }
        logger.trace("createMenuShortCut end.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLinuxMenuShortcutFile() {
        File shortInfoFile = new File(PathUtil.get(this.INSTALLED_DIRECTORY, this.INFO_DIRECTORY, this.SHORTCUT_INFO_FILE_NAME));
        if (!shortInfoFile.exists()) {
            logger.error("Shortcut info file is not exists.");
            return;
        }
        logger.trace("Shortcut info file is exists.");
        if (!this.isMenuCreated) {
            this.isMenuCreated = true;
            String desktopDir = PathUtil.getFromHome(this.LINUX_DESKTOP_DIR_PATH);
            String menuDir = PathUtil.getFromHome(this.LINUX_MENU_DIRECTORY_PATH);
            String menuIconPath = PathUtil.get(this.INSTALLED_DIRECTORY, "package-manager", this.LINUX_MENU_ICON_FILE_NAME);
            String type = "Directory";
            logger.trace("desktopDir :" + desktopDir);
            logger.trace("menuDir :" + menuDir);
            logger.trace("menuIconPath :" + menuIconPath);
            File menuFile = new File(menuDir);
            if (menuFile != null && menuFile.getParentFile() != null && !menuFile.getParentFile().exists()) {
                logger.trace("Desktop directory is not exists. create => " + menuFile.getParentFile().getAbsolutePath());
                menuFile.getParentFile().mkdirs();
            } else if (menuFile.getParentFile() != null) {
                logger.trace("Desktop directory is exists." + menuFile.getParentFile().getAbsolutePath());
            } else {
                logger.trace("Desktop directory is exists.");
            }
            if (menuFile.exists()) {
                menuFile.delete();
            }
            FileWriter fw = null;
            try {
                fw = new FileWriter(menuFile);
                fw.write("[Desktop Entry]");
                logger.trace("Write => [Desktop Entry]");
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
                fw.write("Type=" + type);
                logger.trace("Write => Type=" + type);
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
                fw.write("Version=" + this.LINUX_MENU_VERSION);
                logger.trace("Write => Version=" + this.LINUX_MENU_VERSION);
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
                fw.write("Name=" + this.LINUX_MENU_NAME);
                logger.trace("Write => Name=" + this.LINUX_MENU_NAME);
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
                fw.write("Comment=" + this.LINUX_MENU_COMMENT);
                logger.trace("Write => Comment=" + this.LINUX_MENU_COMMENT);
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
                fw.write("Icon=" + menuIconPath);
                logger.trace("Write => Icon=" + menuIconPath);
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
            }
            catch (IOException e) {
                logger.error("Can not write linux short cut menu file==>" + e.getMessage());
                logger.throwing((Throwable)e);
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        logger.error("Can not write linux short cut menu file==>" + e.getMessage());
                        logger.throwing((Throwable)e);
                    }
                }
            }
        } else {
            logger.error("Already called createMenuShortCut method.");
        }
    }

    public void createShorts() {
        if (PlatformUtil.isLinux()) {
            this.createLinuxShortcut();
        } else if (PlatformUtil.isWindows()) {
            this.createWindowsShortcut();
        } else if (PlatformUtil.isMacOS()) {
            this.createMacOSShortcut();
        }
    }

    private void createMacOSShortcut() {
        ArrayList<Shortcut> loadShortFile = this.loadShortFile();
        if (loadShortFile != null && loadShortFile.size() > 0) {
            for (Shortcut shortcut : loadShortFile) {
                logger.trace((Object)shortcut);
                this.writeShortCutFileAndMakeShortCutMacOS(shortcut);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeShortCutFileAndMakeShortCutMacOS(Shortcut shortcut) {
        String exec = shortcut.getExec();
        File tempInstalled = new File(this.INSTALLED_DIRECTORY);
        String installedDirName = tempInstalled.getName();
        String shortcutPath = "";
        File shortFile = null;
        try {
            shortFile = PathUtil.getTempFileFromResource(this.MACOS_MAKESHORT_SH, "shortcut", ".sh");
        }
        catch (IOException e) {
            logger.throwing((Throwable)e);
        }
        if (shortFile == null || !shortFile.exists()) {
            logger.error("Can not found shortcut.sh");
            return;
        }
        shortcutPath = shortFile.getAbsolutePath();
        shortFile.setExecutable(true);
        String shortcutName = shortcut.getName() != null ? shortcut.getName() : "";
        String cmd = String.format("%s -s \"%s\" -in \"%s\" -n \"%s\"", shortcutPath, exec, installedDirName, shortcutName);
        logger.trace(cmd);
        ProcessBuilder pb = new ProcessBuilder("/bin/sh", "-c", cmd);
        Process proc = null;
        try {
            proc = pb.start();
            BufferedReader read = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = read.readLine()) != null) {
                logger.trace(line.trim());
            }
            proc.waitFor();
            proc.destroy();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
            shortFile.deleteOnExit();
        }
    }

    private void createWindowsShortcut() {
        ArrayList<Shortcut> loadShortFile = this.loadShortFile();
        if (loadShortFile != null && loadShortFile.size() > 0) {
            for (Shortcut shortcut : loadShortFile) {
                logger.trace((Object)shortcut);
                this.writeShortCutFileAndMakeShortCutWindows(shortcut);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeShortCutFileAndMakeShortCutWindows(Shortcut shortcut) {
        File shortFile;
        String shortcutPath;
        String name;
        String icon;
        String exec;
        block22: {
            exec = shortcut.getExec();
            icon = shortcut.getIcon();
            name = shortcut.getName();
            shortcutPath = "";
            shortFile = new File("./shortcut.vbs");
            InputStream resourceAsStream = this.getClass().getResourceAsStream(this.WINDOWS_MAKESHORT_VBS);
            boolean isReturn = false;
            try {
                FileUtil.writeFileFromInputStream(resourceAsStream, shortFile);
            }
            catch (IOException e1) {
                logger.throwing((Throwable)e1);
                isReturn = true;
            }
            finally {
                if (resourceAsStream != null) {
                    try {
                        resourceAsStream.close();
                    }
                    catch (IOException e) {
                        logger.throwing((Throwable)e);
                    }
                }
                if (!isReturn) break block22;
                return;
            }
        }
        if (shortFile == null || !shortFile.exists()) {
            logger.error("Can not found shortcut.vbs");
            return;
        }
        shortcutPath = shortFile.getAbsolutePath();
        String cmd = null;
        cmd = name.toLowerCase().equals("tizen studio") || name.toLowerCase().contains("tizen ide") ? String.format("wscript.exe %s /target:\"%s\" /icon:\"%s\" /shortcut:\"%s\" /subdir1:\"false\"", shortcutPath, exec, icon, name) : String.format("wscript.exe %s /target:\"%s\" /icon:\"%s\" /shortcut:\"%s\"", shortcutPath, exec, icon, name);
        logger.trace(cmd);
        ProcessBuilder pb = new ProcessBuilder("cmd.exe", "/C", cmd);
        Process proc = null;
        try {
            proc = pb.start();
            BufferedReader read = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = read.readLine()) != null) {
                logger.trace(line.trim());
            }
            proc.waitFor();
            proc.destroy();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
            shortFile.deleteOnExit();
        }
    }

    private void createLinuxShortcut() {
        if (!this.isMenuCreated) {
            logger.error("Shortcut menu directory is not exists.");
        } else {
            logger.trace("Shortcut menu directory is exists.");
            ArrayList<Shortcut> loadShortFile = this.loadShortFile();
            if (loadShortFile != null && loadShortFile.size() > 0) {
                logger.trace("Short list size => " + loadShortFile.size());
                logger.trace("Short objects => " + loadShortFile);
                this.writeShortCutFileAndMakeShortCutLinux(loadShortFile);
            } else {
                logger.trace("No files to make shortcut");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeShortCutFileAndMakeShortCutLinux(ArrayList<Shortcut> loadShortFile) {
        String parentDir = PathUtil.getFromHome(this.LINUX_DESKTOP_APPLICATION_PATH);
        for (Shortcut item : loadShortFile) {
            logger.trace("Short => " + item.getShortcutFileName());
            File shortFile = new File(parentDir, item.getShortcutFileName());
            if (shortFile.exists()) {
                shortFile.delete();
            }
            FileWriter fw = null;
            try {
                fw = new FileWriter(shortFile);
                fw.write("[Desktop Entry]");
                logger.trace("Write => [Desktop Entry]");
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
                fw.write("Encoding=" + item.getEncoding());
                logger.trace("Write => Encoding=" + item.getEncoding());
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
                fw.write("Type=" + item.getType());
                logger.trace("Write => Type=" + item.getType());
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
                fw.write("Terminal=" + item.getTerminal());
                logger.trace("Write => Terminal=" + item.getTerminal());
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
                fw.write("StartupNotify=" + item.getStartUpNotify());
                logger.trace("Write => StartupNotify=" + item.getStartUpNotify());
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
                fw.write("NoDisplay=" + item.getNoDisplay());
                logger.trace("Write => NoDisplay=" + item.getNoDisplay());
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
                fw.write("Categories=" + item.getCategory());
                logger.trace("Write => Categories=" + item.getCategory());
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
                fw.write("Version=" + item.getVersion());
                logger.trace("Write => Version=" + item.getVersion());
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
                fw.write("Comment=" + item.getComment());
                logger.trace("Write => Comment=" + item.getComment());
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
                fw.write("Name=" + item.getName());
                logger.trace("Write => Name=" + item.getName());
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
                fw.write("Icon=" + item.getIcon());
                logger.trace("Write => Icon=" + item.getIcon());
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
                fw.write("Exec=\"" + item.getExec() + "\"");
                logger.trace("Write => Exec=\"" + item.getExec() + "\"");
                fw.write(LINE_SPERATOR);
                logger.trace("Write => lineseperator");
                fw.close();
                String appDir = PathUtil.getFromHome(this.LINUX_DESKTOP_APPLICATION_PATH);
                this.registerShortcutLinux(shortFile, appDir);
            }
            catch (IOException e) {
                logger.throwing((Throwable)e);
            }
            finally {
                if (fw == null) continue;
                try {
                    fw.close();
                }
                catch (IOException e) {
                    logger.throwing((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerShortcutLinux(File shortFile, String menuDir) {
        String cmd = "xdg-desktop-menu install " + menuDir + " " + shortFile.getAbsolutePath();
        ProcessBuilder pb = new ProcessBuilder("/bin/sh", "-c", cmd);
        Process proc = null;
        try {
            proc = pb.start();
            BufferedReader read = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = read.readLine()) != null) {
                logger.trace(line.trim());
            }
            proc.waitFor();
            proc.destroy();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            logger.throwing((Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
            logger.throwing((Throwable)e);
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Shortcut> loadShortFile() {
        logger.trace("loadShortFile start");
        ArrayList<Shortcut> shortcutLinuxList = new ArrayList<Shortcut>();
        File shortInfoFile = new File(PathUtil.get(this.INSTALLED_DIRECTORY, this.INFO_DIRECTORY, this.SHORTCUT_INFO_FILE_NAME));
        if (!shortInfoFile.exists()) {
            logger.error("Shortcut info file is not exists.");
            return null;
        }
        logger.trace("Shortcut info file is exists.");
        FileImageInputStream fiis = null;
        try {
            fiis = new FileImageInputStream(shortInfoFile);
            String readLine = "";
            while ((readLine = fiis.readLine()) != null) {
                if (readLine == null || readLine.length() <= 0) continue;
                logger.trace(readLine);
                Shortcut scl = new Shortcut();
                this.readAndSetShortCut(scl, readLine);
                while ((readLine = fiis.readLine()) != null && readLine.length() != 0) {
                    logger.trace(readLine);
                    this.readAndSetShortCut(scl, readLine);
                }
                shortcutLinuxList.add(scl);
            }
        }
        catch (FileNotFoundException e) {
            logger.throwing((Throwable)e);
        }
        catch (IOException e) {
            logger.throwing((Throwable)e);
        }
        finally {
            try {
                if (fiis != null) {
                    fiis.close();
                }
            }
            catch (IOException e) {
                logger.throwing((Throwable)e);
            }
        }
        logger.trace("loadShortFile end");
        return shortcutLinuxList;
    }

    private void readAndSetShortCut(Shortcut scl, String readLine) {
        if (readLine == null) {
            return;
        }
        if (readLine.startsWith("SHORTCUT_ICON_FILE_PATH")) {
            scl.setIcon(this.config.getInstallDirectory() + File.separator + readLine.split("=")[1].trim());
        } else if (readLine.startsWith("SHORTCUT_NAME")) {
            scl.setName(readLine.split("=")[1].trim());
        } else if (readLine.startsWith("SHORTCUT_COMMENT")) {
            scl.setComment(readLine.split("=")[1].trim());
        } else if (readLine.startsWith("SHORTCUT_EXECUTE_FILE_PATH")) {
            scl.setExec(this.config.getInstallDirectory() + File.separator + readLine.split("=")[1].trim());
        } else if (readLine.startsWith("SHORTCUT_FILE_NAME")) {
            scl.setShortcutFileName(readLine.split("=")[1].trim());
        }
    }
}

