set WshShell = WScript.CreateObject("WScript.Shell")
Set ShApp = CreateObject("Shell.Application")
Set FSO = CreateObject("Scripting.FileSystemObject")

programsPath = wshShell.SpecialFolders("Programs")
TizenSDKPath = programsPath & "\Tizen Studio"

set objFSO = CreateObject("Scripting.FileSystemObject")
if not objFSO.FolderExists(TizenSDKPath) Then
	objFSO.CreateFolder(TizenSDKPath)
End If

TizenToolPath = TizenSDKPath &"\Tools"

set objFSO2 = CreateObject("Scripting.FileSystemObject")
if not objFSO2.FolderExists(TizenToolPath) Then
	objFSO2.CreateFolder(TizenToolPath)
End If

subdir1 = Wscript.Arguments.Named("subdir1")

if subdir1 = true Then		
	TizenSDKPath = TizenToolPath
end if

if subdir1 = "" Then
	TizenSDKPath = TizenToolPath
end if


linkFilePath = TizenSDKPath & "\" & Wscript.Arguments.Named("shortcut") & ".lnk"

filename = Wscript.Arguments.Named("target")
partner = Wscript.Arguments.Named("partnerSdk")
iconVar = Wscript.Arguments.Named("icon")

'Remove existing shortcut

set shortcut_folder = objFSO.getFolder(TizenSDKPath).Files
For Each f In shortcut_folder  
  set tempshortcut = wshShell.CreateShortcut(objFSO.GetAbsolutePathName(f))
  if StrComp(  Lcase(tempshortcut.TargetPath) , Lcase(filename)) = 0 Then
    if objFSO.FileExists(objFSO.GetAbsolutePathName(f)) then
  	Set aFile = objFSO.GetFile(objFSO.GetAbsolutePathName(f))
  	aFile.Delete
  end if
end if  
next

tmplnk = WshShell.ExpandEnvironmentStrings("%temp%\") _
	& FSO.GetTempName() & ".lnk"

WshShell.CreateShortcut(tmplnk).Save()
Set testObject = ShApp.NameSpace(0).ParseName(tmplnk)
 
if not isNull(testObject) Then
	set filesys = CreateObject("Scripting.FileSystemObject")
	Set oShellLink = ShApp.NameSpace(0).ParseName(tmplnk).GetLink
	oShellLink.Path = filename
	oShellLink.SetIconLocation iconVar, 0
	oShellLink.WorkingDirectory = filesys.GetParentFolderName(filename)
	oShellLink.Save(linkFilePath)
end if	

FSO.DeleteFile tmplnk, True