/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.referencecounter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.samsung.memoryanalysis.context.Context;
import com.samsung.memoryanalysis.referencecounter.UnreachabilityAwareAnalysis;
import com.samsung.memoryanalysis.traceparser.IIDMap;
import com.samsung.memoryanalysis.traceparser.Timer;
import com.samsung.memoryanalysis.traceparser.TraceAnalysisRunner;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Set;

public class UnreachabilityTraceWriter
implements UnreachabilityAwareAnalysis<Void> {
    private final PrintStream out;
    private final Gson json;
    private Timer timer;
    private long counter = 0L;

    public UnreachabilityTraceWriter(OutputStream out) {
        this.out = new PrintStream(out);
        this.json = new GsonBuilder().create();
    }

    @Override
    public void functionEnter(int iid, int funId, int callSiteIID, Context newContext, long time) {
        this.trace(TraceAnalysisRunner.TraceEntry.FUNCTION_ENTER.ordinal(), iid, funId, callSiteIID);
    }

    private void trace(Object ... args) {
        if (!args[0].equals(TraceAnalysisRunner.TraceEntry.UNREACHABLE.ordinal())) {
            assert (this.timer.currentTime() == this.counter);
            ++this.counter;
        }
        this.out.println(this.json.toJson((Object)args));
    }

    @Override
    public void functionExit(int iid, Context functionContext, Set<String> unReferenced, long time) {
        this.trace(TraceAnalysisRunner.TraceEntry.FUNCTION_EXIT.ordinal(), iid);
    }

    @Override
    public void init(Timer t, IIDMap iidMap) {
        this.timer = t;
    }

    @Override
    public void create(int iid, int objectId, long time, boolean isDom) {
        this.trace(TraceAnalysisRunner.TraceEntry.CREATE_OBJ.ordinal(), iid, objectId);
    }

    @Override
    public void createFun(int iid, int objectId, int prototypeId, int functionEnterIID, Set<String> namesReferencedByClosures, Context context, long time) {
        this.trace(TraceAnalysisRunner.TraceEntry.CREATE_FUN.ordinal(), iid, functionEnterIID, objectId);
    }

    @Override
    public void unreachableObject(int iid, int objectId, long time, int shallowSize) {
        assert (time <= this.counter);
        this.trace(TraceAnalysisRunner.TraceEntry.UNREACHABLE.ordinal(), iid, objectId, time);
    }

    @Override
    public void unreachableContext(int iid, Context ctx, long time) {
    }

    @Override
    public void lastUse(int objectId, int iid, long time) {
        this.trace(TraceAnalysisRunner.TraceEntry.LAST_USE.ordinal(), objectId, time, iid);
    }

    @Override
    public Void endExecution(long time) {
        this.out.close();
        return null;
    }

    @Override
    public void domRoot(int nodeId) {
        this.trace(TraceAnalysisRunner.TraceEntry.DOM_ROOT.ordinal(), nodeId);
    }

    @Override
    public void addDOMChild(int parentId, int childId, long time) {
        this.trace(TraceAnalysisRunner.TraceEntry.ADD_DOM_CHILD.ordinal(), parentId, childId);
    }

    @Override
    public void removeDOMChild(int parentId, int childId, long time) {
        this.trace(TraceAnalysisRunner.TraceEntry.REMOVE_DOM_CHILD.ordinal(), parentId, childId);
    }

    @Override
    public void putField(int iid, int baseId, String offset, int objectId) {
        this.trace(TraceAnalysisRunner.TraceEntry.PUTFIELD.ordinal(), iid, baseId, offset, objectId);
    }

    @Override
    public void write(int iid, String name, int objectId) {
        this.trace(TraceAnalysisRunner.TraceEntry.WRITE.ordinal(), iid, name, objectId);
    }

    @Override
    public void declare(int iid, String name, int objectId) {
        this.trace(TraceAnalysisRunner.TraceEntry.DECLARE.ordinal(), iid, name, objectId);
    }

    @Override
    public void updateIID(int objId, int newIID) {
        this.trace(TraceAnalysisRunner.TraceEntry.UPDATE_IID.ordinal(), objId, newIID);
    }

    @Override
    public void returnStmt(int objId) {
        this.trace(TraceAnalysisRunner.TraceEntry.RETURN.ordinal(), objId);
    }

    @Override
    public void debug(int iid, int oid) {
        this.trace(TraceAnalysisRunner.TraceEntry.DEBUG.ordinal(), iid, oid);
    }

    @Override
    public void scriptEnter(int iid, String filename) {
        this.trace(TraceAnalysisRunner.TraceEntry.SCRIPT_ENTER.ordinal(), iid, filename);
    }

    @Override
    public void scriptExit(int iid) {
        this.trace(TraceAnalysisRunner.TraceEntry.SCRIPT_EXIT.ordinal(), iid);
    }

    @Override
    public void topLevelFlush(int iid) {
        this.trace(TraceAnalysisRunner.TraceEntry.TOP_LEVEL_FLUSH.ordinal(), iid);
    }

    @Override
    public void addToChildSet(int iid, int parentId, String name, int childId) {
        this.trace(TraceAnalysisRunner.TraceEntry.ADD_TO_CHILD_SET.ordinal(), iid, parentId, name, childId);
    }

    @Override
    public void removeFromChildSet(int iid, int parentId, String name, int childId) {
        this.trace(TraceAnalysisRunner.TraceEntry.REMOVE_FROM_CHILD_SET.ordinal(), iid, parentId, name, childId);
    }
}

