/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jsa.safe.bugdetecter.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.tizen.web.jsa.safe.bugdetecter.core.BugItem;
import org.tizen.web.jsa.safe.bugdetecter.ui.model.JSFile;
import org.tizen.web.jsa.safe.bugdetecter.ui.model.JSFileContentProvider;
import org.tizen.web.jsa.safe.bugdetecter.ui.model.JSFileLabelProvider;
import org.tizen.web.jsa.safe.bugdetecter.ui.model.JSFileModel;

public class AnalysisResultDialog
extends TitleAreaDialog {
    private TreeViewer viewer;
    private JSFileModel treeData;
    private IProject project;
    private ArrayList<BugItem> jsList;
    private int bug_state;

    public AnalysisResultDialog(Shell parentShell, IProject project, ArrayList<BugItem> arrayList, IPath logFile) {
        super(parentShell);
        this.bug_state = this.validateBugList(arrayList);
        this.jsList = arrayList;
        this.project = project;
    }

    public void initDialogLayout(Shell shell) {
        this.setTitle("JavaScript Bug Detector Result");
        this.setMessage("Static analysis for Web App Application.", 0);
    }

    protected Control createDialogArea(Composite parent) {
        this.initDialogLayout(parent.getShell());
        Composite area = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(area, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        GridLayout gl_composite = new GridLayout(2, false);
        gl_composite.marginWidth = 7;
        gl_composite.marginHeight = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        Label lblProjectState = new Label(composite, 0);
        GridData gd_lblProjectState = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_lblProjectState.verticalIndent = 2;
        gd_lblProjectState.widthHint = 197;
        lblProjectState.setLayoutData((Object)gd_lblProjectState);
        Composite container = new Composite(area, 0);
        GridLayout gl_container = new GridLayout(1, false);
        gl_container.marginHeight = 0;
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.heightHint = 1;
        gd_container.widthHint = 1;
        container.setLayoutData((Object)gd_container);
        this.viewer = new TreeViewer(container, 2816);
        Tree tree = this.viewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewer.setContentProvider((IContentProvider)new JSFileContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new JSFileLabelProvider());
        this.viewer.setAutoExpandLevel(2);
        StringBuilder sb = new StringBuilder();
        if (this.bug_state == 0) {
            this.treeData = new JSFileModel(this.project);
            this.treeData.setJSBugList(this.jsList);
            this.viewer.setInput((Object)this.treeData);
        } else if (this.bug_state == -2) {
            this.treeData = new JSFileModel(this.project);
            this.treeData.setJSBugList(this.jsList);
            this.viewer.setInput((Object)this.treeData);
        } else if (this.bug_state == -1) {
            this.treeData = new JSFileModel(this.project);
            this.treeData.addJSBug(new BugItem(100, 0, "Analysis Error! check *.log files.", "", 0));
            this.viewer.setInput((Object)this.treeData);
        }
        sb.append(this.project.getName());
        sb.append(" : ");
        sb.append(this.treeData.getErrorsCount());
        sb.append(" errors, ");
        sb.append(this.treeData.getWarningsCount());
        sb.append(" warnings");
        lblProjectState.setText(sb.toString());
        this.viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                IStructuredSelection selection;
                if (e.keyCode == 127 && (selection = (IStructuredSelection)AnalysisResultDialog.this.viewer.getSelection()).getFirstElement() instanceof JSFile) {
                    JSFile cfr_ignored_0 = (JSFile)selection.getFirstElement();
                }
            }
        });
        this.viewer.getTree().setFocus();
        return area;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(680, 400);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private int validateBugList(ArrayList<BugItem> arrayList) {
        if (arrayList == null) {
            return -1;
        }
        if (arrayList.size() == 0) {
            return 0;
        }
        return 0;
    }
}

