/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import edu.rice.cs.plt.tuple.Option;
import java.util.List;
import kr.ac.kaist.jsaf.nodes.IRAbstractNodeVisitor;
import kr.ac.kaist.jsaf.nodes.IRAbstractNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.IRAssign;
import kr.ac.kaist.jsaf.nodes.IRExpr;
import kr.ac.kaist.jsaf.nodes.IRId;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.IRSpanInfo;
import kr.ac.kaist.jsaf.nodes.TreeWalker;

public class IRArgs
extends IRAssign {
    private final List<Option<IRExpr>> _elements;

    public IRArgs(IRSpanInfo in_info, IRId in_lhs, List<Option<IRExpr>> in_elements) {
        super(in_info, in_lhs);
        if (in_elements == null) {
            throw new IllegalArgumentException("Parameter 'elements' to the IRArgs constructor was null");
        }
        this._elements = in_elements;
    }

    public final List<Option<IRExpr>> getElements() {
        return this._elements;
    }

    @Override
    public <RetType> RetType accept(IRAbstractNodeVisitor<RetType> visitor) {
        return visitor.forIRArgs(this);
    }

    @Override
    public <RetType> RetType accept(IRNodeVisitor<RetType> visitor) {
        return visitor.forIRArgs(this);
    }

    @Override
    public void accept(IRAbstractNodeVisitor_void visitor) {
        visitor.forIRArgs(this);
    }

    @Override
    public void accept(IRNodeVisitor_void visitor) {
        visitor.forIRArgs(this);
    }

    public boolean equals(Object obj) {
        List<Option<IRExpr>> casted_elements;
        IRId casted_lhs;
        IRSpanInfo casted_info;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        IRArgs casted = (IRArgs)obj;
        IRSpanInfo temp_info = this.getInfo();
        if (temp_info != (casted_info = casted.getInfo()) && !temp_info.equals(casted_info)) {
            return false;
        }
        IRId temp_lhs = this.getLhs();
        if (temp_lhs != (casted_lhs = casted.getLhs()) && !temp_lhs.equals(casted_lhs)) {
            return false;
        }
        List<Option<IRExpr>> temp_elements = this.getElements();
        return temp_elements == (casted_elements = casted.getElements()) || temp_elements.equals(casted_elements);
    }

    @Override
    public int generateHashCode() {
        int code = this.getClass().hashCode();
        IRSpanInfo temp_info = this.getInfo();
        code ^= temp_info.hashCode();
        IRId temp_lhs = this.getLhs();
        code ^= temp_lhs.hashCode();
        List<Option<IRExpr>> temp_elements = this.getElements();
        return code ^= temp_elements.hashCode();
    }

    protected IRArgs() {
        this._elements = null;
    }

    @Override
    public void walk(TreeWalker w) {
        if (w.visitNode(this, "IRArgs", 3)) {
            List<Option<IRExpr>> temp_elements;
            IRId temp_lhs;
            IRSpanInfo temp_info = this.getInfo();
            if (w.visitNodeField("info", temp_info)) {
                temp_info.walk(w);
                w.endNodeField("info", temp_info);
            }
            if (w.visitNodeField("lhs", temp_lhs = this.getLhs())) {
                temp_lhs.walk(w);
                w.endNodeField("lhs", temp_lhs);
            }
            if (w.visitNodeField("elements", temp_elements = this.getElements())) {
                if (w.visitIterated(temp_elements)) {
                    int i_temp_elements = 0;
                    for (Option<IRExpr> elt_temp_elements : temp_elements) {
                        if (w.visitIteratedElement(i_temp_elements, elt_temp_elements)) {
                            if (elt_temp_elements == null) {
                                w.visitNull();
                            } else if (elt_temp_elements.isNone()) {
                                w.visitEmptyOption(elt_temp_elements);
                            } else if (w.visitNonEmptyOption(elt_temp_elements)) {
                                IRExpr elt_elt_temp_elements = (IRExpr)elt_temp_elements.unwrap();
                                if (elt_elt_temp_elements == null) {
                                    w.visitNull();
                                } else {
                                    elt_elt_temp_elements.walk(w);
                                }
                                w.endNonEmptyOption(elt_temp_elements);
                            }
                        }
                        ++i_temp_elements;
                    }
                    w.endIterated(temp_elements, i_temp_elements);
                }
                w.endNodeField("elements", temp_elements);
            }
            w.endNode(this, "IRArgs", 3);
        }
    }
}

