/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.io;

import edu.rice.cs.plt.io.DirectInputStream;
import edu.rice.cs.plt.io.DirectOutputStream;
import edu.rice.cs.plt.io.ExpandingBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandingByteBuffer
extends ExpandingBuffer<byte[]> {
    private boolean _eof = false;

    public synchronized void end() {
        this._eof = true;
        this.notifyAll();
    }

    public synchronized boolean isEnded() {
        return this._eof;
    }

    @Override
    protected byte[] allocateBuffer(int size) {
        return new byte[size];
    }

    public DirectOutputStream outputStream() {
        return new DirectOutputStream(){

            public void close() {
            }

            public void flush() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(int b) throws IOException {
                ExpandingByteBuffer expandingByteBuffer = ExpandingByteBuffer.this;
                synchronized (expandingByteBuffer) {
                    if (ExpandingByteBuffer.this._eof) {
                        throw new IOException("Buffer has been ended");
                    }
                    ExpandingByteBuffer.this.allocate();
                    ((byte[])ExpandingByteBuffer.this.lastBuffer())[ExpandingByteBuffer.this.lastIndex()] = (byte)b;
                    ExpandingByteBuffer.this.recordWrite(1L);
                    ExpandingByteBuffer.this.notifyAll();
                }
            }

            public void write(byte[] bbuf) throws IOException {
                this.write(bbuf, 0, bbuf.length);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(byte[] bbuf, int off, int bytes) throws IOException {
                ExpandingByteBuffer expandingByteBuffer = ExpandingByteBuffer.this;
                synchronized (expandingByteBuffer) {
                    if (ExpandingByteBuffer.this._eof) {
                        throw new IOException("Buffer has been ended");
                    }
                    while (bytes > 0) {
                        int space = ExpandingByteBuffer.this.allocate();
                        int toWrite = space > bytes ? bytes : space;
                        System.arraycopy(bbuf, off, ExpandingByteBuffer.this.lastBuffer(), ExpandingByteBuffer.this.lastIndex(), toWrite);
                        ExpandingByteBuffer.this.recordWrite(toWrite);
                        bytes -= toWrite;
                    }
                    ExpandingByteBuffer.this.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int write(InputStream in, int bytes) throws IOException {
                if (bytes == 0) {
                    return 0;
                }
                ExpandingByteBuffer expandingByteBuffer = ExpandingByteBuffer.this;
                synchronized (expandingByteBuffer) {
                    if (ExpandingByteBuffer.this._eof) {
                        throw new IOException("Buffer has been ended");
                    }
                    int bytesRead = 0;
                    int totalRead = 0;
                    while (bytes > 0 && bytesRead >= 0) {
                        int space = ExpandingByteBuffer.this.allocate();
                        bytesRead = in.read((byte[])ExpandingByteBuffer.this.lastBuffer(), ExpandingByteBuffer.this.lastIndex(), space);
                        if (bytesRead < 0) continue;
                        ExpandingByteBuffer.this.recordWrite(bytesRead);
                        bytes -= bytesRead;
                        totalRead += bytesRead;
                    }
                    ExpandingByteBuffer.this.notifyAll();
                    if (totalRead == 0) {
                        return -1;
                    }
                    return totalRead;
                }
            }

            public int write(InputStream in, int bytes, int bufferSize) throws IOException {
                return this.write(in, bytes);
            }

            public int write(InputStream in, int bytes, byte[] buffer) throws IOException {
                return this.write(in, bytes);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int writeAll(InputStream in) throws IOException {
                ExpandingByteBuffer expandingByteBuffer = ExpandingByteBuffer.this;
                synchronized (expandingByteBuffer) {
                    int bytesRead;
                    long totalRead = 0L;
                    do {
                        int space = ExpandingByteBuffer.this.allocate();
                        bytesRead = in.read((byte[])ExpandingByteBuffer.this.lastBuffer(), ExpandingByteBuffer.this.lastIndex(), space);
                        if (bytesRead < 0) continue;
                        ExpandingByteBuffer.this.recordWrite(bytesRead);
                        totalRead += (long)bytesRead;
                    } while (bytesRead >= 0);
                    ExpandingByteBuffer.this.notifyAll();
                    if (totalRead == 0L) {
                        return -1;
                    }
                    if (totalRead > Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    return (int)totalRead;
                }
            }

            public int writeAll(InputStream in, int bufferSize) throws IOException {
                return this.writeAll(in);
            }

            public int writeAll(InputStream in, byte[] buffer) throws IOException {
                return this.writeAll(in);
            }
        };
    }

    public DirectInputStream inputStream() {
        return new DirectInputStream(){

            public void close() {
            }

            public int available() {
                long result = ExpandingByteBuffer.this.size();
                return result < Integer.MAX_VALUE ? (int)result : Integer.MAX_VALUE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read() throws IOException {
                ExpandingByteBuffer expandingByteBuffer = ExpandingByteBuffer.this;
                synchronized (expandingByteBuffer) {
                    this.waitForInput();
                    if (ExpandingByteBuffer.this.isEmpty()) {
                        return -1;
                    }
                    byte result = ((byte[])ExpandingByteBuffer.this.firstBuffer())[ExpandingByteBuffer.this.firstIndex()];
                    ExpandingByteBuffer.this.recordRead(1L);
                    ExpandingByteBuffer.this.deallocate();
                    return result;
                }
            }

            public int read(byte[] bbuf) throws IOException {
                return this.read(bbuf, 0, bbuf.length);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(byte[] bbuf, int offset, int bytes) throws IOException {
                if (bytes <= 0) {
                    return 0;
                }
                ExpandingByteBuffer expandingByteBuffer = ExpandingByteBuffer.this;
                synchronized (expandingByteBuffer) {
                    this.waitForInput();
                    if (ExpandingByteBuffer.this.isEmpty()) {
                        return -1;
                    }
                    int totalRead = 0;
                    while (bytes > 0 && !ExpandingByteBuffer.this.isEmpty()) {
                        int inFirstBuffer = ExpandingByteBuffer.this.elementsInFirstBuffer();
                        int toRead = inFirstBuffer > bytes ? bytes : inFirstBuffer;
                        System.arraycopy(ExpandingByteBuffer.this.firstBuffer(), ExpandingByteBuffer.this.firstIndex(), bbuf, offset, toRead);
                        ExpandingByteBuffer.this.recordRead(toRead);
                        bytes -= toRead;
                        totalRead += toRead;
                        ExpandingByteBuffer.this.deallocate();
                    }
                    return totalRead;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(OutputStream out, int bytes) throws IOException {
                if (bytes <= 0) {
                    return 0;
                }
                ExpandingByteBuffer expandingByteBuffer = ExpandingByteBuffer.this;
                synchronized (expandingByteBuffer) {
                    this.waitForInput();
                    if (ExpandingByteBuffer.this.isEmpty()) {
                        return -1;
                    }
                    int totalRead = 0;
                    while (bytes > 0 && !ExpandingByteBuffer.this.isEmpty()) {
                        int inFirstBuffer = ExpandingByteBuffer.this.elementsInFirstBuffer();
                        int toRead = inFirstBuffer > bytes ? bytes : inFirstBuffer;
                        out.write((byte[])ExpandingByteBuffer.this.firstBuffer(), ExpandingByteBuffer.this.firstIndex(), toRead);
                        ExpandingByteBuffer.this.recordRead(toRead);
                        bytes -= toRead;
                        totalRead += toRead;
                        ExpandingByteBuffer.this.deallocate();
                    }
                    return totalRead;
                }
            }

            public int read(OutputStream out, int bytes, int bufferSize) throws IOException {
                return this.read(out, bytes);
            }

            public int read(OutputStream out, int bytes, byte[] buffer) throws IOException {
                return this.read(out, bytes);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int readAll(OutputStream out) throws IOException {
                ExpandingByteBuffer expandingByteBuffer = ExpandingByteBuffer.this;
                synchronized (expandingByteBuffer) {
                    long totalRead = 0L;
                    do {
                        this.waitForInput();
                        while (!ExpandingByteBuffer.this.isEmpty()) {
                            int toRead = ExpandingByteBuffer.this.elementsInFirstBuffer();
                            out.write((byte[])ExpandingByteBuffer.this.firstBuffer(), ExpandingByteBuffer.this.firstIndex(), toRead);
                            ExpandingByteBuffer.this.recordRead(toRead);
                            totalRead += (long)toRead;
                            ExpandingByteBuffer.this.deallocate();
                        }
                    } while (!ExpandingByteBuffer.this._eof);
                    if (totalRead == 0L) {
                        return -1;
                    }
                    if (totalRead > Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    return (int)totalRead;
                }
            }

            public int readAll(OutputStream out, int bufferSize) throws IOException {
                return this.readAll(out);
            }

            public int readAll(OutputStream out, byte[] buffer) throws IOException {
                return this.readAll(out);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long skip(long bytes) throws IOException {
                if (bytes <= 0L) {
                    return 0L;
                }
                ExpandingByteBuffer expandingByteBuffer = ExpandingByteBuffer.this;
                synchronized (expandingByteBuffer) {
                    this.waitForInput();
                    long size = ExpandingByteBuffer.this.size();
                    if (bytes > size) {
                        bytes = size;
                    }
                    ExpandingByteBuffer.this.recordRead(bytes);
                    while (ExpandingByteBuffer.this.deallocate()) {
                    }
                    return bytes;
                }
            }

            private void waitForInput() throws InterruptedIOException {
                while (!ExpandingByteBuffer.this._eof && ExpandingByteBuffer.this.isEmpty()) {
                    try {
                        ExpandingByteBuffer.this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                }
            }
        };
    }
}

