/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
///<reference path='../ts-declarations/node.d.ts' />
///<reference path='../ts-declarations/Q.d.ts' />
var fs = require('fs');
var cp = require('child_process');
var path = require('path');
var Q = require('q');
;
(function (IssueType) {
    IssueType[IssueType["LEAK"] = 0] = "LEAK";
    IssueType[IssueType["OBJINLINE"] = 1] = "OBJINLINE";
    IssueType[IssueType["STACKALLOC"] = 2] = "STACKALLOC";
})(exports.IssueType || (exports.IssueType = {}));
var IssueType = exports.IssueType;
function getOutputAsArray(output) {
    var outputArr = [], i = 0;
    // current output objectInfo maps sites to info.  change it to an array
    var objInfo = output.objectInfo;
    Object.keys(objInfo).forEach(function (siteName) {
        outputArr[i] = objInfo[siteName];
        outputArr[i].siteName = siteName;
        i++;
    });
    return outputArr;
}
var NUM_ISSUES_TO_SHOW = 10;
function extractIssues(allInfo, filterFun, sortFun, issueGen) {
    var filteredAndSorted = allInfo.filter(filterFun).sort(sortFun);
    var result = [];
    for (var i = 0; i < NUM_ISSUES_TO_SHOW && i < filteredAndSorted.length; i++) {
        var site = filteredAndSorted[i];
        result.push(issueGen(site));
    }
    return result;
}
function getEnhancedTraceOutput(enhancedTraceFile) {
    var cliArgs = ['node', 'vanillajs/mem.js', enhancedTraceFile];
    var execPromise = Q.nfcall(cp.exec, cliArgs.join(' '), { maxBuffer: 1024 * 1024 });
    return execPromise.then(function () {
        console.log("Finished processing enhanced trace");
        var outputFile = path.join(path.dirname(enhancedTraceFile), 'mem_output.json');
        return JSON.parse(String(fs.readFileSync(outputFile)));
    });
}
exports.getEnhancedTraceOutput = getEnhancedTraceOutput;
function computeIssues(enhTraceOutput) {
    var outputArr = getOutputAsArray(enhTraceOutput);
    var result = {};
    result[0 /* LEAK */] = extractIssues(outputArr, function (s) {
        return s.isLeakingDefinitely;
    }, function (s1, s2) {
        return s2.maxAliveCount - s1.maxAliveCount;
    }, function (s) {
        return { site: s.siteName, message: "" };
    });
    result[1 /* OBJINLINE */] = extractIssues(outputArr, function (s) {
        return s.consistentlyPointedBy !== undefined;
    }, function (s1, s2) {
        return s2.total - s1.total;
    }, function (s) {
        return {
            site: s.siteName,
            message: s.consistentlyPointedBy
        };
    });
    result[2 /* STACKALLOC */] = extractIssues(outputArr, function (s) {
        return s.isNonEscaping;
    }, function (s1, s2) {
        return s2.total - s1.total;
    }, function (s) {
        return {
            site: s.siteName,
            message: ""
        };
    });
    return result;
}
exports.computeIssues = computeIssues;
//# sourceMappingURL=issueFinder.js.map