/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.EventCast;

import com.google.protobuf.GeneratedMessage;
import org.json.simple.JSONObject;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.EventCast.EventCastConstants;
import org.tizen.ecp.EventCast.MsgProc_EventCastNtf;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.msg.genmsg.ecs.EcsIds;
import org.tizen.ecp.sock.IMsgProc;
import org.tizen.ecp.sock.MsgMgr;

public class EventCastStatusCLI
extends AbstractEmulatorCLI {
    private int cmdCount = 0;
    private String connectionInfo = "";
    private String connectionStatus = "";
    private String TYPE_TETHERING = "eventcast";
    private MsgProc_EventCastNtf ntf = null;

    public EventCastStatusCLI() {
        this.messageType = this.TYPE_TETHERING;
        this.ntf = new MsgProc_EventCastNtf();
        MsgMgr.getInstance().AddMsgProc(EcsIds.Master_Type.EVENTCAST_NTF, (IMsgProc)this.ntf);
    }

    public void OnEventProc(String string, JSONObject jSONObject) {
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        boolean bl = false;
        if (generatedMessage instanceof Ecs.EventCastNtf) {
            Ecs.EventCastNtf eventCastNtf = (Ecs.EventCastNtf)generatedMessage;
            int n = eventCastNtf.getAction();
            if (n == 1) {
                if (eventCastNtf.hasData()) {
                    this.connectionInfo = eventCastNtf.getData().toStringUtf8();
                }
            } else if (n == 3) {
                if (eventCastNtf.hasData()) {
                    String string2 = eventCastNtf.getData().toStringUtf8();
                    for (EventCastConstants.Connections connections : EventCastConstants.Connections.values()) {
                        if (!string2.equals(connections.getStatusCodeStr())) continue;
                        this.connectionStatus = connections.getStatusDesc();
                    }
                }
                bl = true;
            }
            ++this.cmdCount;
        } else {
            bl = true;
        }
        if (this.cmdCount > 0) {
            if (!this.connectionStatus.isEmpty()) {
                OutputUtil.printOK();
                OutputUtil.printStatus((String)"Status", (String)this.connectionStatus);
                if (!this.connectionInfo.isEmpty()) {
                    OutputUtil.printStatus((String)"IP/Port", (String)this.connectionInfo);
                }
            }
        } else {
            this.returnValue = 128;
            OutputUtil.printFail();
        }
        if (bl) {
            this.clear();
            this.stopRunning();
        }
    }

    public int execute() {
        this.ntf.sendEventCastReq("eventcast", 1, 3);
        this.startRunning();
        return 0;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        OutputUtil.printError((String)"tethering status OnStatusEventProcPB");
    }

    private void clear() {
        this.cmdCount = 0;
        this.connectionInfo = "";
        this.connectionStatus = "";
    }
}

