/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.ecp.VMInfo;
import org.tizen.ecp.dialogs.MessageDialog;
import org.tizen.ecp.nfc.NFCDialog;
import org.tizen.ecp.nfc.NFCErrorString;
import org.tizen.ecp.sdb.IShellOutputReceiver;
import org.tizen.ecp.sdb.MultiLineReceiver;
import org.tizen.ecp.sdb.SDBCommandRejectedException;
import org.tizen.ecp.sdb.SDBHelperUtil;
import org.tizen.ecp.sdb.SDBNotExistException;

public final class FileListingService {
    private static final Pattern sApkPattern = Pattern.compile(".*\\.apk", 2);
    private static final String PM_FULL_LISTING = "pm list packages -f";
    private static final Pattern sPmPattern = Pattern.compile("^package:(.+?)=(.+)$");
    public static final String DIRECTORY_DATA = "data";
    public static final String DIRECTORY_SDCARD = "sdcard";
    public static final String DIRECTORY_MNT = "mnt";
    public static final String DIRECTORY_SYSTEM = "system";
    public static final String DIRECTORY_TEMP = "tmp";
    public static final String DIRECTORY_APP = "app";
    public static final long REFRESH_RATE = 5000L;
    static final long REFRESH_TEST = 4000L;
    public static final int TYPE_FILE = 0;
    public static final int TYPE_DIRECTORY = 1;
    public static final int TYPE_DIRECTORY_LINK = 2;
    public static final int TYPE_BLOCK = 3;
    public static final int TYPE_CHARACTER = 4;
    public static final int TYPE_LINK = 5;
    public static final int TYPE_SOCKET = 6;
    public static final int TYPE_FIFO = 7;
    public static final int TYPE_OTHER = 8;
    public static final int TYPE_ROOT_EMULATOR = 9;
    public static final int TYPE_ROOT_DEVICE = 10;
    public static final String FILE_SEPARATOR = "/";
    private static final String FILE_ROOT = "/";
    private static String LS_COMMAND_TIMESTYLE = " --time-style=long-iso";
    private static String patternPermisions = "([bcdlsp-][-r][-w][-xsS][-r][-w][-xsS][-r][-w][-xstST])";
    private static String patternFilecount = "(\\d{1,})";
    private static String patternOwner = "(\\S+)";
    private static String patternGroup = "(\\S+)";
    private static String patternSize = "([\\d\\s,]*)";
    private static String patternDate = "(\\d{4}-\\d{2}-\\d{2}|[a-zA-Z]{3}\\s+\\d{1,2})";
    private static String patternTime = "(\\d{1,2}:\\d{1,2}|[0-9]{4})";
    private static String patternName = "(.*)";
    private static String patternLs = "^" + patternPermisions + "\\s+" + patternFilecount + "\\s+" + patternOwner + "\\s+" + patternGroup + "\\s+" + patternSize + "\\s+" + patternDate + "\\s+" + patternTime + "\\s" + patternName + "$";
    private static Pattern sLsPattern = Pattern.compile(patternLs);
    private FileEntry mRoot;
    private final ArrayList<Thread> mThreadList = new ArrayList();

    public FileEntry getRoot() {
        if (this.mRoot == null) {
            int n = 9;
            this.mRoot = new FileEntry(null, VMInfo.getInstance().getVMName(), n, true, this);
        }
        return this.mRoot;
    }

    public FileEntry[] getChildren(FileEntry fileEntry, boolean bl, IListingReceiver iListingReceiver) {
        return this.getChildren(fileEntry, bl, iListingReceiver, false);
    }

    public FileEntry[] getChildrenWithAnsicodeColor(FileEntry fileEntry, boolean bl, IListingReceiver iListingReceiver) {
        return this.getChildren(fileEntry, bl, iListingReceiver, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileEntry[] getChildren(final FileEntry fileEntry, boolean bl, final IListingReceiver iListingReceiver, final boolean bl2) {
        if (bl && !fileEntry.needFetch()) {
            return fileEntry.getCachedChildren();
        }
        if (iListingReceiver == null) {
            this.doLs(fileEntry, bl2);
            return fileEntry.getCachedChildren();
        }
        Thread thread = new Thread("ls " + fileEntry.getFullEscapedPath()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                Cloneable cloneable;
                if (FileListingService.this.doLs(fileEntry, bl2)) {
                    return;
                }
                iListingReceiver.setChildren(fileEntry, fileEntry.getCachedChildren());
                FileEntry[] fileEntryArray = fileEntry.getCachedChildren();
                if (fileEntryArray.length > 0 && fileEntryArray[0].isApplicationPackage()) {
                    cloneable = new HashMap();
                    for (FileEntry fileEntry2 : fileEntryArray) {
                        String string = fileEntry2.getFullEscapedPath();
                        ((HashMap)cloneable).put(string, fileEntry2);
                    }
                    object = new MultiLineReceiver((HashMap)cloneable){
                        final /* synthetic */ HashMap val$map;
                        {
                            this.val$map = hashMap;
                        }

                        public void processNewLines(String[] stringArray) {
                            for (String string : stringArray) {
                                FileEntry fileEntry;
                                Matcher matcher;
                                if (string.length() <= 0 || !(matcher = sPmPattern.matcher(string)).matches() || (fileEntry = (FileEntry)this.val$map.get(matcher.group(1))) == null) continue;
                                fileEntry.info = matcher.group(2);
                                iListingReceiver.refreshEntry(fileEntry);
                            }
                        }

                        public boolean isCancelled() {
                            return false;
                        }
                    };
                    String string = FileListingService.PM_FULL_LISTING;
                    try {
                        SDBHelperUtil.getInstance().executeShellCommand(string, (IShellOutputReceiver)object);
                    }
                    catch (SDBNotExistException sDBNotExistException) {
                        new MessageDialog().openWarningDialog(sDBNotExistException.getMessage());
                    }
                    catch (SDBCommandRejectedException sDBCommandRejectedException) {
                        FileListingService.this.errorShowFileBrowser("Emulator is not ready.\nPlease retry when the emulator is ready.");
                    }
                    catch (IOException iOException) {
                        FileListingService.this.errorShowFileBrowser("SDB: " + iOException.getMessage());
                    }
                    catch (Exception exception) {
                        FileListingService.this.errorShowFileBrowser("SDB: " + exception.getMessage());
                        new MessageDialog().openWarningDialog("sdb excute " + string + " failed:" + exception.getMessage());
                    }
                    SDBHelperUtil.getInstance().closeMultiLineReceiver((MultiLineReceiver)object);
                }
                cloneable = FileListingService.this.mThreadList;
                synchronized (cloneable) {
                    FileListingService.this.mThreadList.remove(this);
                    if (FileListingService.this.mThreadList.size() > 0) {
                        object = (Thread)FileListingService.this.mThreadList.get(0);
                        ((Thread)object).start();
                    }
                }
            }
        };
        ArrayList<Thread> arrayList = this.mThreadList;
        synchronized (arrayList) {
            this.mThreadList.add(thread);
            if (this.mThreadList.size() == 1) {
                thread.start();
            }
        }
        return null;
    }

    private void errorShowFileBrowser(String string) {
        NFCDialog.openErrorDialog(null, NFCErrorString.FileBrowserException + string);
    }

    private void closeReceiver(LsReceiver lsReceiver) {
        try {
            if (lsReceiver != null) {
                lsReceiver.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private boolean doLs(FileEntry fileEntry, boolean bl) {
        ArrayList<FileEntry> arrayList = new ArrayList<FileEntry>();
        LsReceiver lsReceiver = null;
        try {
            String string = null;
            String string2 = "";
            string = fileEntry.getType() == 5 || fileEntry.getType() == 2 ? (fileEntry.getLinkFullPath().charAt(0) == '/' ? "ls -l " + this.getStringWithDoubleQuote(fileEntry.getLinkFullPath()) : "ls -l " + this.getStringWithDoubleQuote("/" + fileEntry.getLinkFullPath())) : "ls -l " + this.getStringWithDoubleQuote("/" + fileEntry.getFullEscapedPath());
            if (!bl) {
                string2 = " 2> /dev/null | tee /dev/null";
            }
            lsReceiver = new LsReceiver(fileEntry, arrayList);
            SDBHelperUtil.getInstance().executeShellCommand(string + LS_COMMAND_TIMESTYLE + string2, (IShellOutputReceiver)lsReceiver);
            lsReceiver.finishLinks();
            if (arrayList.size() == 0) {
                SDBHelperUtil.getInstance().executeShellCommand(string + string2, (IShellOutputReceiver)lsReceiver);
                lsReceiver.finishLinks();
            }
            lsReceiver.close();
        }
        catch (SDBNotExistException sDBNotExistException) {
            this.closeReceiver(lsReceiver);
            new MessageDialog().openWarningDialog(sDBNotExistException.getMessage());
            return false;
        }
        catch (SDBCommandRejectedException sDBCommandRejectedException) {
            this.closeReceiver(lsReceiver);
            new MessageDialog().openWarningDialog("Emulator is not ready.\nPlease retry when the emulator is ready.");
            return false;
        }
        catch (Exception exception) {
            this.closeReceiver(lsReceiver);
            return false;
        }
        fileEntry.fetchTime = System.currentTimeMillis();
        Collections.sort(arrayList, FileEntry.sEntryComparator);
        fileEntry.setChildren(arrayList);
        return true;
    }

    private String getStringWithDoubleQuote(String string) {
        return "\"" + string + "\"";
    }

    public static interface IListingReceiver {
        public void setChildren(FileEntry var1, FileEntry[] var2);

        public void refreshEntry(FileEntry var1);
    }

    private static class LsReceiver
    extends MultiLineReceiver {
        private final ArrayList<FileEntry> mEntryList;
        private final FileEntry[] mCurrentChildren;
        private final FileEntry mParentEntry;

        public LsReceiver(FileEntry fileEntry, ArrayList<FileEntry> arrayList) {
            this.mParentEntry = fileEntry;
            this.mCurrentChildren = fileEntry.getCachedChildren();
            this.mEntryList = arrayList;
        }

        public void processNewLines(String[] stringArray) {
            for (String string : stringArray) {
                Object object;
                Matcher matcher;
                if (string.length() == 0 || !(matcher = sLsPattern.matcher(string)).matches()) continue;
                String string2 = matcher.group(8);
                String string3 = matcher.group(1);
                String string4 = matcher.group(3);
                String string5 = matcher.group(4);
                String string6 = matcher.group(5);
                String string7 = matcher.group(6);
                String string8 = matcher.group(7);
                String string9 = null;
                String string10 = null;
                int n = this.getFileType(string3.charAt(0));
                if (n == 5 && ((String[])(object = string2.split("\\s->\\s"))).length == 2) {
                    string2 = object[0];
                    string9 = object[1];
                    string10 = object[1];
                    string9 = "-> " + string9;
                    String[] stringArray2 = string9.split("/");
                    if (stringArray2.length >= 1) {
                        String string11 = "ls -al ";
                        if (string10.charAt(0) != '/') {
                            string11 = string11 + "/";
                        }
                        string11 = string11 + string10;
                        LsLinkReceiver lsLinkReceiver = new LsLinkReceiver();
                        try {
                            SDBHelperUtil.getInstance().executeShellCommand(string11, (IShellOutputReceiver)lsLinkReceiver);
                            if (lsLinkReceiver.isDirectoryLink) {
                                n = 2;
                            }
                        }
                        catch (SDBNotExistException sDBNotExistException) {
                            new MessageDialog().openWarningDialog(sDBNotExistException.getMessage());
                        }
                        catch (Exception exception) {
                            new MessageDialog().openWarningDialog("sdb excute " + string11 + " failed:" + exception.getMessage());
                        }
                        if (lsLinkReceiver != null) {
                            try {
                                lsLinkReceiver.close();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            lsLinkReceiver = null;
                        }
                    }
                }
                if ((object = this.getExistingEntry(string2)) == null) {
                    object = new FileEntry(this.mParentEntry, string2, n, false, this.mParentEntry.fileListingService);
                }
                object.permissions = string3;
                object.size = string6;
                object.date = string7;
                object.time = string8;
                object.owner = string4;
                object.group = string5;
                if (n == 5 || n == 2) {
                    object.info = string9;
                    object.linkPath = string10;
                }
                this.mEntryList.add((FileEntry)object);
            }
        }

        private FileEntry getExistingEntry(String string) {
            for (int i = 0; i < this.mCurrentChildren.length; ++i) {
                FileEntry fileEntry = this.mCurrentChildren[i];
                if (fileEntry == null || !string.equals(fileEntry.name)) continue;
                this.mCurrentChildren[i] = null;
                return fileEntry;
            }
            return null;
        }

        public boolean isCancelled() {
            return false;
        }

        public void finishLinks() {
        }

        private int getFileType(char c) {
            int n = 8;
            switch (c) {
                case '-': {
                    n = 0;
                    break;
                }
                case 'b': {
                    n = 3;
                    break;
                }
                case 'c': {
                    n = 4;
                    break;
                }
                case 'd': {
                    n = 1;
                    break;
                }
                case 'l': {
                    n = 5;
                    break;
                }
                case 's': {
                    n = 6;
                    break;
                }
                case 'p': {
                    n = 7;
                    break;
                }
            }
            return n;
        }

        final class LsLinkReceiver
        extends MultiLineReceiver {
            boolean isDirectoryLink = false;

            LsLinkReceiver() {
            }

            public void processNewLines(String[] stringArray) {
                for (String string : stringArray) {
                    Matcher matcher;
                    if (string.length() <= 0 || !(matcher = sLsPattern.matcher(string)).matches()) continue;
                    int n = LsReceiver.this.getFileType(matcher.group(1).charAt(0));
                    String string2 = matcher.group(8);
                    if (!".".equals(string2) || n != 1) continue;
                    this.isDirectoryLink = true;
                    break;
                }
            }

            public boolean isCancelled() {
                return false;
            }
        }
    }

    public static final class FileEntry {
        private static final Pattern sEscapePattern = Pattern.compile("([\\\\\"$])");
        private static Comparator<FileEntry> sEntryComparator = new Comparator<FileEntry>(){

            @Override
            public int compare(FileEntry fileEntry, FileEntry fileEntry2) {
                if (fileEntry instanceof FileEntry && fileEntry2 instanceof FileEntry) {
                    FileEntry fileEntry3 = fileEntry;
                    FileEntry fileEntry4 = fileEntry2;
                    return fileEntry3.name.compareTo(fileEntry4.name);
                }
                return 0;
            }
        };
        FileEntry parent;
        String name;
        String info;
        String permissions;
        String size;
        String date;
        String time;
        String owner;
        String group;
        String linkPath;
        FileListingService fileListingService;
        int type;
        boolean isAppPackage;
        boolean isRoot;
        long fetchTime = 0L;
        final ArrayList<FileEntry> mChildren = new ArrayList();

        public FileEntry(FileEntry fileEntry, String string, int n, boolean bl, FileListingService fileListingService) {
            this.parent = fileEntry;
            this.name = string;
            this.type = n;
            this.isRoot = bl;
            this.fileListingService = fileListingService;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getSize() {
            return this.size;
        }

        public int getSizeValue() {
            return Integer.parseInt(this.size);
        }

        public String getDate() {
            return this.date;
        }

        public String getTime() {
            return this.time;
        }

        public String getPermissions() {
            return this.permissions;
        }

        public String getInfo() {
            return this.info;
        }

        public String getLinkFullPath() {
            return this.linkPath;
        }

        public String getFullPath() {
            if (this.isRoot) {
                return "/";
            }
            StringBuilder stringBuilder = new StringBuilder();
            this.fillPathBuilder(stringBuilder, false);
            return stringBuilder.toString();
        }

        public String getFullEscapedPath() {
            StringBuilder stringBuilder = new StringBuilder();
            this.fillPathBuilder(stringBuilder, true);
            return stringBuilder.toString();
        }

        public String[] getPathSegments() {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.fillPathSegments(arrayList);
            return arrayList.toArray(new String[arrayList.size()]);
        }

        public int getType() {
            return this.type;
        }

        public FileListingService getFileListingService() {
            return this.fileListingService;
        }

        public boolean isDirectory() {
            return this.type == 1 || this.type == 2 || this.type == 10 || this.type == 9;
        }

        public FileEntry getParent() {
            return this.parent;
        }

        public FileEntry[] getCachedChildren() {
            return this.mChildren.toArray(new FileEntry[this.mChildren.size()]);
        }

        public FileEntry findChild(String string) {
            for (FileEntry fileEntry : this.mChildren) {
                if (!fileEntry.name.equals(string)) continue;
                return fileEntry;
            }
            return null;
        }

        public boolean isRoot() {
            return this.isRoot;
        }

        void addChild(FileEntry fileEntry) {
            this.mChildren.add(fileEntry);
        }

        void setChildren(ArrayList<FileEntry> arrayList) {
            this.mChildren.clear();
            this.mChildren.addAll(arrayList);
        }

        boolean needFetch() {
            if (this.fetchTime == 0L) {
                return true;
            }
            long l = System.currentTimeMillis();
            return l - this.fetchTime > 4000L;
        }

        public boolean isApplicationPackage() {
            return this.isAppPackage;
        }

        public boolean isAppFileName() {
            Matcher matcher = sApkPattern.matcher(this.name);
            return matcher.matches();
        }

        protected void fillPathBuilder(StringBuilder stringBuilder, boolean bl) {
            if (this.isRoot) {
                return;
            }
            if (this.parent != null) {
                this.parent.fillPathBuilder(stringBuilder, bl);
            }
            stringBuilder.append("/");
            stringBuilder.append(bl ? this.escape(this.name) : this.name);
        }

        protected void fillPathSegments(ArrayList<String> arrayList) {
            if (this.isRoot) {
                return;
            }
            if (this.parent != null) {
                this.parent.fillPathSegments(arrayList);
            }
            arrayList.add(this.name);
        }

        private String escape(String string) {
            return sEscapePattern.matcher(string).replaceAll("\\\\$1");
        }
    }
}

