/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.ecp.nfc.NDEFRecord;
import org.tizen.ecp.nfc.NFCConstants;
import org.tizen.ecp.nfc.NFCDialog;
import org.tizen.ecp.nfc.NFCErrorString;
import org.tizen.ecp.nfc.NFCHelpProcess;
import org.tizen.ecp.nfc.RecordFormat;
import org.tizen.ecp.nfc.TypeName;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.widgets.ECPButton;

public class NDEFRecordPage {
    private static Logger logger = LogUtil.getECPLogger(NDEFRecordPage.class).getLogger();
    private ArrayList<String> RecordFormatList = RecordFormat.getInstance().getList();
    private ArrayList<String> TypeNameList = TypeName.getInstance().getList();
    private Combo cmbRecordFormat;
    private Combo cmbRecordTypeName;
    private Text txtRecordTypeName;
    private Text txtRecordID;
    private Text txtRecordPayload;
    private Button butSelectMediaFile;
    private ECPButton butRecordAdd;
    private ECPButton butRecordEdit;
    private ECPButton butRecordRemove;
    private Label lblRecords;
    private int nTotalLength = 0;
    private final int nMaxNDFEMessageLength = 4096;
    private Combo cmbRecordList;
    private ArrayList<NDEFRecord> RecordList = new ArrayList();
    private NDEFRecord oldRecord = new NDEFRecord(0, "", "", "");
    private boolean bCheckTypeNameText = true;
    private boolean bCheckIDText = true;
    private boolean bCheckPayloadText = true;
    private NFCHelpProcess process = null;
    private Shell shell;

    public NDEFRecordPage(Shell shell) {
        this.process = new NFCHelpProcess(shell);
        this.shell = shell;
    }

    public void createNDEFMessageSection(Composite composite) {
        FormUtil.createLabel((Composite)composite, (String)"NDEF Message", (Font)NFCConstants.TITLE_FONT, (Color)NFCConstants.TITLE_COLOR);
        Composite composite2 = FormUtil.createComposite((Composite)composite);
        composite2.setBackground(ColorResources.CONTENTS_BORDER.getColor());
        GridData gridData = FormUtil.createHGD((int)474, (int)1, (int)5, (int)0);
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = FormUtil.createComposite((Composite)composite);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 10;
        composite3.setLayoutData((Object)gridData2);
        this.createRecordComposite(composite3);
        Composite composite4 = FormUtil.createComposite((Composite)composite3, (int)3);
        this.butRecordAdd = FormUtil.createECPButton((Composite)composite4, (String)"Add", (int)8);
        this.butRecordEdit = FormUtil.createECPButton((Composite)composite4, (String)"Edit", (int)8);
        this.butRecordRemove = FormUtil.createECPButton((Composite)composite4, (String)"Remove", (int)8);
        GridData gridData3 = new GridData();
        gridData3.widthHint = 132;
        this.butRecordAdd.setLayoutData((Object)gridData3);
        this.butRecordEdit.setLayoutData((Object)gridData3);
        this.butRecordRemove.setLayoutData((Object)gridData3);
        this.butRecordAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NDEFRecordPage.this.addRecord();
            }
        });
        this.butRecordEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NDEFRecordPage.this.editRecord();
            }
        });
        this.butRecordRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NDEFRecordPage.this.removeRecord();
            }
        });
        Composite composite5 = FormUtil.createComposite((Composite)composite3, (int)2);
        GridData gridData4 = new GridData();
        gridData4.widthHint = 130;
        this.lblRecords = FormUtil.createLabel((Composite)composite5, (String)String.format("Records [0/%d] ", 4096));
        this.lblRecords.setLayoutData((Object)gridData4);
        this.cmbRecordList = FormUtil.createCombo((Composite)composite5, (int)12);
        GridData gridData5 = new GridData();
        gridData5.widthHint = 260;
        this.cmbRecordList.setLayoutData((Object)gridData5);
        this.cmbRecordList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NDEFRecordPage.this.selectRecord();
            }
        });
    }

    private void createRecordComposite(Composite composite) {
        GridData gridData = new GridData();
        gridData.widthHint = 280;
        Composite composite2 = FormUtil.createComposite((Composite)composite, (int)2);
        FormUtil.createLabel((Composite)composite2, (String)"Type Name Format ");
        this.cmbRecordFormat = FormUtil.createCombo((Composite)composite2, (int)12);
        this.cmbRecordFormat.setLayoutData((Object)gridData);
        FormUtil.addComboItem((Combo)this.cmbRecordFormat, this.RecordFormatList);
        FormUtil.createLabel((Composite)composite2, (String)"Type Name ");
        this.txtRecordTypeName = FormUtil.createText((Composite)composite2, (String)"");
        this.txtRecordTypeName.setLayoutData((Object)gridData);
        this.txtRecordTypeName.setTextLimit(250);
        FormUtil.createLabel((Composite)composite2, (String)"");
        this.cmbRecordTypeName = FormUtil.createCombo((Composite)composite2, (int)12);
        FormUtil.addComboItem((Combo)this.cmbRecordTypeName, this.TypeNameList);
        this.cmbRecordTypeName.setLayoutData((Object)gridData);
        FormUtil.createLabel((Composite)composite2, (String)"ID ");
        this.txtRecordID = FormUtil.createText((Composite)composite2, (String)"");
        this.txtRecordID.setLayoutData((Object)gridData);
        this.txtRecordID.setTextLimit(250);
        FormUtil.createLabel((Composite)composite2, (String)"Payload ");
        this.txtRecordPayload = FormUtil.createText((Composite)composite2, (String)"");
        this.txtRecordPayload.setLayoutData((Object)gridData);
        this.txtRecordPayload.setTextLimit(1024);
        FormUtil.createLabel((Composite)composite2, (String)"");
        this.butSelectMediaFile = FormUtil.createButton((Composite)composite2, (String)"Select Media File", (int)8);
        this.butSelectMediaFile.setEnabled(false);
        this.butSelectMediaFile.setLayoutData((Object)new GridData(3, 3, false, false));
        this.addListener();
    }

    private void addListener() {
        this.cmbRecordFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                this.Selected(selectionEvent);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.Selected(selectionEvent);
            }

            private void Selected(SelectionEvent selectionEvent) {
                int n = NDEFRecordPage.this.cmbRecordFormat.getSelectionIndex();
                if (n != -1) {
                    NDEFRecordPage.this.checkRecordFormat(n);
                    NDEFRecordPage.this.txtRecordTypeName.setText("");
                    NDEFRecordPage.this.cmbRecordTypeName.select(0);
                    NDEFRecordPage.this.txtRecordID.setText("");
                    NDEFRecordPage.this.txtRecordPayload.setText("");
                }
            }
        });
        this.txtRecordTypeName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (!NDEFRecordPage.this.bCheckTypeNameText) {
                    NDEFRecordPage.this.bCheckTypeNameText = true;
                    return;
                }
                if (!NDEFRecordPage.this.process.checkInvalidCharaters(NDEFRecordPage.this.txtRecordTypeName.getText())) {
                    NDEFRecordPage.this.txtRecordTypeName.setText(NDEFRecordPage.this.oldRecord.getTypeName());
                    return;
                }
                NDEFRecordPage.this.oldRecord.setTypeName(NDEFRecordPage.this.txtRecordTypeName.getText());
            }
        });
        this.txtRecordID.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (!NDEFRecordPage.this.bCheckIDText) {
                    NDEFRecordPage.this.bCheckIDText = true;
                    return;
                }
                if (!NDEFRecordPage.this.process.checkInvalidCharaters(NDEFRecordPage.this.txtRecordID.getText())) {
                    NDEFRecordPage.this.txtRecordID.setText(NDEFRecordPage.this.oldRecord.getId());
                    return;
                }
                NDEFRecordPage.this.oldRecord.setId(NDEFRecordPage.this.txtRecordID.getText());
            }
        });
        this.txtRecordPayload.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (!NDEFRecordPage.this.bCheckPayloadText) {
                    NDEFRecordPage.this.bCheckPayloadText = true;
                    return;
                }
                if (!NDEFRecordPage.this.process.checkInvalidCharaters(NDEFRecordPage.this.txtRecordPayload.getText())) {
                    NDEFRecordPage.this.txtRecordPayload.setText(NDEFRecordPage.this.oldRecord.getPayload());
                    return;
                }
                NDEFRecordPage.this.oldRecord.setPayload(NDEFRecordPage.this.txtRecordPayload.getText());
            }
        });
        this.butSelectMediaFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = NDEFRecordPage.this.process.selectMediaFile();
                if (string != null) {
                    NDEFRecordPage.this.txtRecordTypeName.setEnabled(true);
                    NDEFRecordPage.this.txtRecordTypeName.setEditable(false);
                    NDEFRecordPage.this.txtRecordPayload.setEnabled(true);
                    NDEFRecordPage.this.txtRecordPayload.setEditable(false);
                    NDEFRecordPage.this.txtRecordTypeName.setText(NDEFRecordPage.this.process.checkFileType(string));
                    NDEFRecordPage.this.txtRecordPayload.setText(string);
                }
            }
        });
    }

    private void selectRecord() {
        int n = this.cmbRecordList.getSelectionIndex();
        if (n != -1) {
            NDEFRecord nDEFRecord = this.RecordList.get(n);
            logger.info("SelectedRecord");
            logger.info("type: " + nDEFRecord.getTypeName());
            logger.info("id: " + nDEFRecord.getId());
            logger.info("payload: " + nDEFRecord.getPayload());
            this.checkRecordFormat(nDEFRecord.getFormat());
            this.cmbRecordFormat.select(nDEFRecord.getFormat());
            if (nDEFRecord.getFormat() == 1) {
                if (nDEFRecord.getTypeName().compareTo("U") == 0) {
                    this.cmbRecordTypeName.select(0);
                } else {
                    this.cmbRecordTypeName.select(1);
                }
                this.txtRecordTypeName.setText("");
            } else {
                this.cmbRecordTypeName.select(0);
                this.txtRecordTypeName.setText(nDEFRecord.getTypeName());
            }
            this.txtRecordID.setText(nDEFRecord.getId());
            this.txtRecordPayload.setText(nDEFRecord.getPayload());
        }
    }

    private void checkRecordFormat(int n) {
        switch (n) {
            case 0: {
                this.cmbRecordTypeName.setEnabled(false);
                this.txtRecordTypeName.setEnabled(false);
                this.txtRecordID.setEnabled(false);
                this.txtRecordPayload.setEnabled(false);
                this.butSelectMediaFile.setEnabled(false);
                break;
            }
            case 1: {
                this.cmbRecordTypeName.setEnabled(true);
                this.cmbRecordTypeName.select(0);
                this.txtRecordTypeName.setEnabled(false);
                this.txtRecordID.setEnabled(true);
                this.txtRecordPayload.setEnabled(true);
                this.txtRecordPayload.setEditable(true);
                this.butSelectMediaFile.setEnabled(false);
                break;
            }
            case 2: {
                this.cmbRecordTypeName.setEnabled(false);
                this.txtRecordTypeName.setEnabled(false);
                this.txtRecordID.setEnabled(true);
                this.txtRecordPayload.setEnabled(false);
                this.butSelectMediaFile.setEnabled(true);
                break;
            }
            case 3: {
                this.cmbRecordTypeName.setEnabled(false);
                this.txtRecordTypeName.setEnabled(true);
                this.txtRecordTypeName.setEditable(true);
                this.txtRecordID.setEnabled(true);
                this.txtRecordPayload.setEnabled(false);
                this.butSelectMediaFile.setEnabled(false);
                break;
            }
            case 4: {
                this.cmbRecordTypeName.setEnabled(false);
                this.txtRecordTypeName.setEnabled(true);
                this.txtRecordTypeName.setEditable(true);
                this.txtRecordID.setEnabled(true);
                this.txtRecordPayload.setEnabled(true);
                this.txtRecordPayload.setEditable(true);
                this.butSelectMediaFile.setEnabled(false);
                break;
            }
            case 5: {
                this.cmbRecordTypeName.setEnabled(false);
                this.txtRecordTypeName.setEnabled(false);
                this.txtRecordID.setEnabled(true);
                this.txtRecordPayload.setEnabled(true);
                this.txtRecordPayload.setEditable(true);
                this.butSelectMediaFile.setEnabled(false);
                break;
            }
        }
        this.bCheckTypeNameText = false;
        this.bCheckIDText = false;
        this.bCheckPayloadText = false;
    }

    private void addRecord() {
        if (this.RecordList.size() >= 5) {
            NFCDialog.openInfoDialog(this.shell, NFCErrorString.RecordCountIsMax);
            return;
        }
        NDEFRecord nDEFRecord = new NDEFRecord();
        this.setRecordValue(nDEFRecord);
        this.RecordList.add(nDEFRecord);
        int n = this.process.checkRecordlistMaxLength(this.RecordList, 4096);
        if (n == 0) {
            this.RecordList.remove(nDEFRecord);
            return;
        }
        this.nTotalLength = n;
        this.lblRecords.setText(String.format("Records [%4d/%d] ", this.nTotalLength, 4096));
        this.cmbRecordList.add("record item" + this.RecordList.indexOf(nDEFRecord));
        this.cmbRecordList.clearSelection();
    }

    private void addRecords(ArrayList<NDEFRecord> arrayList) {
        int n = 0;
        this.RecordList = new ArrayList();
        for (NDEFRecord nDEFRecord : arrayList) {
            logger.info("addRecord");
            logger.info("type: " + nDEFRecord.getTypeName());
            logger.info("id: " + nDEFRecord.getId());
            logger.info("payload: " + nDEFRecord.getPayload());
            this.RecordList.add(nDEFRecord);
            int n2 = this.process.checkRecordlistMaxLength(this.RecordList, 4096);
            if (n2 == 0) {
                this.RecordList.remove(nDEFRecord);
                return;
            }
            this.nTotalLength = n2;
            this.cmbRecordList.add("record item" + n++);
        }
        this.lblRecords.setText(String.format("Records [%4d/%d] ", this.nTotalLength, 4096));
        this.cmbRecordList.clearSelection();
    }

    private void editRecord() {
        int n = this.cmbRecordList.getSelectionIndex();
        if (n != -1) {
            NDEFRecord nDEFRecord;
            NDEFRecord nDEFRecord2 = nDEFRecord = this.RecordList.get(n);
            this.setRecordValue(nDEFRecord);
            int n2 = this.process.checkRecordlistMaxLength(this.RecordList, 4096);
            if (n2 == 0) {
                nDEFRecord = nDEFRecord2;
                return;
            }
            this.nTotalLength = n2;
            this.lblRecords.setText(String.format("Records [%4d/%d] ", this.nTotalLength, 4096));
        }
    }

    private void removeRecord() {
        int n = this.cmbRecordList.getSelectionIndex();
        if (n != -1) {
            this.RecordList.remove(n);
            this.cmbRecordList.removeAll();
            for (int i = 0; i < this.RecordList.size(); ++i) {
                this.cmbRecordList.add("record item" + i);
            }
            this.cmbRecordList.clearSelection();
        }
        this.nTotalLength = this.process.checkRecordlistMaxLength(this.RecordList, 4096);
        this.lblRecords.setText(String.format("Records [%4d/%d] ", this.nTotalLength, 4096));
        this.txtRecordTypeName.setText("");
        this.cmbRecordTypeName.select(0);
        this.txtRecordID.setText("");
        this.txtRecordPayload.setText("");
    }

    private void removeAllRecord(int n) {
        this.cmbRecordList.removeAll();
        this.cmbRecordList.clearSelection();
        this.nTotalLength = this.process.checkRecordlistMaxLength(this.RecordList, 4096);
        this.lblRecords.setText(String.format("Records [%4d/%d] ", this.nTotalLength, 4096));
        this.txtRecordTypeName.setText("");
        this.cmbRecordTypeName.select(0);
        this.txtRecordID.setText("");
        this.txtRecordPayload.setText("");
    }

    private void setRecordValue(NDEFRecord nDEFRecord) {
        nDEFRecord.setFormat(this.cmbRecordFormat.getSelectionIndex());
        if (this.cmbRecordFormat.getSelectionIndex() == 1) {
            nDEFRecord.setTypeName(this.TypeNameList.get(this.cmbRecordTypeName.getSelectionIndex()));
        } else if (this.txtRecordTypeName.getText().isEmpty()) {
            nDEFRecord.setTypeName("Null");
        } else {
            nDEFRecord.setTypeName(this.txtRecordTypeName.getText());
        }
        if (this.txtRecordID.getText().isEmpty()) {
            nDEFRecord.setId("Null");
        } else {
            nDEFRecord.setId(this.txtRecordID.getText());
        }
        if (this.txtRecordPayload.getText().isEmpty()) {
            nDEFRecord.setPayload("Null");
        } else {
            nDEFRecord.setPayload(this.txtRecordPayload.getText());
        }
    }

    public ArrayList<NDEFRecord> getRecordList() {
        return this.RecordList;
    }

    public void setRecordList(ArrayList<NDEFRecord> arrayList) {
        this.removeAllRecord(arrayList.size());
        this.addRecords(arrayList);
    }

    public void setDisableState() {
        this.cmbRecordFormat.setEnabled(false);
        this.checkRecordFormat(0);
        this.cmbRecordList.setEnabled(false);
        this.butRecordAdd.setEnabled(false);
        this.butRecordEdit.setEnabled(false);
        this.butRecordRemove.setEnabled(false);
    }

    public void setEnableState() {
        this.cmbRecordFormat.setEnabled(true);
        this.checkRecordFormat(this.cmbRecordFormat.getSelectionIndex());
        this.txtRecordTypeName.setText("");
        this.cmbRecordTypeName.select(0);
        this.txtRecordID.setText("");
        this.txtRecordPayload.setText("");
        this.cmbRecordList.setEnabled(true);
        this.butRecordAdd.setEnabled(true);
        this.butRecordEdit.setEnabled(true);
        this.butRecordRemove.setEnabled(true);
    }
}

