/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.protocol;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.tizen.ecp.protocol.AbstractItem;
import org.tizen.ecp.protocol.ByteArrayItem;
import org.tizen.ecp.protocol.ByteUtil;
import org.tizen.ecp.protocol.IntItem;
import org.tizen.ecp.protocol.ItemType;
import org.tizen.ecp.protocol.StructureGA;

public abstract class AbstractGA {
    private static final int SINGLE_ROW_INDEX = 0;
    private int groupId;
    private int actionId;
    private int length = 0;
    private StructureGA header;
    private StructureGA body;

    public AbstractGA(int n, int n2) {
        this.groupId = n;
        this.actionId = n2;
    }

    protected abstract void makeBody();

    protected abstract void makeHeader();

    public void intialize() {
        this.header = new StructureGA();
        this.makeHeader();
        this.body = new StructureGA();
        this.makeBody();
    }

    public void intialize(byte[] byArray) {
        int n;
        ByteBuffer byteBuffer = ByteUtil.getByteBuffer(byArray);
        AbstractItem abstractItem = null;
        this.length = byArray.length;
        this.header = new StructureGA();
        this.makeHeader();
        for (n = 0; n < this.header.getItemCount(); ++n) {
            abstractItem = this.header.getItem(n);
            this.putBufferToItem(abstractItem, 0, byteBuffer);
        }
        this.body = new StructureGA();
        this.makeBody();
        n = this.getLoopCount();
        this.body.setLoopCount(n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.body.getItemCount(); ++j) {
                abstractItem = this.body.getItem(j);
                this.putBufferToItem(abstractItem, i, byteBuffer);
            }
        }
    }

    private int getLoopCount() {
        return (int)Math.ceil((double)(this.length - this.header.getByteLength()) / (double)this.body.getByteLength());
    }

    public byte[] makeStarterPacket() {
        int n = this.getSendLength();
        ByteBuffer byteBuffer = ByteUtil.getByteBuffer(4);
        byteBuffer.putShort((short)n);
        byteBuffer.put(Integer.valueOf(this.groupId).byteValue());
        byteBuffer.put(Integer.valueOf(this.actionId).byteValue());
        return byteBuffer.array();
    }

    public byte[] makePacket() {
        int n;
        int n2 = this.getSendLength();
        ByteBuffer byteBuffer = ByteUtil.getByteBuffer(n2);
        AbstractItem abstractItem = null;
        for (n = 0; n < this.header.getItemCount(); ++n) {
            abstractItem = this.header.getItem(n);
            this.putItemToBuffer(abstractItem, 0, byteBuffer);
        }
        for (n = 0; n < this.body.getLoopCount(); ++n) {
            for (int i = 0; i < this.body.getItemCount(); ++i) {
                abstractItem = this.body.getItem(i);
                this.putItemToBuffer(abstractItem, n, byteBuffer);
            }
        }
        return byteBuffer.array();
    }

    private void putItemToBuffer(AbstractItem abstractItem, int n, ByteBuffer byteBuffer) {
        ItemType itemType = abstractItem.getType();
        if (itemType == ItemType.BYTE) {
            byteBuffer.put(this.getIntValue(abstractItem, n).byteValue());
        } else if (itemType == ItemType.SHORT) {
            byteBuffer.putShort(this.getIntValue(abstractItem, n).shortValue());
        } else if (itemType == ItemType.INT) {
            byteBuffer.putInt(this.getIntValue(abstractItem, n));
        } else if (itemType == ItemType.ByteArray) {
            byte[] byArray = ((ByteArrayItem)abstractItem).getValue(n);
            int n2 = abstractItem.getByteLength();
            int n3 = byteBuffer.position();
            if (byArray.length > n2) {
                byteBuffer.put(byArray, 0, n2);
            } else {
                byteBuffer.put(byArray);
            }
            byteBuffer.position(n3 + n2);
        }
    }

    private Integer getIntValue(AbstractItem abstractItem, int n) {
        return ((IntItem)abstractItem).getValue(n);
    }

    private void putBufferToItem(AbstractItem abstractItem, int n, ByteBuffer byteBuffer) {
        ItemType itemType = abstractItem.getType();
        try {
            if (itemType == ItemType.BYTE) {
                ((IntItem)abstractItem).setValue(n, byteBuffer.get() & 0xFF);
            } else if (itemType == ItemType.SHORT) {
                ((IntItem)abstractItem).setValue(n, byteBuffer.getShort());
            } else if (itemType == ItemType.INT) {
                ((IntItem)abstractItem).setValue(n, byteBuffer.getInt());
            } else if (itemType == ItemType.ByteArray) {
                int n2 = abstractItem.getByteLength();
                int n3 = byteBuffer.remaining();
                byte[] byArray = null;
                byArray = n2 > n3 ? new byte[n3] : (abstractItem.getName() == "CALL_NUMBER" ? new byte[n3] : new byte[n2]);
                byteBuffer.get(byArray, 0, byArray.length);
                ((ByteArrayItem)abstractItem).setValue(n, byArray);
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            bufferUnderflowException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String makeKey(int n, int n2) {
        return n + ":" + n2;
    }

    public String getKey() {
        return this.makeKey(this.groupId, this.actionId);
    }

    public int getGroupID() {
        return this.groupId;
    }

    public int getActionID() {
        return this.actionId;
    }

    public int getSendLength() {
        return this.header.getByteLength() + this.body.getByteLength() * this.body.getLoopCount();
    }

    public int getReceiveLength() {
        return this.length;
    }

    public StructureGA getBody() {
        return this.body;
    }

    public StructureGA getHeader() {
        return this.header;
    }
}

