/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.EarJack;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.tizen.ecp.battery.BatteryDisplay;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.timer.MessageTimer;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPSubView;
import org.tizen.ecp.widgets.ECPButton;

public class EarJackDisplay
extends ECPSubView {
    private ECPButton[] radioButton;
    private Composite comp;
    private static Logger logger = LogUtil.getECPLogger(BatteryDisplay.class).getLogger();
    private int earjack_status;
    private MouseAdapter focusAdapter = new MouseAdapter(){

        public void mouseDown(MouseEvent mouseEvent) {
            for (int i = 0; i < EarJackDisplay.this.radioButton.length; ++i) {
                if (!EarJackDisplay.this.radioButton[i].getSelection()) continue;
                if (i == 0) {
                    EarJackDisplay.this.radioButton[0].setFocus();
                    continue;
                }
                if (i == 1) {
                    EarJackDisplay.this.radioButton[1].setFocus();
                    continue;
                }
                EarJackDisplay.this.radioButton[2].setFocus();
            }
        }
    };
    private SelectionAdapter statusAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            EarJackDisplay.this.statusUpdate();
        }
    };

    public EarJackDisplay() {
        this.title = "Ear Jack";
        this.pageHeight = 90;
        this.useTimer = true;
    }

    public void createView(Composite composite) {
        this.comp = FormUtil.createComposite((Composite)composite, (int)3);
        this.comp.setBackground(ColorResources.CONTENTS_BG.getColor());
        this.comp.addMouseListener((MouseListener)this.focusAdapter);
        this.radioButton = new ECPButton[3];
        this.radioButton[0] = FormUtil.createECPButton((Composite)this.comp, (String)"3 Wire", (int)16);
        this.radioButton[1] = FormUtil.createECPButton((Composite)this.comp, (String)"4 Wire", (int)16);
        this.radioButton[2] = FormUtil.createECPButton((Composite)this.comp, (String)"Disconnect", (int)16);
        GridData gridData = new GridData();
        gridData.widthHint = 129;
        gridData.horizontalIndent = 20;
        gridData.verticalIndent = 7;
        for (ECPButton eCPButton : this.radioButton) {
            eCPButton.addSelectionListener((SelectionListener)this.statusAdapter);
            eCPButton.setLayoutData((Object)gridData);
        }
    }

    private void statusUpdate() {
        int n = 0;
        for (int i = 0; i < this.radioButton.length; ++i) {
            if (!this.radioButton[i].getSelection()) continue;
            n = i == 0 ? 1 : (i == 1 ? 3 : 0);
        }
        if (n == this.earjack_status) {
            return;
        }
        this.earjack_status = n;
        this.send(this.earjack_status);
    }

    public void send(int n) {
        try {
            if (!MessageTimer.getInstance().isRunning()) {
                MessageTimer.getInstance().RestartTimer();
            }
        }
        catch (IOException iOException) {
            logger.severe(iOException.getMessage());
        }
        InjectorMessage injectorMessage = new InjectorMessage(n);
        MessageSender.getInstance().sendInjectorReq("sensor", 0, 0, "9\n" + injectorMessage.getMessage());
    }

    public void destroyContents(Composite composite) {
        composite.layout(true, true);
    }

    protected void initializeWidget() {
    }

    public boolean Create() {
        this.createPage();
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        return true;
    }

    public void OnTimerMessageExpired() {
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 103);
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        Ecs.InjectorNtf injectorNtf;
        if (generatedMessage instanceof Ecs.InjectorNtf && 103 == (injectorNtf = (Ecs.InjectorNtf)generatedMessage).getAction()) {
            String string = injectorNtf.getData().toStringUtf8();
            if (string.equals("1")) {
                this.radioButton[0].selectRadio();
            } else if (string.equals("3")) {
                this.radioButton[1].selectRadio();
            } else {
                this.radioButton[2].selectRadio();
            }
        }
    }
}

