/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.RSSI;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.tizen.ecp.util.ImageUtil;
import org.tizen.ecp.utils.SwtUtil;

public class RSSIGauge
extends Canvas {
    private Color bgColor = null;
    private int selection = 2;
    private int NO_BAR_SIZE = 30;
    private int BAR_NUM = 4;
    private int BAR_WIDTH = 48;
    private int BAR_LONG = 84;
    private int BAR_TOP_HEIGHT = 6;
    private int BAR_DIFF = 16;
    private int GAP_WIDTH = 10;
    private int GAP_HEIGHT = 20;
    private int GAP_SELECTED = 3;
    private Rectangle rssiRect;
    private Rectangle level0Rect;
    private Rectangle level1Rect;
    private Rectangle level2Rect;
    private Rectangle level3Rect;
    private Rectangle level4Rect;
    private Rectangle level5Rect;
    private Image gauge_top = ImageUtil.loadDeviceImage("RSSI", "rssi_gauge_top.png");
    private Image gauge_mid = ImageUtil.loadDeviceImage("RSSI", "rssi_gauge_middle.png");
    private Image gauge_bot = ImageUtil.loadDeviceImage("RSSI", "rssi_gauge_bottom.png");
    private Image gauge_sel = ImageUtil.loadDeviceImage("RSSI", "rssi_gauge.png");
    private Image gauge_0_nml = ImageUtil.loadDeviceImage("RSSI", "rssi_gauge_0_nml.png");
    private Image gauge_0_sel = ImageUtil.loadDeviceImage("RSSI", "rssi_gauge_0_sel.png");
    private PaintListener paint = new PaintListener(){

        public void paintControl(PaintEvent paintEvent) {
            Image image = RSSIGauge.this.gauge_mid;
            Canvas canvas = (Canvas)paintEvent.widget;
            Rectangle rectangle = canvas.getClientArea();
            if (null != RSSIGauge.this.bgColor) {
                paintEvent.gc.setBackground(RSSIGauge.this.bgColor);
                paintEvent.gc.fillRectangle(rectangle);
            }
            for (int i = 1; i <= RSSIGauge.this.BAR_NUM; ++i) {
                rectangle = RSSIGauge.this.getLevelRect(i);
                if (rectangle == null) {
                    return;
                }
                paintEvent.gc.drawImage(RSSIGauge.this.gauge_top, rectangle.x, rectangle.y);
                Rectangle rectangle2 = RSSIGauge.this.gauge_mid.getBounds();
                paintEvent.gc.drawImage(RSSIGauge.this.gauge_mid, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle.x, rectangle.y + RSSIGauge.this.BAR_TOP_HEIGHT, rectangle.width, rectangle.height - RSSIGauge.this.BAR_TOP_HEIGHT * 2);
                paintEvent.gc.drawImage(RSSIGauge.this.gauge_bot, rectangle.x, rectangle.y + rectangle.height - RSSIGauge.this.BAR_TOP_HEIGHT);
                if (i > RSSIGauge.this.selection) continue;
                image = RSSIGauge.this.gauge_sel;
                rectangle2 = image.getBounds();
                paintEvent.gc.drawImage(image, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle.x + RSSIGauge.this.GAP_SELECTED, rectangle.y + RSSIGauge.this.GAP_SELECTED, rectangle.width - RSSIGauge.this.GAP_SELECTED * 2, rectangle.height - RSSIGauge.this.GAP_SELECTED * 2);
            }
            image = RSSIGauge.this.selection == 0 ? RSSIGauge.this.gauge_0_sel : RSSIGauge.this.gauge_0_nml;
            paintEvent.gc.drawImage(image, ((RSSIGauge)RSSIGauge.this).level0Rect.x, ((RSSIGauge)RSSIGauge.this).level0Rect.y);
        }
    };
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            SwtUtil.tryDispose((Object[])new Object[]{RSSIGauge.this.gauge_top, RSSIGauge.this.gauge_mid, RSSIGauge.this.gauge_bot, RSSIGauge.this.gauge_sel});
            SwtUtil.tryDispose((Object[])new Object[]{RSSIGauge.this.gauge_0_nml, RSSIGauge.this.gauge_0_sel});
        }
    };
    private ControlAdapter controlListener = new ControlAdapter(){

        public void controlResized(ControlEvent controlEvent) {
            int n = RSSIGauge.this.BAR_WIDTH + RSSIGauge.this.GAP_WIDTH;
            Canvas canvas = (Canvas)controlEvent.widget;
            RSSIGauge.this.rssiRect = canvas.getClientArea();
            int n2 = (((RSSIGauge)RSSIGauge.this).rssiRect.x + ((RSSIGauge)RSSIGauge.this).rssiRect.width - (RSSIGauge.this.BAR_NUM * RSSIGauge.this.BAR_WIDTH + (RSSIGauge.this.BAR_NUM - 1) * RSSIGauge.this.GAP_WIDTH)) / 2;
            int n3 = (((RSSIGauge)RSSIGauge.this).rssiRect.y + ((RSSIGauge)RSSIGauge.this).rssiRect.height - RSSIGauge.this.BAR_LONG) / 2;
            RSSIGauge.this.level1Rect = new Rectangle(n2, n3 + RSSIGauge.this.BAR_LONG - RSSIGauge.this.GAP_HEIGHT, RSSIGauge.this.BAR_WIDTH, RSSIGauge.this.BAR_LONG - RSSIGauge.this.BAR_DIFF * 4);
            RSSIGauge.this.level2Rect = new Rectangle(n2 + n, n3 + RSSIGauge.this.BAR_LONG - (RSSIGauge.this.GAP_HEIGHT + RSSIGauge.this.BAR_DIFF), RSSIGauge.this.BAR_WIDTH, RSSIGauge.this.BAR_LONG - RSSIGauge.this.BAR_DIFF * 3);
            RSSIGauge.this.level3Rect = new Rectangle(n2 + n * 2, n3 + RSSIGauge.this.BAR_LONG - (RSSIGauge.this.GAP_HEIGHT + RSSIGauge.this.BAR_DIFF * 2), RSSIGauge.this.BAR_WIDTH, RSSIGauge.this.BAR_LONG - RSSIGauge.this.BAR_DIFF * 2);
            RSSIGauge.this.level4Rect = new Rectangle(n2 + n * 3, n3 + RSSIGauge.this.BAR_LONG - (RSSIGauge.this.GAP_HEIGHT + RSSIGauge.this.BAR_DIFF * 3), RSSIGauge.this.BAR_WIDTH, RSSIGauge.this.BAR_LONG - RSSIGauge.this.BAR_DIFF);
            RSSIGauge.this.level5Rect = new Rectangle(n2 + n * 4, n3 + RSSIGauge.this.BAR_LONG - (RSSIGauge.this.GAP_HEIGHT + RSSIGauge.this.BAR_DIFF * 4), RSSIGauge.this.BAR_WIDTH, RSSIGauge.this.BAR_LONG);
            RSSIGauge.this.level0Rect = new Rectangle(((RSSIGauge)RSSIGauge.this).level1Rect.x + (((RSSIGauge)RSSIGauge.this).level1Rect.width / 2 - RSSIGauge.this.NO_BAR_SIZE / 2), ((RSSIGauge)RSSIGauge.this).level1Rect.y - (RSSIGauge.this.NO_BAR_SIZE + RSSIGauge.this.BAR_TOP_HEIGHT), RSSIGauge.this.NO_BAR_SIZE, RSSIGauge.this.NO_BAR_SIZE);
        }
    };
    private Listener mouseListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 4) {
                if (RSSIGauge.this.level1Rect.contains(event.x, event.y)) {
                    RSSIGauge.this.setSelection(1);
                } else if (RSSIGauge.this.level2Rect.contains(event.x, event.y)) {
                    RSSIGauge.this.setSelection(2);
                } else if (RSSIGauge.this.level3Rect.contains(event.x, event.y)) {
                    RSSIGauge.this.setSelection(3);
                } else if (RSSIGauge.this.level4Rect.contains(event.x, event.y)) {
                    RSSIGauge.this.setSelection(4);
                } else if (RSSIGauge.this.level5Rect.contains(event.x, event.y)) {
                    RSSIGauge.this.setSelection(5);
                } else if (RSSIGauge.this.level0Rect.contains(event.x, event.y)) {
                    RSSIGauge.this.setSelection(0);
                }
            }
        }
    };

    public RSSIGauge(Composite composite, int n) {
        super(composite, 0x20000000 | n);
        this.addPaintListener(this.paint);
        this.addDisposeListener(this.disposeListener);
        this.addControlListener((ControlListener)this.controlListener);
        this.addListener(4, this.mouseListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.addListener(13, (Listener)new TypedListener((SWTEventListener)selectionListener));
    }

    public void setBackground(Color color) {
        this.bgColor = color;
    }

    public Color getBackground() {
        return this.bgColor;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = 0;
        this.checkWidget();
        n3 = this.BAR_WIDTH * this.BAR_NUM + this.GAP_WIDTH * (this.BAR_NUM - 1);
        n4 = this.BAR_LONG;
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3, n4);
    }

    private void redrawRect(Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
    }

    private Rectangle getLevelRect(int n) {
        if (n == 1) {
            return this.level1Rect;
        }
        if (n == 2) {
            return this.level2Rect;
        }
        if (n == 3) {
            return this.level3Rect;
        }
        if (n == 4) {
            return this.level4Rect;
        }
        if (n == 5) {
            return this.level5Rect;
        }
        if (n == 0) {
            return this.level0Rect;
        }
        return null;
    }

    private void redrawGauge(int n, int n2) {
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        for (int i = 0; i <= this.BAR_NUM; ++i) {
            if (i < n3 || i > n4) continue;
            this.redrawRect(this.getLevelRect(i));
        }
    }

    public void setSelection(int n) {
        this.setSelection(n, true);
    }

    public void setSelection(int n, boolean bl) {
        int n2 = this.selection;
        this.selection = n;
        this.redrawGauge(n2, this.selection);
        if (bl) {
            this.notifyListeners(13, new Event());
        }
    }

    public int getSelection() {
        return this.selection;
    }
}

