/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.RSSI;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;

public class RSSISetCLI
extends AbstractEmulatorCLI {
    private String TYPE_SENSOR;
    @Argument(required=true, index=0)
    String mode;

    public RSSISetCLI() {
        this.messageType = this.TYPE_SENSOR = "sensor";
    }

    public void printHelp() {
        System.out.println(this.help);
    }

    public int execute() {
        int n = 0;
        if (this.mode == null) {
            OutputUtil.printError((String)"Invalid argument: Empty command");
            this.printHelp();
            return 25;
        }
        try {
            n = Integer.parseInt(this.mode);
            if (n < 0 || n > 4) {
                OutputUtil.println((String)"rssi level must be within 0 - 4.");
                OutputUtil.println((String)this.help);
                return 25;
            }
        }
        catch (NumberFormatException numberFormatException) {
            OutputUtil.println((String)("'" + this.mode + "' is not a valid command."));
            this.printHelp();
            return 25;
        }
        InjectorMessage injectorMessage = new InjectorMessage(n);
        MessageSender.getInstance().sendInjectorReq(this.TYPE_SENSOR, 0, 0, "11\n" + injectorMessage.getMessage());
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            OutputUtil.printError((String)"Interrupted.", (Exception)interruptedException);
        }
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 104);
        this.startRunning();
        if (this.returnValue == 128) {
            OutputUtil.printFail();
        } else {
            OutputUtil.printOK();
        }
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.InjectorAns) {
            Ecs.InjectorAns injectorAns = (Ecs.InjectorAns)generatedMessage;
            int n = injectorAns.getErrcode();
            if (n != 0) {
                this.returnValue = 128;
            }
            this.stopRunning();
        }
    }
}

