/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.SDCard;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.json.simple.JSONObject;
import org.tizen.ecp.SDCard.SDCardMountChecker;
import org.tizen.ecp.SDCard.SDCardMounter;
import org.tizen.ecp.dialogs.MessageDialog;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.timer.MessageTimer;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPSubView;

public class SDCardDisplay
extends ECPSubView {
    Logger logger = LogUtil.getECPLogger(SDCardDisplay.class).getLogger();
    private Composite comp;
    private ArrayList<String> list;
    private Button mountButton;
    private Button umountButton;
    private Combo formatCombo;
    private static final String event_sdcard = "sdcard";
    private boolean isMounted = false;
    private boolean umountOk = true;
    private Timer mountTimer;
    private Timer umountTimer;
    InjectMountTask mountTask = null;
    InjectUmountTask umountTask = null;
    private SelectionAdapter mountAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        SDCardDisplay.this.startMountTask();
                    }
                    catch (Exception exception) {
                        SDCardDisplay.this.logger.severe(exception.getMessage());
                        return;
                    }
                    SDCardDisplay.this.disableAllWidgets();
                }
            });
        }
    };
    private SelectionAdapter umountAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        SDCardDisplay.this.startUmountTask();
                    }
                    catch (Exception exception) {
                        SDCardDisplay.this.logger.severe(exception.getMessage());
                        return;
                    }
                    SDCardDisplay.this.disableAllWidgets();
                }
            });
            if (!SDCardDisplay.this.umountOk) {
                Shell shell = new Shell(Display.getDefault());
                MessageDialog messageDialog = new MessageDialog(shell);
                messageDialog.openInfoDialog("Device or resource is busy.\nPlease try again later.");
                SDCardDisplay.this.mntButtonClick();
            }
        }
    };

    public synchronized void startMountTask() throws Exception {
        this.mountTimer = new Timer();
        this.mountTask = new InjectMountTask();
        if (!this.sendMessage("1\n" + this.formatCombo.getText() + "\n")) {
            throw new Exception("Guest is off");
        }
        this.mountTimer.schedule((TimerTask)this.mountTask, 0L, 100L);
    }

    public synchronized void startUmountTask() throws Exception {
        this.umountTimer = new Timer();
        this.umountTask = new InjectUmountTask();
        if (!this.sendMessage("0\n" + this.formatCombo.getText() + "\n")) {
            throw new Exception("Guest is off");
        }
        this.umountTimer.schedule((TimerTask)this.umountTask, 0L, 100L);
    }

    public synchronized void stopMountTask() {
        if (this.mountTimer != null) {
            this.mountTimer.cancel();
        }
    }

    public synchronized void stopUmountTask() {
        if (this.umountTimer != null) {
            this.umountTimer.cancel();
        }
    }

    public SDCardDisplay() {
        this.list = new ArrayList();
        this.list.add(0, "sdcard_4G.img");
        this.list.add(1, "sdcard_8G.img");
        this.list.add(2, "sdcard_16G.img");
        this.list.add(3, "sdcard_32G.img");
        this.title = "SD Card";
        this.pageHeight = 100;
        this.useTimer = true;
        this.UPDATING_TIME = 4000;
    }

    public void createView(Composite composite) {
        this.comp = FormUtil.createComposite((Composite)composite, (int)4);
        this.comp.setBackground(ColorResources.CONTENTS_BG.getColor());
        Label label = FormUtil.createLabel((Composite)this.comp, (String)"Select SD Card : ");
        label.setBackground(ColorResources.CONTENTS_BG.getColor());
        this.formatCombo = FormUtil.createCombo((Composite)this.comp, (int)12);
        GridData gridData = new GridData();
        gridData.widthHint = 170;
        this.formatCombo.setLayoutData((Object)gridData);
        FormUtil.addComboItem((Combo)this.formatCombo, this.list);
        this.mountButton = FormUtil.createButton((Composite)this.comp, (String)"Attach", (int)8);
        this.umountButton = FormUtil.createButton((Composite)this.comp, (String)"Detach", (int)8);
        this.mountButton.setBackground(ColorResources.CONTENTS_BG.getColor());
        this.umountButton.setBackground(ColorResources.CONTENTS_BG.getColor());
        this.mountButton.addSelectionListener((SelectionListener)this.mountAdapter);
        this.umountButton.addSelectionListener((SelectionListener)this.umountAdapter);
        this.checkIsMounted();
    }

    public void checkIsMounted() {
        SDCardMountChecker sDCardMountChecker = new SDCardMountChecker();
        sDCardMountChecker.start();
    }

    public boolean sendMessage(String string) {
        try {
            if (!MessageTimer.getInstance().isRunning()) {
                MessageTimer.getInstance().RestartTimer();
            }
        }
        catch (IOException iOException) {
            this.logger.severe(iOException.getMessage());
            return false;
        }
        return SDCardMounter.getInstance().sendSDcard(string);
    }

    public void disableAllWidgets() {
        this.logger.info("disable all buttons and combobox");
        this.mountButton.setEnabled(false);
        this.umountButton.setEnabled(false);
        this.formatCombo.setEnabled(false);
    }

    public void mntButtonClick() {
        this.mountButton.setEnabled(false);
        this.umountButton.setEnabled(true);
        this.formatCombo.setEnabled(false);
    }

    public void umntButtonClick() {
        this.umountButton.setEnabled(false);
        this.mountButton.setEnabled(true);
        this.formatCombo.setEnabled(true);
    }

    protected void initializeWidget() {
    }

    public boolean Create() {
        this.createPage();
        EventMgr.getInstance().AddLsn(event_sdcard, (ILsn)this);
        return true;
    }

    public void OnTimerMessageExpired() {
        SDCardMounter.getInstance().sendSDcard("2\n");
    }

    public void OnEventProc(String string, JSONObject jSONObject) {
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"header");
        long l = (Long)jSONObject2.get((Object)"group");
        long l2 = (Long)jSONObject2.get((Object)"action");
        String string2 = (String)jSONObject.get((Object)"ijdata");
        if (l == 11L) {
            String string3 = string2;
            if (l2 == 0L) {
                this.logger.info("unmounted");
                this.isMounted = false;
                SDCardMounter.getInstance().SDpath_set.remove(string3);
                this.umountOk = true;
                this.umntButtonClick();
            } else if (l2 == 1L) {
                this.logger.info("mounted");
                this.isMounted = true;
                SDCardMounter.getInstance().SDpath_set.add(string3);
                this.mntButtonClick();
            } else if (l2 == 2L) {
                this.logger.info("umounted status");
                this.isMounted = false;
                SDCardMounter.getInstance().SDpath_set.remove(string3);
                SDCardMounter.getInstance().isDataWaiting = false;
                this.umntButtonClick();
            } else if (l2 == 3L) {
                this.logger.info("mounted status");
                this.isMounted = true;
                SDCardMounter.getInstance().SDpath_set.add(string3);
                SDCardMounter.getInstance().isDataWaiting = false;
                this.mntButtonClick();
            } else if (l2 == 4L) {
                this.logger.info("umount failed");
                this.umountOk = false;
            } else if (l2 == 5L) {
                this.logger.info("mount failed");
            } else if (l2 == 6L) {
                this.logger.info("umount failed");
            }
        }
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (!(generatedMessage instanceof Ecs.InjectorNtf)) {
            return;
        }
        Ecs.InjectorNtf injectorNtf = (Ecs.InjectorNtf)generatedMessage;
        long l = injectorNtf.getGroup();
        long l2 = injectorNtf.getAction();
        String string2 = injectorNtf.getData().toStringUtf8();
        if (l == 11L) {
            this.logger.info("action: " + l2);
            switch ((int)l2) {
                case 0: {
                    if (string2 == null || string2.isEmpty()) {
                        this.logger.severe("data is null or empty.");
                        return;
                    }
                    this.logger.info("unmounted: " + string2);
                    this.isMounted = false;
                    this.umountOk = true;
                    this.umntButtonClick();
                    break;
                }
                case 1: {
                    if (string2 == null || string2.isEmpty()) {
                        this.logger.severe("data is null or empty.");
                        return;
                    }
                    this.logger.info("mounted: " + string2);
                    this.isMounted = true;
                    try {
                        Thread.sleep(2000L);
                        this.formatCombo.setText(string2);
                        this.mntButtonClick();
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.severe(interruptedException.getMessage());
                    }
                    break;
                }
                case 2: {
                    if (string2 == null || string2.isEmpty()) {
                        this.logger.severe("data is null or empty.");
                        return;
                    }
                    this.logger.info("umounted status: " + string2);
                    this.isMounted = false;
                    SDCardMounter.getInstance().isDataWaiting = false;
                    this.umntButtonClick();
                    break;
                }
                case 3: {
                    if (string2 == null || string2.isEmpty()) {
                        this.logger.severe("data is null or empty.");
                        return;
                    }
                    this.logger.info("mounted status: " + string2);
                    if (string2.equals("umounted")) {
                        this.umntButtonClick();
                        this.isMounted = false;
                        SDCardMounter.getInstance().isDataWaiting = false;
                        break;
                    }
                    String string3 = string2.split(",")[0];
                    this.isMounted = true;
                    this.formatCombo.setText(string3);
                    SDCardMounter.getInstance().isDataWaiting = false;
                    this.mntButtonClick();
                    break;
                }
                case 4: {
                    this.logger.info("umount failed");
                    this.umountOk = false;
                    Shell shell = new Shell(Display.getDefault());
                    MessageDialog messageDialog = new MessageDialog(shell);
                    messageDialog.openInfoDialog("Failed to umount " + this.formatCombo.getText() + "\nPlease try again later.");
                    break;
                }
                case 5: {
                    this.logger.info("mount failed");
                    Shell shell = new Shell(Display.getDefault());
                    MessageDialog messageDialog = new MessageDialog(shell);
                    messageDialog.openInfoDialog(this.formatCombo.getText() + " is already mounted from other emulator.\nPlease try again later.");
                    break;
                }
                case 6: {
                    this.logger.info("umount failed");
                    break;
                }
                default: {
                    this.logger.severe("wrong action value: " + l2);
                }
            }
        }
    }

    class InjectUmountTask
    extends TimerTask {
        InjectUmountTask() {
        }

        @Override
        public void run() {
            if (!SDCardDisplay.this.isMounted || !SDCardDisplay.this.umountOk) {
                SDCardDisplay.this.stopUmountTask();
            }
        }
    }

    class InjectMountTask
    extends TimerTask {
        InjectMountTask() {
        }

        @Override
        public void run() {
            if (SDCardDisplay.this.isMounted) {
                SDCardDisplay.this.stopMountTask();
                return;
            }
        }
    }
}

