/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.battery;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.spi.IntOptionHandler;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;

public class BatteryLevelCLI
extends AbstractEmulatorCLI {
    @Argument(index=0, handler=IntOptionHandler.class)
    int level = -1;

    public BatteryLevelCLI() {
        this.messageType = "sensor";
    }

    public int execute() {
        if (this.level < 0 || this.level > 100) {
            OutputUtil.printHelpError((String)"battery level must be within 0 - 100.", (String)this.help);
            return 25;
        }
        InjectorMessage injectorMessage = new InjectorMessage(1, this.level);
        MessageSender.getInstance().sendInjectorReq(this.messageType, 0, 0, "8\n" + injectorMessage.getMessage());
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            OutputUtil.printError((String)"Interrupted.", (Exception)interruptedException);
        }
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 100);
        this.startRunning();
        if (this.returnValue == 128) {
            OutputUtil.printFail();
        } else {
            OutputUtil.printOK();
        }
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.InjectorAns) {
            Ecs.InjectorAns injectorAns = (Ecs.InjectorAns)generatedMessage;
            int n = injectorAns.getErrcode();
            if (n != 0) {
                this.returnValue = 128;
            }
            this.stopRunning();
        }
    }
}

