/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.battery;

import com.google.protobuf.GeneratedMessage;
import org.json.simple.JSONObject;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;

public class BatteryStatusCLI
extends AbstractEmulatorCLI {
    private int retNum = 0;
    private String batteryLevel = null;
    private String charger = null;
    private String TYPE_SENSOR;

    public BatteryStatusCLI() {
        this.messageType = this.TYPE_SENSOR = "sensor";
    }

    public int execute() {
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 100);
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 101);
        this.startRunning();
        return 0;
    }

    public void OnEventProc(String string, JSONObject jSONObject) {
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.InjectorAns) {
            Ecs.InjectorAns injectorAns = (Ecs.InjectorAns)generatedMessage;
            int n = injectorAns.getErrcode();
            if (n != 0) {
                this.returnValue = 128;
                this.clear();
                this.stopRunning();
                return;
            }
            ++this.retNum;
        }
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.InjectorNtf) {
            Ecs.InjectorNtf injectorNtf = (Ecs.InjectorNtf)generatedMessage;
            long l = injectorNtf.getAction();
            if (100L == l) {
                this.batteryLevel = injectorNtf.getData().toStringUtf8();
            } else if (101L == l) {
                this.charger = injectorNtf.getData().toStringUtf8().equals("1") ? "On" : "Off";
            }
            ++this.retNum;
            if (this.retNum == 2) {
                if (this.batteryLevel != null && this.charger != null) {
                    OutputUtil.printOK();
                    OutputUtil.printStatus((String)"level", (String)this.batteryLevel);
                    OutputUtil.printStatus((String)"charger", (String)this.charger);
                } else {
                    this.returnValue = 128;
                    OutputUtil.printFail();
                }
                this.clear();
                this.stopRunning();
            }
        }
    }

    private void clear() {
        this.retNum = 0;
        this.batteryLevel = null;
        this.charger = null;
    }
}

