/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.ecp.dialogs.MessageDialog;
import org.tizen.ecp.location.LocationConstants;
import org.tizen.ecp.location.LocationPage;
import org.tizen.ecp.location.core.injector.LocationInjector;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.sdb.SDBHelperUtil;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.widgets.ECPButton;

public class LocationLogPage
extends LocationPage {
    private ECPButton injectButton;
    private ECPButton cancelButton;
    private ECPButton btnBrowse;
    private Text textLogPath;
    private Timer timer;
    private TimerTask task = new TimerTask(){

        @Override
        public void run() {
        }
    };

    public synchronized void startTask() throws Exception {
        boolean bl = true;
        this.timer = new Timer();
        File file = new File(this.textLogPath.getText());
        if (file.exists()) {
            LocationInjector.getInstance().setMode("1", false);
            bl = SDBHelperUtil.push((String)file.getPath(), (String)"/opt/usr/media/gps-manager/replay/nmea_replay.log");
            if (!bl) {
                new MessageDialog().openErrorDialog("failed to push file");
                return;
            }
            this.timer.schedule(this.task, 0L, 1000L);
        } else {
            new MessageDialog().openErrorDialog("File does not exist.");
        }
    }

    public synchronized void stopTask() {
        if (this.timer != null) {
            this.timer.cancel();
            LocationInjector.getInstance().setMode("0", false);
        }
    }

    void createBorder() {
        Composite composite = FormUtil.createComposite((Composite)this.m_comp);
        composite.setBackground(ColorResources.CONTENTS_BORDER.getColor());
        GridData gridData = FormUtil.createHGD((int)474, (int)1, (int)0, (int)0);
        gridData.horizontalSpan = 3;
        composite.setLayoutData((Object)gridData);
    }

    public void createView(Composite composite) {
        this.createComposite(composite);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        this.m_comp.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        this.m_comp.setLayoutData((Object)new GridData(4, 2, true, false));
        FormUtil.createLabel((Composite)this.m_comp, (String)"Log", (Font)LocationConstants.TITLE_FONT, (Color)LocationConstants.TITLE_COLOR, (int)0);
        this.createBorder();
        FormUtil.createLabel((Composite)this.m_comp, (String)"Log File");
        this.textLogPath = FormUtil.createText((Composite)this.m_comp, (String)"");
        this.textLogPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
            }
        });
        this.btnBrowse = FormUtil.createECPButton((Composite)this.m_comp, (String)"Browse...", (int)8);
        this.btnBrowse.setLayoutData((Object)new GridData(108, 22));
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = "";
                FileDialog fileDialog = new FileDialog(new Shell());
                string = fileDialog.open();
                if (string == null) {
                    return;
                }
                LocationLogPage.this.textLogPath.setText(string);
                LocationLogPage.this.injectButton.setEnabled(LocationLogPage.this.validateFile());
            }
        });
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout2);
        GridData gridData = FormUtil.createFullGD();
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        this.injectButton = FormUtil.createECPButton((Composite)composite2, (String)"Inject Log", (int)8);
        this.injectButton.setLayoutData((Object)new GridData(108, 22));
        this.cancelButton = FormUtil.createECPButton((Composite)composite2, (String)"Cancel", (int)8);
        this.cancelButton.setLayoutData((Object)new GridData(62, 22));
        this.injectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    LocationLogPage.this.startTask();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                LocationLogPage.this.injectButton.setEnabled(false);
                LocationLogPage.this.cancelButton.setEnabled(true);
                LocationLogPage.this.m_sheet.SetActiveWorkPage(LocationLogPage.this.my, true);
            }
        });
        this.injectButton.setEnabled(false);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LocationLogPage.this.stopTask();
                LocationLogPage.this.injectButton.setEnabled(true);
                LocationLogPage.this.cancelButton.setEnabled(false);
                LocationLogPage.this.m_sheet.SetActiveWorkPage(LocationLogPage.this.my, false);
            }
        });
        this.cancelButton.setEnabled(false);
    }

    private boolean validateFile() {
        File file = new File(this.textLogPath.getText());
        if (!file.exists()) {
            return false;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            if (string == null || !string.startsWith("$GP")) {
                bufferedReader.close();
                return false;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException2) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }
}

