/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.ecp.location.LocationConstants;
import org.tizen.ecp.location.LocationPage;
import org.tizen.ecp.location.core.injector.LocationInjector;
import org.tizen.ecp.location.core.protocol.GeoLocation;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.widgets.ECPButton;

public class LocationManualPage
extends LocationPage {
    private static Logger logger = LogUtil.getECPLogger(LocationManualPage.class).getLogger();
    private Text latitudeText;
    private Text longitudeText;
    private Text altitudeText;
    private Text accuracyText;
    private ECPButton injectButton;
    private ECPButton cancelButton;
    GeoLocation location;
    private LocationInjector injector = null;
    private Timer timer;
    InjectTask task = null;
    boolean isStop = false;

    public synchronized void startTask() {
        this.timer = new Timer();
        if (this.task == null) {
            this.task = new InjectTask();
        }
        LocationInjector.getInstance().setMode("2", false);
        this.timer.schedule((TimerTask)this.task, 0L, 1000L);
    }

    public synchronized void stopTask() {
        if (this.timer != null) {
            this.timer.cancel();
            LocationInjector.getInstance().setMode("0", false);
            this.isStop = true;
        }
    }

    void createBorder() {
        Composite composite = FormUtil.createComposite((Composite)this.m_comp);
        composite.setBackground(ColorResources.CONTENTS_BORDER.getColor());
        GridData gridData = FormUtil.createHGD((int)474, (int)1, (int)0, (int)0);
        gridData.horizontalSpan = 3;
        composite.setLayoutData((Object)gridData);
    }

    protected void setLocation(String string, String string2, String string3, String string4) {
        if (string == null) {
            this.latitudeText.clearSelection();
        } else {
            this.latitudeText.setText(string);
        }
        if (string2 == null) {
            this.longitudeText.clearSelection();
        } else {
            this.longitudeText.setText(string2);
        }
        if (string3 == null) {
            this.altitudeText.clearSelection();
        } else {
            this.altitudeText.setText(string3);
        }
        if (string4 == null) {
            this.accuracyText.clearSelection();
        } else {
            this.accuracyText.setText(string4);
        }
    }

    protected GeoLocation getLocation() {
        return this.location;
    }

    protected boolean checkMaxTextLength(String string) {
        if (!string.isEmpty()) {
            int n = Double.parseDouble(string) > 100.0 ? 10 : 9;
            return string.length() <= n;
        }
        logger.info("text is empty");
        return false;
    }

    public void createView(Composite composite) {
        this.createComposite(composite);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.m_comp.setLayout((Layout)gridLayout);
        this.m_comp.setLayoutData((Object)new GridData(4, 2, true, false));
        FormUtil.createLabel((Composite)this.m_comp, (String)"Manual", (Font)LocationConstants.TITLE_FONT, (Color)LocationConstants.TITLE_COLOR, (int)0);
        this.createBorder();
        FormUtil.createLabel((Composite)this.m_comp, (String)"Latitude");
        this.latitudeText = FormUtil.createText((Composite)this.m_comp, (String)"");
        this.latitudeText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                block7: {
                    String string = LocationManualPage.this.latitudeText.getText();
                    String string2 = verifyEvent.text;
                    char[] cArray = string2.toCharArray();
                    String string3 = string.substring(0, verifyEvent.start) + verifyEvent.text + string.substring(verifyEvent.end);
                    for (int i = 0; i < cArray.length; ++i) {
                        if (Character.isDigit(cArray[i]) || cArray[i] == '.' || cArray[i] == '+' || cArray[i] == '-') continue;
                        verifyEvent.doit = false;
                        break;
                    }
                    if (string3.isEmpty()) {
                        verifyEvent.doit = true;
                        return;
                    }
                    char[] cArray2 = string3.toCharArray();
                    try {
                        int n = 0;
                        int n2 = 0;
                        double d = Double.valueOf(string3);
                        for (int i = 0; i < cArray2.length; ++i) {
                            if (cArray2[i] != '.') continue;
                            n = i;
                            break;
                        }
                        if ((n2 = cArray2.length - n) > 7) {
                            verifyEvent.doit = false;
                            return;
                        }
                        if (d < -90.0 || d > 90.0) {
                            verifyEvent.doit = false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (cArray2[0] == '-' || cArray2[0] == '+') break block7;
                        verifyEvent.doit = false;
                    }
                }
            }
        });
        this.latitudeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                LocationManualPage.this.injectButton.setEnabled(LocationManualPage.this.validateValues());
            }
        });
        FormUtil.createLabel((Composite)this.m_comp, (String)"(-90 ~ +90)");
        FormUtil.createLabel((Composite)this.m_comp, (String)"Longitude");
        this.longitudeText = FormUtil.createText((Composite)this.m_comp, (String)"");
        this.longitudeText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                block7: {
                    String string = LocationManualPage.this.longitudeText.getText();
                    String string2 = verifyEvent.text;
                    char[] cArray = string2.toCharArray();
                    String string3 = string.substring(0, verifyEvent.start) + verifyEvent.text + string.substring(verifyEvent.end);
                    for (int i = 0; i < cArray.length; ++i) {
                        if (Character.isDigit(cArray[i]) || cArray[i] == '.' || cArray[i] == '+' || cArray[i] == '-') continue;
                        verifyEvent.doit = false;
                        break;
                    }
                    if (string3.isEmpty()) {
                        verifyEvent.doit = true;
                        return;
                    }
                    char[] cArray2 = string3.toCharArray();
                    try {
                        int n = 0;
                        int n2 = 0;
                        double d = Double.valueOf(string3);
                        for (int i = 0; i < cArray2.length; ++i) {
                            if (cArray2[i] != '.') continue;
                            n = i;
                            break;
                        }
                        if ((n2 = cArray2.length - n) > 7) {
                            verifyEvent.doit = false;
                            return;
                        }
                        if (d < -180.0 || d > 180.0) {
                            verifyEvent.doit = false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (cArray2[0] == '-' || cArray2[0] == '+') break block7;
                        verifyEvent.doit = false;
                    }
                }
            }
        });
        this.longitudeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                LocationManualPage.this.injectButton.setEnabled(LocationManualPage.this.validateValues());
            }
        });
        FormUtil.createLabel((Composite)this.m_comp, (String)"(-180 ~ +180)");
        FormUtil.createLabel((Composite)this.m_comp, (String)"Altitude");
        this.altitudeText = FormUtil.createText((Composite)this.m_comp, (String)"");
        this.altitudeText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                block7: {
                    String string = LocationManualPage.this.altitudeText.getText();
                    String string2 = verifyEvent.text;
                    char[] cArray = string2.toCharArray();
                    String string3 = string.substring(0, verifyEvent.start) + verifyEvent.text + string.substring(verifyEvent.end);
                    for (int i = 0; i < cArray.length; ++i) {
                        if (Character.isDigit(cArray[i]) || cArray[i] == '.' || cArray[i] == '+' || cArray[i] == '-') continue;
                        verifyEvent.doit = false;
                        break;
                    }
                    if (string3.isEmpty()) {
                        verifyEvent.doit = true;
                        return;
                    }
                    char[] cArray2 = string3.toCharArray();
                    try {
                        int n = 0;
                        int n2 = 0;
                        double d = Double.valueOf(string3);
                        for (int i = 0; i < cArray2.length; ++i) {
                            if (cArray2[i] != '.') continue;
                            n = i;
                            break;
                        }
                        if ((n2 = cArray2.length - n) > 7) {
                            verifyEvent.doit = false;
                            return;
                        }
                        if (d < -300.0 || d > 100000.0) {
                            verifyEvent.doit = false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (cArray2[0] == '-' || cArray2[0] == '+') break block7;
                        verifyEvent.doit = false;
                    }
                }
            }
        });
        this.altitudeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                LocationManualPage.this.injectButton.setEnabled(LocationManualPage.this.validateValues());
            }
        });
        FormUtil.createLabel((Composite)this.m_comp, (String)"(-300 ~ +100000)");
        FormUtil.createLabel((Composite)this.m_comp, (String)"Horizontal Accuracy");
        this.accuracyText = FormUtil.createText((Composite)this.m_comp, (String)"");
        this.accuracyText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                block7: {
                    String string = LocationManualPage.this.accuracyText.getText();
                    String string2 = verifyEvent.text;
                    char[] cArray = string2.toCharArray();
                    String string3 = string.substring(0, verifyEvent.start) + verifyEvent.text + string.substring(verifyEvent.end);
                    for (int i = 0; i < cArray.length; ++i) {
                        if (Character.isDigit(cArray[i]) || cArray[i] == '.' || cArray[i] == '+' || cArray[i] == '-') continue;
                        verifyEvent.doit = false;
                        break;
                    }
                    if (string3.isEmpty()) {
                        verifyEvent.doit = true;
                        return;
                    }
                    char[] cArray2 = string3.toCharArray();
                    try {
                        int n = 0;
                        int n2 = 0;
                        double d = Double.valueOf(string3);
                        for (int i = 0; i < cArray2.length; ++i) {
                            if (cArray2[i] != '.') continue;
                            n = i;
                            break;
                        }
                        if ((n2 = cArray2.length - n) > 7) {
                            verifyEvent.doit = false;
                            return;
                        }
                        if (d < 0.0 || d > 100000.0) {
                            verifyEvent.doit = false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (cArray2[0] == '-' || cArray2[0] == '+') break block7;
                        verifyEvent.doit = false;
                    }
                }
            }
        });
        this.accuracyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                LocationManualPage.this.injectButton.setEnabled(LocationManualPage.this.validateValues());
            }
        });
        FormUtil.createLabel((Composite)this.m_comp, (String)"(0 ~ +100000)");
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout2);
        GridData gridData = FormUtil.createFullGD();
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        this.injectButton = FormUtil.createECPButton((Composite)composite2, (String)"Inject Location", (int)8);
        this.injectButton.setLayoutData((Object)new GridData(108, 22));
        this.cancelButton = FormUtil.createECPButton((Composite)composite2, (String)"Cancel", (int)8);
        this.cancelButton.setLayoutData((Object)new GridData(62, 22));
        this.injectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (LocationManualPage.this.injector != null && !LocationManualPage.this.isStop) {
                    LocationManualPage.this.injectButton.setEnabled(false);
                    Double d = Double.parseDouble(LocationManualPage.this.latitudeText.getText().trim());
                    Double d2 = Double.parseDouble(LocationManualPage.this.longitudeText.getText().trim());
                    Double d3 = Double.parseDouble(LocationManualPage.this.altitudeText.getText().trim());
                    Double d4 = Double.parseDouble(LocationManualPage.this.accuracyText.getText().trim());
                    logger.info("latitude: " + d + ", longitude: " + d2 + ", altitude: " + d3 + ", accuracy: " + d4);
                    String string = LocationConstants.DF.format(d);
                    String string2 = LocationConstants.DF.format(d2);
                    String string3 = LocationConstants.DF.format(d3);
                    String string4 = LocationConstants.DF.format(d4);
                    LocationManualPage.this.location = new GeoLocation(string, string2, string3, string4);
                    LocationManualPage.this.injector.injectChange(LocationManualPage.this.location);
                    return;
                }
                Double d = Double.parseDouble(LocationManualPage.this.latitudeText.getText().trim());
                Double d5 = Double.parseDouble(LocationManualPage.this.longitudeText.getText().trim());
                Double d6 = Double.parseDouble(LocationManualPage.this.altitudeText.getText().trim());
                Double d7 = Double.parseDouble(LocationManualPage.this.accuracyText.getText().trim());
                logger.info("latitude: " + d + ", longitude: " + d5 + ", altitude: " + d6 + ", accuracy: " + d7);
                String string = LocationConstants.DF.format(d);
                String string5 = LocationConstants.DF.format(d5);
                String string6 = LocationConstants.DF.format(d6);
                String string7 = LocationConstants.DF.format(d7);
                LocationManualPage.this.location = new GeoLocation(string, string5, string6, string7);
                LocationManualPage.this.timer = new Timer();
                LocationManualPage.this.task = new InjectTask();
                LocationManualPage.this.startTask();
                LocationManualPage.this.injectButton.setEnabled(false);
                LocationManualPage.this.cancelButton.setEnabled(true);
                LocationManualPage.this.m_sheet.SetActiveWorkPage(LocationManualPage.this.my, true);
            }
        });
        this.injectButton.setEnabled(false);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LocationManualPage.this.stopTask();
                LocationManualPage.this.injectButton.setEnabled(LocationManualPage.this.validateValues());
                LocationManualPage.this.cancelButton.setEnabled(false);
                LocationManualPage.this.m_sheet.SetActiveWorkPage(LocationManualPage.this.my, false);
            }
        });
        this.cancelButton.setEnabled(false);
    }

    boolean validateValues() {
        if (!this.latitudeText.getText().matches("[+|-]*[0-9]*[.]?[0-9]+")) {
            this.injectButton.setEnabled(false);
            return false;
        }
        double d = Double.parseDouble(this.latitudeText.getText());
        if (d > 90.0 || d < -90.0) {
            return false;
        }
        if (!this.longitudeText.getText().matches("[+|-]*[0-9]*[.]?[0-9]+")) {
            this.injectButton.setEnabled(false);
            return false;
        }
        d = Double.parseDouble(this.longitudeText.getText());
        if (d > 180.0 || d < -180.0) {
            return false;
        }
        if (!this.altitudeText.getText().matches("[+|-]*[0-9]*[.]?[0-9]+")) {
            this.injectButton.setEnabled(false);
            return false;
        }
        d = Double.parseDouble(this.altitudeText.getText());
        if (d > 100000.0 || d < -300.0) {
            return false;
        }
        if (!this.accuracyText.getText().matches("[+]*[0-9]*[.]?[0-9]+")) {
            this.injectButton.setEnabled(false);
            return false;
        }
        d = Double.parseDouble(this.accuracyText.getText());
        return !(d > 100000.0) && !(d < 0.0);
    }

    class InjectTask
    extends TimerTask {
        InjectTask() {
        }

        @Override
        public void run() {
            boolean bl = true;
            LocationManualPage.this.injector = new LocationInjector();
            bl = LocationManualPage.this.injector.inject(LocationManualPage.this.location);
            if (!bl) {
                LocationManualPage.this.stopTask();
            }
        }
    }
}

