/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.ecp.location.CheckNetThread;
import org.tizen.ecp.location.LocationConstants;
import org.tizen.ecp.location.LocationPage;
import org.tizen.ecp.location.core.injector.LocationInjector;
import org.tizen.ecp.location.core.model.GeoLocationVO;
import org.tizen.ecp.location.core.protocol.GeoLocation;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.widgets.ECPButton;

public class LocationMapPage
extends LocationPage {
    Logger logger = LogUtil.getECPLogger(LocationMapPage.class).getLogger();
    private Browser m_browser;
    private String m_googleMapScript;
    private Table m_locmakerList;
    private ArrayList<GeoLocationVO> locationVO = new ArrayList();
    private ECPButton injectButton;
    private ECPButton resetButton;
    private ECPButton cancelButton;
    private int SET_MARKERS_TIMER = 200;
    private static LocationMapPage instance = new LocationMapPage();
    private LocationInjector injector = null;
    private Timer timer;
    private InjectTask task = null;
    private String host = null;
    private int port = -1;

    public static LocationMapPage getInstance() {
        return instance;
    }

    void createBorder() {
        Composite composite = FormUtil.createComposite((Composite)this.m_comp);
        composite.setBackground(ColorResources.CONTENTS_BORDER.getColor());
        GridData gridData = FormUtil.createHGD((int)474, (int)1, (int)0, (int)0);
        composite.setLayoutData((Object)gridData);
    }

    public Table createTable(Composite composite, String[] stringArray, int n, int n2) {
        Table table = new Table(composite, n2);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.heightHint = 120;
        gridData.horizontalSpan = n;
        table.setLayoutData((Object)gridData);
        TableColumn tableColumn = null;
        for (int i = 0; i < stringArray.length; ++i) {
            tableColumn = new TableColumn(table, 0);
            tableColumn.setText(stringArray[i]);
            if (i == 0) {
                tableColumn.setWidth(50);
                continue;
            }
            tableColumn.setWidth(200);
        }
        return table;
    }

    public void createLocationMaker() {
        String[] stringArray = new String[]{"Seq", "Latitude", "Longitude"};
        this.m_locmakerList = this.createTable(this.m_comp, stringArray, 1, 2816);
        GridData gridData = FormUtil.createHGD((int)474, (int)123, (int)0, (int)0);
        this.m_locmakerList.setLayoutData((Object)gridData);
    }

    public void createView(Composite composite) {
        this.createComposite(composite);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.m_comp.setLayout((Layout)gridLayout);
        this.m_comp.setLayoutData((Object)new GridData(4, 2, true, false));
        FormUtil.createLabel((Composite)this.m_comp, (String)"Map Image", (Font)LocationConstants.TITLE_FONT, (Color)LocationConstants.TITLE_COLOR, (int)0);
        this.createBorder();
        this.m_browser = this.createBrowser(this.m_comp);
        this.m_browser.setToolTipText("Mouse left-click to move the map.\nMouse right-click to set the marker.");
        FormUtil.createLabel((Composite)this.m_comp, (String)"Location Markers", (Font)LocationConstants.TITLE_FONT, (Color)LocationConstants.TEXT_COLOR, (int)0);
        this.createLocationMaker();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout2 = new GridLayout(3, false);
        gridLayout2.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout2);
        this.injectButton = FormUtil.createECPButton((Composite)composite2, (String)"Inject Markers", (int)8);
        this.resetButton = FormUtil.createECPButton((Composite)composite2, (String)"Reset Markers", (int)8);
        this.cancelButton = FormUtil.createECPButton((Composite)composite2, (String)"Cancel", (int)8);
        this.injectButton.setLayoutData((Object)new GridData(108, 22));
        this.resetButton.setLayoutData((Object)new GridData(108, 22));
        this.cancelButton.setLayoutData((Object)new GridData(62, 22));
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                LocationMapPage.this.createGoogleMapScript();
                LocationMapPage.this.createMap();
                LocationMapPage.this.setButtonHandlers();
            }
        });
    }

    public synchronized void startTask() {
        this.timer = new Timer();
        if (this.task == null) {
            this.task = new InjectTask();
        }
        LocationInjector.getInstance().setMode("2", false);
        this.timer.schedule((TimerTask)this.task, 0L, 1000L);
    }

    public synchronized void stopTask() {
        if (this.timer != null) {
            this.timer.cancel();
            LocationInjector.getInstance().setMode("0", false);
        }
    }

    private void setButtonHandlers() {
        this.injectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LocationMapPage.this.task = new InjectTask();
                LocationMapPage.this.startTask();
                LocationMapPage.this.injectButton.setEnabled(false);
                LocationMapPage.this.m_browser.setEnabled(false);
                LocationMapPage.this.cancelButton.setEnabled(true);
                LocationMapPage.this.resetButton.setEnabled(false);
                LocationMapPage.this.m_sheet.SetActiveWorkPage(LocationMapPage.this.my, true);
            }
        });
        this.injectButton.setEnabled(this.validate());
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (LocationMapPage.this.m_browser != null) {
                    try {
                        boolean bl = LocationMapPage.this.m_browser.execute("deleteMarkers()");
                        LocationMapPage.this.logger.info("[Map] Browser execute deleteMakers() : " + (bl ? "Success" : "Fail"));
                        if (!bl) {
                            bl = LocationMapPage.this.m_browser.setText(LocationMapPage.this.m_googleMapScript);
                            LocationMapPage.this.logger.info("[Map] Browser reload : " + (bl ? "Success" : "Fail"));
                        }
                        LocationMapPage.this.locationVO.clear();
                        LocationMapPage.this.m_locmakerList.removeAll();
                        LocationMapPage.this.injectButton.setEnabled(LocationMapPage.this.validate());
                        LocationMapPage.this.resetButton.setEnabled(LocationMapPage.this.validate());
                    }
                    catch (SWTException sWTException) {
                        sWTException.printStackTrace();
                    }
                } else {
                    LocationMapPage.this.logger.severe("Browser not created.");
                }
            }
        });
        this.resetButton.setEnabled(this.validate());
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LocationMapPage.this.stopTask();
                LocationMapPage.this.injectButton.setEnabled(true);
                LocationMapPage.this.m_browser.setEnabled(true);
                LocationMapPage.this.resetButton.setEnabled(true);
                LocationMapPage.this.cancelButton.setEnabled(false);
                LocationMapPage.this.m_sheet.SetActiveWorkPage(LocationMapPage.this.my, false);
            }
        });
        this.cancelButton.setEnabled(false);
    }

    public void setMarkers() {
        try {
            int n = ((Double)this.m_browser.evaluate("return markersArray.length;")).intValue();
            if (this.locationVO.size() == n) {
                return;
            }
            if (this.locationVO.size() == n - 1) {
                int n2 = n - 1;
                Double d = (Double)this.m_browser.evaluate("return markersArray[" + n2 + "].getPosition().lat();");
                Double d2 = (Double)this.m_browser.evaluate("return markersArray[" + n2 + "].getPosition().lng();");
                LocationConstants.DF.format(d);
                GeoLocationVO geoLocationVO = new GeoLocationVO();
                String string = LocationConstants.DF.format(d);
                String string2 = LocationConstants.DF.format(d2);
                GeoLocation geoLocation = new GeoLocation(string, string2);
                geoLocationVO.setSeq(n);
                geoLocationVO.setLocation(geoLocation);
                this.locationVO.add(geoLocationVO);
                TableItem tableItem = new TableItem(this.m_locmakerList, 0);
                String[] stringArray = new String[]{geoLocationVO.getColumnValue(0).toString(), string, string2};
                tableItem.setText(stringArray);
            } else {
                this.m_locmakerList.clearAll();
                for (int i = 0; i < n; ++i) {
                    Double d = (Double)this.m_browser.evaluate("return markersArray[" + i + "].getPosition().lat();");
                    Double d3 = (Double)this.m_browser.evaluate("return markersArray[" + i + "].getPosition().lng();");
                    GeoLocationVO geoLocationVO = new GeoLocationVO();
                    GeoLocation geoLocation = new GeoLocation(d, d3);
                    geoLocationVO.setSeq(i + 1);
                    geoLocationVO.setLocation(geoLocation);
                    TableItem tableItem = new TableItem(this.m_locmakerList, 0);
                    String[] stringArray = new String[]{geoLocationVO.getColumnValue(0).toString(), geoLocationVO.getColumnValue(1).toString(), geoLocationVO.getColumnValue(2).toString()};
                    tableItem.setText(stringArray);
                    this.locationVO.add(geoLocationVO);
                }
                this.m_comp.layout();
                this.m_locmakerList.layout();
            }
            this.injectButton.setEnabled(this.validate());
            this.resetButton.setEnabled(this.validate());
        }
        catch (SWTException sWTException) {
            this.logger.info(sWTException.getMessage());
            return;
        }
    }

    private void createMap() {
        this.m_browser.setJavascriptEnabled(true);
        this.m_browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent progressEvent) {
                LocationMapPage.this.logger.info("[Map] Map Loading: Compelete");
            }

            public void changed(ProgressEvent progressEvent) {
                LocationMapPage.this.logger.info("[Map] Map Changed");
            }
        });
        this.m_browser.setText(this.m_googleMapScript);
        this.m_browser.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (mouseEvent.button == 3) {
                    Display.getCurrent().timerExec(LocationMapPage.this.SET_MARKERS_TIMER, new Runnable(){

                        @Override
                        public void run() {
                            LocationMapPage.this.setMarkers();
                        }
                    });
                }
            }
        });
        GridData gridData = FormUtil.createHGD((int)474, (int)170, (int)0, (int)0);
        this.m_browser.setLayoutData((Object)gridData);
    }

    private boolean checkProxy() {
        System.setProperty("java.net.useSystemProxies", "true");
        try {
            List<Proxy> list = ProxySelector.getDefault().select(new URI("http://maps.google.com"));
            Iterator<Proxy> iterator = list.iterator();
            if (iterator.hasNext()) {
                Proxy proxy = iterator.next();
                this.logger.info("proxy hostname : " + (Object)((Object)proxy.type()));
                InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
                if (inetSocketAddress == null) {
                    this.logger.info("no proxy");
                    return false;
                }
                this.host = inetSocketAddress.getHostName();
                this.port = inetSocketAddress.getPort();
                this.logger.info("proxy hostname : " + this.host);
                this.logger.info("proxy port : " + this.port);
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            this.logger.severe("check the URI syntax.");
        }
        catch (Exception exception) {
            this.logger.severe("checkProxy() : " + exception.getMessage());
        }
        return false;
    }

    private void createGoogleMapScript() {
        CheckNetThread checkNetThread = new CheckNetThread();
        boolean bl = this.checkProxy();
        if (bl) {
            this.logger.info("use proxy");
            System.setProperty("java.net.useSystemProxies", "false");
        }
        try {
            checkNetThread.start();
            checkNetThread.join();
        }
        catch (InterruptedException interruptedException) {
            this.m_googleMapScript = checkNetThread.errorMsg;
            return;
        }
        if (checkNetThread.isError()) {
            this.m_googleMapScript = checkNetThread.getErrorMsg();
            return;
        }
        if (bl && this.host != null) {
            this.logger.info("host: " + this.host);
            System.setProperty("network.proxy_host", this.host);
            if (this.port != -1) {
                this.logger.info("port: " + this.port);
                System.setProperty("network.proxy_port", "" + this.port);
            }
        }
        this.m_googleMapScript = "<!DOCTYPE html><html><head><meta name=\"viewport\" content=\"initial-scale=1.0, user-scalable=no\" /><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"/><style type=\"text/css\">html { height: 100% }body { height: 100%; margin: 0px; padding: 0px }#map_canvas { height: 100% }</style><script type=\"text/javascript\" src=\"http://maps.google.com/maps/api/js?sensor=false\"></script><script type=\"text/javascript\">var map;var markersArray = [];function initialize() {var latlng = new google.maps.LatLng(37.259, 127.055);var myOptions = {zoom: 16,center: latlng,disableDoubleClickZoom: true,keyboardShortcuts: false,draggable: false,mapTypeId: google.maps.MapTypeId.ROADMAP};map = new google.maps.Map(document.getElementById(\"map_canvas\"), myOptions);google.maps.event.addListener(map, 'rightclick', function(event) {placeMarker(event.latLng);});google.maps.event.addListener(map, 'click', function(event) {map.setCenter(event.latLng);});}function placeMarker(location) {var clickedLocation = new google.maps.LatLng(location);var marker = new google.maps.Marker({position: location,map: map});markersArray.push(marker);}function deleteMarkers() {if (markersArray) {for (i in markersArray) {markersArray[i].setMap(null);}markersArray.length = 0;}}</script></head><body oncontextmenu='return false' onload=\"initialize();\"><div id=\"map_canvas\" style=\"width:100%; height:100%\"></div></body></html>";
    }

    public Browser createBrowser(Composite composite) {
        final Browser browser = new Browser(composite, 2048);
        String string = browser.getBrowserType();
        this.logger.info("browser type: " + string);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 180;
        gridData.minimumWidth = 250;
        browser.setLayoutData((Object)gridData);
        browser.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                int n = browser.getBounds().x;
                int n2 = browser.getBounds().y;
                paintEvent.gc.drawLine(n, n2 - 23, n + browser.getBounds().width, n2 - 23);
            }
        });
        return browser;
    }

    private boolean validate() {
        return this.locationVO.size() > 0;
    }

    class InjectTask
    extends TimerTask {
        InjectTask() {
        }

        @Override
        public void run() {
            LocationMapPage.this.injector = new LocationInjector();
            if (!LocationMapPage.this.injector.inject(LocationMapPage.this.locationVO)) {
                LocationMapPage.this.stopTask();
            }
        }
    }
}

