/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location.core.protocol;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.tizen.ecp.location.core.protocol.AbstractNMEA0183;
import org.tizen.ecp.location.core.protocol.GeoLocation;

public class NMEA0183_GPRMC
extends AbstractNMEA0183 {
    private Date currentDate = new Date();
    private String time;
    private String status = "A";
    private GeoLocation location;
    private double speed = 0.0;
    private double track = 0.0;
    private String date;
    private String magenticDirection = "A";

    public NMEA0183_GPRMC() {
        this(0.0, 0.0);
    }

    public NMEA0183_GPRMC(double d, double d2) {
        super("GPRMC");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HHmmss.0");
        this.time = simpleDateFormat.format(this.currentDate);
        this.location = new GeoLocation(d, d2);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("ddMMyy");
        this.date = simpleDateFormat2.format(this.currentDate);
        this.createSentence();
    }

    @Override
    protected void createBody() {
        DecimalFormat decimalFormat = new DecimalFormat("0000.000000");
        DecimalFormat decimalFormat2 = new DecimalFormat("00000.000000");
        DecimalFormat decimalFormat3 = new DecimalFormat("000.0");
        this.getBody().add(this.time);
        this.getBody().add(this.status);
        this.getBody().add(decimalFormat.format(this.location.getNMEAlatitude()));
        this.getBody().add(this.location.getNorthSouth());
        this.getBody().add(decimalFormat2.format(this.location.getNMEAlongitude()));
        this.getBody().add(this.location.getEastWest());
        this.getBody().add(decimalFormat3.format(this.speed));
        this.getBody().add(decimalFormat3.format(this.track));
        this.getBody().add(this.date);
        this.getBody().add(NULL);
        this.getBody().add(NULL);
        this.getBody().add(this.magenticDirection);
    }

    @Override
    protected boolean validate() {
        return true;
    }
}

