/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.geo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.sensor.geo.GeoFileFinished;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.LogUtil;

public class GeoFileOperation {
    private static final int MAX_GEO = 2000;
    private static final double GEO_ADJUST = 1.0;
    private static GeoFileOperation instance = new GeoFileOperation();
    private Logger logger = LogUtil.getECPLogger(GeoFileOperation.class).getLogger();
    private Thread geoThread = null;
    private List<String> pathList = new ArrayList<String>();
    private int repeatCount = 0;
    private List<GeoFileFinished> fileList = new ArrayList<GeoFileFinished>();

    public static GeoFileOperation getInstance() {
        return instance;
    }

    public void addFile(String string) {
        this.pathList.add(string);
    }

    public void setRepeatCount(int n) {
        this.repeatCount = n;
    }

    public void startInjection() {
        this.geoThread = new Thread(new Runnable(){

            @Override
            public void run() {
                GeoFileOperation.this.fileOps();
            }
        });
        this.geoThread.start();
    }

    public void stopInjection() {
        this.pathList.clear();
        this.repeatCount = 0;
        try {
            this.geoThread.interrupt();
            this.geoThread.join();
        }
        catch (InterruptedException interruptedException) {
            this.logger.log(Level.SEVERE, "stopGeoInjection interrupted.", interruptedException);
        }
    }

    public boolean onceInjection(String string) throws InterruptedException {
        if (this.geoThread != null) {
            return false;
        }
        this.addFile(string);
        this.setRepeatCount(1);
        this.startInjection();
        this.geoThread.join();
        return true;
    }

    public void sendMessage(double d, double d2, double d3) {
        this.logger.log(Level.FINE, "inject: " + d + ", " + d2 + ", " + d3);
        InjectorMessage injectorMessage = new InjectorMessage(d, d2, d3);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "5\n" + injectorMessage.getMessage());
    }

    public void registerFileOperation(GeoFileFinished geoFileFinished) {
        this.fileList.add(geoFileFinished);
    }

    private void fileOps() {
        int n = 0;
        int n2 = 0;
        String string = null;
        BufferedReader bufferedReader = null;
        for (String object : this.pathList) {
            this.logger.log(Level.FINE, "fileOps path: " + object);
        }
        this.logger.log(Level.FINE, "repeat count: " + this.repeatCount);
        block14: for (int i = 0; i < this.repeatCount; ++i) {
            for (String string2 : this.pathList) {
                File file = new File(string2);
                if (!file.exists()) {
                    this.logger.log(Level.SEVERE, "file path does not exist : " + string2);
                    continue;
                }
                try {
                    bufferedReader = new BufferedReader(new FileReader(file));
                    while ((string = bufferedReader.readLine()) != null) {
                        double d;
                        double d2;
                        double d3;
                        block31: {
                            String[] stringArray = string.split(",");
                            try {
                                n2 = Integer.parseInt(stringArray[0]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                n2 = n + 1;
                            }
                            int n3 = (n2 - n) * 10;
                            if (n3 < 0) {
                                n3 = 1000;
                                n = 0;
                                n2 = n + 1;
                            }
                            Thread.sleep(n3);
                            n = n2;
                            try {
                                if (stringArray[1] == null || stringArray[1].isEmpty()) {
                                    d3 = 0.0;
                                } else {
                                    d3 = Double.parseDouble(stringArray[1]) * 1.0;
                                    if (d3 > 2000.0) {
                                        d3 = 2000.0;
                                    }
                                    if (d3 < -2000.0) {
                                        d3 = -2000.0;
                                    }
                                }
                                if (stringArray[2] == null || stringArray[2].isEmpty()) {
                                    d2 = 0.0;
                                } else {
                                    d2 = Double.parseDouble(stringArray[2]) * 1.0;
                                    if (d2 > 2000.0) {
                                        d2 = 2000.0;
                                    }
                                    if (d2 < -2000.0) {
                                        d2 = -2000.0;
                                    }
                                }
                                if (stringArray[3] == null || stringArray[3].isEmpty()) {
                                    d = 0.0;
                                    break block31;
                                }
                                d = Double.parseDouble(stringArray[2]) * 1.0;
                                if (d > 2000.0) {
                                    d = 2000.0;
                                }
                                if (!(d < -2000.0)) break block31;
                                d = -2000.0;
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.logger.log(Level.SEVERE, "number format exception: xyz", numberFormatException);
                                continue;
                            }
                        }
                        this.sendMessage(d3, d2, d);
                    }
                }
                catch (IOException iOException) {
                    this.logger.log(Level.SEVERE, "IOexception", iOException);
                    if (bufferedReader == null) continue;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {
                        this.logger.log(Level.SEVERE, "IO exception for Buffered Reader", iOException2);
                    }
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    this.logger.log(Level.SEVERE, "Interrupt exception", interruptedException);
                    if (bufferedReader == null) continue block14;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        this.logger.log(Level.SEVERE, "IO exception for Buffered Reader", iOException);
                    }
                    continue block14;
                }
                if (bufferedReader == null) continue;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    this.logger.log(Level.SEVERE, "IO exception for Buffered Reader", iOException);
                }
            }
        }
        this.pathList.clear();
        this.repeatCount = 0;
        if (!this.fileList.isEmpty()) {
            for (GeoFileFinished geoFileFinished : this.fileList) {
                geoFileFinished.fileOpsFinished();
            }
        }
    }
}

